/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Length;
import com.novell.ldap.asn1.ASN1Null;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.asn1.ASN1Tagged;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class LBERDecoder
implements ASN1Decoder {
    private ASN1Identifier asn1ID = new ASN1Identifier();
    private ASN1Length asn1Len = new ASN1Length();

    public ASN1Object decode(byte[] value) {
        ASN1Object asn1 = null;
        ByteArrayInputStream in = new ByteArrayInputStream(value);
        try {
            asn1 = this.decode(in);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return asn1;
    }

    public ASN1Object decode(InputStream in) throws IOException {
        int[] len = new int[1];
        return this.decode(in, len);
    }

    public ASN1Object decode(InputStream in, int[] len) throws IOException {
        this.asn1ID.reset(in);
        this.asn1Len.reset(in);
        int length = this.asn1Len.getLength();
        len[0] = this.asn1ID.getEncodedLength() + this.asn1Len.getEncodedLength() + length;
        if (this.asn1ID.isUniversal()) {
            switch (this.asn1ID.getTag()) {
                case 16: {
                    return new ASN1Sequence(this, in, length);
                }
                case 17: {
                    return new ASN1Set(this, in, length);
                }
                case 1: {
                    return new ASN1Boolean(this, in, length);
                }
                case 2: {
                    return new ASN1Integer(this, in, length);
                }
                case 4: {
                    return new ASN1OctetString(this, in, length);
                }
                case 10: {
                    return new ASN1Enumerated(this, in, length);
                }
                case 5: {
                    return new ASN1Null();
                }
            }
            throw new EOFException("Unknown tag");
        }
        return new ASN1Tagged(this, in, length, (ASN1Identifier)this.asn1ID.clone());
    }

    public final Object decodeBoolean(InputStream in, int len) throws IOException {
        byte[] lber = new byte[len];
        int i = in.read(lber);
        if (i != len) {
            throw new EOFException("LBER: BOOLEAN: decode error: EOF");
        }
        return lber[0] == 0 ? new Boolean(false) : new Boolean(true);
    }

    public final Object decodeNumeric(InputStream in, int len) throws IOException {
        long l = 0L;
        int r = in.read();
        if (r < 0) {
            throw new EOFException("LBER: NUMERIC: decode error: EOF");
        }
        if ((r & 0x80) != 0) {
            l = -1L;
        }
        l = l << 8 | (long)r;
        for (int i = 1; i < len; ++i) {
            r = in.read();
            if (r < 0) {
                throw new EOFException("LBER: NUMERIC: decode error: EOF");
            }
            l = l << 8 | (long)r;
        }
        return new Long(l);
    }

    public final Object decodeOctetString(InputStream in, int len) throws IOException {
        int inLen;
        byte[] octets = new byte[len];
        for (int totalLen = 0; totalLen < len; totalLen += inLen) {
            inLen = in.read(octets, totalLen, len - totalLen);
        }
        return octets;
    }

    public final Object decodeCharacterString(InputStream in, int len) throws IOException {
        byte[] octets = new byte[len];
        for (int i = 0; i < len; ++i) {
            int ret = in.read();
            if (ret == -1) {
                throw new EOFException("LBER: CHARACTER STRING: decode error: EOF");
            }
            octets[i] = (byte)ret;
        }
        return new String(octets, "UTF8");
    }
}

