/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.variables;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.variables.Variable;
import org.silverpeas.core.variables.VariableScheduledValue;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.variables.VariableEntity;
import org.silverpeas.core.webapi.variables.VariableScheduledValueEntity;
import org.silverpeas.core.webapi.variables.VariablesWebManager;

@WebService
@Path(value="variables")
@Authenticated
public class VariablesResource
extends RESTWebService {
    static final String PATH = "variables";
    @Inject
    private VariablesWebManager webManager;

    @GET
    @Produces(value={"application/json"})
    public List<VariableEntity> getAllVariables() {
        List<Variable> allVariables = this.webManager.getAllVariables();
        return this.asWebEntities(allVariables);
    }

    @GET
    @Path(value="/currents")
    @Produces(value={"application/json"})
    public List<VariableEntity> getCurrentVariables() {
        List<Variable> variables = this.webManager.getCurrentVariables();
        return this.asWebEntities(variables);
    }

    @GET
    @Path(value="/{variableId}")
    @Produces(value={"application/json"})
    public VariableEntity getVariable(@PathParam(value="variableId") String variableId) {
        Variable variable = this.webManager.getVariable(variableId);
        return VariableEntity.fromVariable(variable);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VariableEntity createVariable(VariableEntity entity) {
        Variable variable = entity.toVariable();
        Variable newVariable = this.webManager.createVariable(variable);
        return VariableEntity.fromVariable(newVariable);
    }

    @POST
    @Path(value="/{variableId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VariableEntity updateVariable(@PathParam(value="variableId") String variableId, VariableEntity entity) {
        Variable updatedVariable = this.webManager.updateVariable(variableId, entity.toVariable());
        return VariableEntity.fromVariable(updatedVariable);
    }

    @DELETE
    @Path(value="/{variableId}")
    @Produces(value={"application/json"})
    public void deleteVariable(@PathParam(value="variableId") String variableId) {
        this.webManager.deleteVariable(variableId);
    }

    @DELETE
    @Produces(value={"application/json"})
    public void deleteVariables() {
        List ids = this.getHttpRequest().getParameterAsList("selectedIds");
        this.webManager.deleteVariables(ids);
    }

    @POST
    @Path(value="/{variableId}/values")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VariableScheduledValueEntity createVariableValue(@PathParam(value="variableId") String variableId, VariableScheduledValueEntity entity) {
        VariableScheduledValue value = entity.toVariableScheduledValue();
        VariableScheduledValue createdValue = this.webManager.scheduleValue(value, variableId);
        return VariableScheduledValueEntity.fromVariableScheduledValue(createdValue);
    }

    @POST
    @Path(value="/{variableId}/values/{valueId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public VariableScheduledValueEntity updateVariableValue(@PathParam(value="variableId") String variableId, @PathParam(value="valueId") String valueId, VariableScheduledValueEntity entity) {
        VariableScheduledValue value = entity.toVariableScheduledValue();
        VariableScheduledValue updatedValue = this.webManager.updateValue(valueId, variableId, value);
        return VariableScheduledValueEntity.fromVariableScheduledValue(updatedValue);
    }

    @DELETE
    @Path(value="/{variableId}/values/{valueId}")
    @Produces(value={"application/json"})
    public void deleteVariableValues(@PathParam(value="variableId") String variableId, @PathParam(value="valueId") String valueId) {
        this.webManager.deleteValue(valueId, variableId);
    }

    private List<VariableEntity> asWebEntities(Collection<Variable> variables) {
        return variables.stream().map(this::asWebEntity).collect(Collectors.toList());
    }

    private VariableEntity asWebEntity(Variable value) {
        return VariableEntity.fromVariable(value);
    }

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return null;
    }
}

