/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.selection;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.ApplicationService;
import org.silverpeas.core.ApplicationServiceProvider;
import org.silverpeas.core.BasicIdentifier;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.SilverpeasResource;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.space.SpaceInst;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.Planned;
import org.silverpeas.core.contribution.model.Thumbnail;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.contribution.model.WithThumbnail;
import org.silverpeas.core.webapi.selection.PeriodOfTime;
import org.silverpeas.core.webapi.util.UserEntity;
import org.silverpeas.kernel.exception.NotFoundException;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
public class BasketItem
implements SilverpeasResource,
Serializable {
    @XmlElement(required=true)
    private String id;
    @XmlElement(required=true)
    private String type;
    private String name;
    private String description;
    private Date creationDate;
    private Date lastUpdateDate;
    private UserEntity creator;
    private UserEntity lastUpdater;
    private String thumbnailURI;
    private String permalink;
    private PeriodOfTime period;

    private BasketItem() {
    }

    public static BasketItem from(SilverpeasResource resource) {
        if (resource instanceof BasketItem) {
            return (BasketItem)resource;
        }
        BasketItem item = new BasketItem();
        item.id = resource.getIdentifier().asString();
        item.type = resource.getClass().getSimpleName();
        item.creationDate = resource.getCreationDate();
        item.creator = new UserEntity(resource.getCreator());
        item.lastUpdateDate = resource.getLastUpdateDate();
        item.lastUpdater = new UserEntity(resource.getLastUpdater());
        item.description = resource.getDescription();
        item.name = resource.getName();
        if (resource instanceof Contribution) {
            BasketItem.setFrom((Contribution)resource, item);
        }
        return item;
    }

    private static void setFrom(Contribution contribution, BasketItem item) {
        item.type = contribution.getContributionType();
        if (contribution instanceof WithThumbnail) {
            Thumbnail thumbnail = ((WithThumbnail)contribution).getThumbnail();
            String string = item.thumbnailURI = thumbnail == null ? null : thumbnail.getURL();
        }
        if (contribution instanceof WithPermanentLink) {
            item.permalink = ((WithPermanentLink)contribution).getPermalink();
        }
        if (contribution instanceof Planned) {
            item.period = PeriodOfTime.from(((Planned)contribution).getPeriod());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public <T extends ResourceIdentifier> T getIdentifier() {
        if (ContributionIdentifier.isValid((String)this.id)) {
            return (T)ContributionIdentifier.decode((String)this.id);
        }
        return (T)new BasicIdentifier(this.id);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public User getCreator() {
        return User.getById((String)this.creator.getId());
    }

    public User getLastUpdater() {
        return User.getById((String)this.lastUpdater.getId());
    }

    public String getThumbnailURI() {
        return this.thumbnailURI;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSpace() {
        return this.id.startsWith("WA");
    }

    public boolean isComponentInstance() {
        return this.type.equals(ComponentInst.class.getSimpleName()) || this.type.equals(ComponentInstLight.class.getSimpleName());
    }

    public boolean isContribution() {
        return ContributionIdentifier.isValid((String)this.id);
    }

    public boolean isPlanned() {
        return this.period != null;
    }

    public boolean isComplete() {
        return StringUtil.isDefined((String)this.name) && this.creator != null && this.creationDate != null && this.lastUpdateDate != null && this.lastUpdater != null;
    }

    public <T extends Contribution> T toContribution() {
        if (this.isContribution()) {
            ContributionIdentifier identifier = ContributionIdentifier.decode((String)this.id);
            Optional maybeService = ApplicationServiceProvider.get().getApplicationServiceById(identifier.getComponentInstanceId());
            ApplicationService service = (ApplicationService)maybeService.orElseThrow(() -> new NotFoundException("No application service available for id " + identifier.getComponentInstanceId()));
            Optional contribution = service.getContributionById(identifier);
            return (T)((Contribution)contribution.orElseThrow(() -> new NotFoundException("No such contribution with id " + this.id)));
        }
        throw new NotFoundException(String.format("Resource %s isn't a contribution", this.id));
    }

    public <T extends SilverpeasResource> T toResource() {
        if (this.isContribution()) {
            return this.toContribution();
        }
        if (this.isSpace()) {
            OrganizationController organizationController = OrganizationController.get();
            SpaceInst space = organizationController.getSpaceInstById(this.id);
            if (space == null) {
                throw new NotFoundException("No such collaborative space with id " + this.id);
            }
            return (T)space;
        }
        if (this.isComponentInstance()) {
            OrganizationController organizationController = OrganizationController.get();
            ComponentInst app = organizationController.getComponentInst(this.id);
            if (app == null) {
                throw new NotFoundException("No such component instance with id " + this.id);
            }
            return (T)app;
        }
        throw new NotFoundException("This item doesn't represent any resource in Silverpeas");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SilverpeasResource)) {
            return false;
        }
        SilverpeasResource that = (SilverpeasResource)o;
        return this.id.equals(that.getIdentifier().asString());
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

