/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.util.Set;
import org.silverpeas.core.pdc.pdc.model.ClassifyValue;
import org.silverpeas.core.pdc.pdc.model.PdcAxisValue;
import org.silverpeas.core.webapi.pdc.LocalizedValue;

public class LocalizedPdcAxisValue
extends PdcAxisValue
implements LocalizedValue {
    private static final long serialVersionUID = 3041692821847135712L;
    private final String language;
    private final PdcAxisValue decoratedValue;

    private LocalizedPdcAxisValue(PdcAxisValue value, String forLanguage) {
        this.decoratedValue = value;
        this.language = forLanguage;
    }

    public static LocalizedPdcAxisValue decorate(PdcAxisValue value, String forLanguage) {
        return new LocalizedPdcAxisValue(value, forLanguage);
    }

    @Override
    public String getLocalizedPath() {
        String path = this.getMeaningTranslatedIn(this.getLanguage());
        String[] pathNodes = path.split("/");
        if (pathNodes.length > 5) {
            path = this.buildTruncatedPath(pathNodes);
        }
        if (path.equals(" / ")) {
            path = "";
        }
        return path;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public String toString() {
        return this.decoratedValue.toString();
    }

    public ClassifyValue toClassifyValue() {
        return this.decoratedValue.toClassifyValue();
    }

    public boolean isBaseValue() {
        return this.decoratedValue.isBaseValue();
    }

    public String getValuePath() {
        return this.decoratedValue.getValuePath();
    }

    public String getTermTranslatedIn(String language) {
        return this.decoratedValue.getTermTranslatedIn(language);
    }

    public String getTerm() {
        return this.decoratedValue.getTerm();
    }

    public PdcAxisValue getParentValue() {
        return this.decoratedValue.getParentValue();
    }

    public String getMeaningTranslatedIn(String language) {
        return this.decoratedValue.getMeaningTranslatedIn(language);
    }

    public String getMeaning() {
        return this.decoratedValue.getMeaning();
    }

    public String getId() {
        return this.decoratedValue.getId();
    }

    public Set<PdcAxisValue> getChildValues() {
        return this.decoratedValue.getChildValues();
    }

    public String getAxisId() {
        return this.decoratedValue.getAxisId();
    }

    private String buildTruncatedPath(String[] splitedPath) {
        int nodeCount = splitedPath.length;
        return this.buildPathBetween(splitedPath, 0, 2) + " /  ...  / " + this.buildPathBetween(splitedPath, nodeCount - 2, nodeCount);
    }

    private String buildPathBetween(String[] splitedPath, int startIndex, int endIndex) {
        if (startIndex < 0 || startIndex >= splitedPath.length || endIndex < startIndex) {
            throw new IndexOutOfBoundsException("The indexes are out of bounds (startIndex=" + startIndex + ", endIndex=" + endIndex + ")");
        }
        StringBuilder path = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            path.append(splitedPath[i]).append(" / ");
        }
        int separatorSize = 2;
        return path.substring(0, path.length() - 2);
    }
}

