/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.web.WebResourceUri;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.admin.AbstractAdminResource;
import org.silverpeas.core.webapi.admin.ComponentEntity;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="components")
@Authenticated
public class ComponentsResource
extends AbstractAdminResource {
    @Context
    private UriInfo uriInfo;

    protected String getResourceBasePath() {
        return "components";
    }

    protected WebResourceUri initWebResourceUri() {
        return new WebResourceUri(this.getResourceBasePath(), this.getHttpServletRequest(), this.uriInfo);
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<ComponentEntity> getComponentsByFilterOrParameterValue(@QueryParam(value="filter") String filter, @QueryParam(value="param") String param, @QueryParam(value="value") String value) {
        if ("imagebanks".equals(filter)) {
            return this.getByParameterValue("viewInWysiwyg", "yes");
        }
        if ("filebanks".equals(filter)) {
            return this.getByParameterValue("publicFiles", "yes");
        }
        if (StringUtil.isDefined((String)param) && StringUtil.isDefined((String)value)) {
            if (!this.getUser().isAccessAdmin()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            return this.getByParameterValue(param, value);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    private Collection<ComponentEntity> getByParameterValue(String param, String value) {
        try {
            List components = this.orgaController.getComponentsWithParameterValue(param, value);
            return this.asWebEntities(this.filterAuthorizedComponents(components));
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    public String getComponentId() {
        return null;
    }
}

