/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.browsebars;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.span;
import org.owasp.encoder.Encode;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.html.HtmlCleaner;
import org.silverpeas.core.web.util.viewgenerator.html.JavascriptPluginInclusion;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.AbstractBrowseBar;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBarElement;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class BrowseBarComplete
extends AbstractBrowseBar {
    private static final String CONNECTOR = "<span class=\"connector\"> > </span>";
    private String userLanguage = null;

    @Override
    public String print() {
        StringBuilder result = new StringBuilder();
        result.append("<div id=\"browseBar\">");
        result.append(this.printBreadCrumb());
        if (this.isI18N()) {
            div div2 = new div(this.getI18NHTMLLinks() + "&nbsp;|&nbsp;");
            div2.setID("i18n");
            result.append(div2.toString());
        }
        result.append("</div>");
        return result.toString();
    }

    private String printBreadCrumb() {
        OrganizationController organizationController = OrganizationControllerProvider.getOrganisationController();
        StringBuilder result = new StringBuilder();
        result.append(this.printScript());
        if (!StringUtil.isDefined((String)this.getSpaceJavascriptCallback())) {
            this.setSpaceJavascriptCallback("goSpace");
        }
        result.append("<div id=\"breadCrumb\">");
        StringBuilder breadcrumb = new StringBuilder();
        SilverpeasComponentInstance componentInst = null;
        if (StringUtil.isDefined((String)this.getComponentId())) {
            componentInst = organizationController.getComponentInstance(this.getComponentId()).orElse(null);
        }
        if (componentInst != null || StringUtil.isDefined((String)this.getSpaceId())) {
            breadcrumb.append(this.getSpacePath(componentInst));
            breadcrumb.append(this.getComponent(componentInst));
        } else {
            this.appendExplicitSpaceAndComponent(breadcrumb);
        }
        this.appendPath(breadcrumb);
        this.appendExtraInformation(breadcrumb);
        result.append((CharSequence)breadcrumb);
        result.append("</div>");
        return result.toString();
    }

    private void appendExplicitSpaceAndComponent(StringBuilder breadcrumb) {
        if (this.getDomainName() != null) {
            breadcrumb.append(this.getDomainName());
        }
        if (this.getComponentName() != null) {
            if (this.getDomainName() != null) {
                breadcrumb.append(CONNECTOR);
            }
            if (this.getComponentLink() != null) {
                a href = new a(this.getComponentLink());
                href.addElement(this.getComponentName());
                breadcrumb.append(href.toString());
            } else {
                breadcrumb.append(this.getComponentName());
            }
        }
    }

    private String getUserLanguage() {
        if (this.userLanguage == null) {
            this.userLanguage = this.getMainSessionController() == null ? "" : this.getMainSessionController().getFavoriteLanguage();
        }
        return this.userLanguage;
    }

    private String getSpacePath(SilverpeasComponentInstance componentInst) {
        List spaces = Collections.emptyList();
        OrganizationController organizationController = OrganizationControllerProvider.getOrganisationController();
        if (componentInst != null && !componentInst.isPersonal()) {
            spaces = organizationController.getPathToComponent(this.getComponentId());
        } else if (componentInst == null) {
            spaces = organizationController.getPathToSpace(this.getSpaceId());
        }
        StringBuilder breadcrumb = new StringBuilder();
        for (SpaceInstLight spaceInst : spaces) {
            String spaceId = spaceInst.getId();
            Object href = "javascript:" + this.getSpaceJavascriptCallback() + "('" + spaceId + "')";
            if (!this.isClickable()) {
                href = "#";
            }
            if (breadcrumb.length() > 0) {
                breadcrumb.append(CONNECTOR);
            }
            a link2 = new a((String)href);
            link2.addElement(Encode.forHtml((String)spaceInst.getName(this.getUserLanguage())));
            link2.setClass("space");
            link2.setID("space" + spaceId);
            breadcrumb.append(link2.toString());
        }
        return breadcrumb.toString();
    }

    private String getComponent(SilverpeasComponentInstance componentInst) {
        StringBuilder breadcrumb = new StringBuilder();
        if (componentInst != null) {
            if (!componentInst.isPersonal()) {
                breadcrumb.append(CONNECTOR);
            }
            breadcrumb.append("<a href=\"");
            if (!this.isClickable()) {
                breadcrumb.append("#");
            } else if (StringUtil.isDefined((String)this.getComponentJavascriptCallback())) {
                breadcrumb.append("javascript:").append(this.getComponentJavascriptCallback()).append("('").append(this.getComponentId()).append("')");
            } else {
                breadcrumb.append(URLUtil.getApplicationURL()).append(URLUtil.getURL((String)this.getSpaceId(), (String)this.getComponentId()));
                if (this.ignoreComponentLink()) {
                    breadcrumb.append("Main");
                } else {
                    breadcrumb.append(this.getComponentLink());
                }
            }
            breadcrumb.append("\"");
            breadcrumb.append(" class=\"component\"");
            breadcrumb.append(" id=\"bc_").append(componentInst.getId()).append("\"");
            breadcrumb.append(">");
            breadcrumb.append(Encode.forHtml((String)componentInst.getLabel(this.getUserLanguage())));
            breadcrumb.append("</a>");
        }
        return breadcrumb.toString();
    }

    private void appendPath(StringBuilder breadcrumb) {
        List<BrowseBarElement> elements = this.getElements();
        if (!elements.isEmpty()) {
            for (BrowseBarElement element : elements) {
                this.appendElement(breadcrumb, element);
            }
        } else if (StringUtil.isDefined((String)this.getPath())) {
            if (breadcrumb.length() > 0) {
                breadcrumb.append(CONNECTOR);
            }
            span span2 = new span(this.getPath());
            span2.setClass("path");
            breadcrumb.append(span2.toString());
        }
    }

    private void appendElement(StringBuilder breadcrumb, BrowseBarElement element) {
        if (breadcrumb.length() > 0) {
            breadcrumb.append(CONNECTOR);
        }
        if (StringUtil.isDefined((String)element.getLink())) {
            breadcrumb.append("<a href=\"").append(element.getLink()).append("\"");
        } else {
            breadcrumb.append("<span");
        }
        breadcrumb.append(" class=\"element\"");
        if (StringUtil.isDefined((String)element.getId())) {
            breadcrumb.append(" id=\"").append(element.getId()).append("\"");
        }
        breadcrumb.append(">");
        breadcrumb.append(element.getLabel());
        if (StringUtil.isDefined((String)element.getLink())) {
            breadcrumb.append("</a>");
        } else {
            breadcrumb.append("</span>");
        }
    }

    private void appendExtraInformation(StringBuilder breadcrumb) {
        if (StringUtil.isDefined((String)this.getExtraInformation())) {
            if (breadcrumb.length() > 0) {
                breadcrumb.append(CONNECTOR);
            }
            breadcrumb.append("<span class=\"information\">");
            breadcrumb.append(this.getExtraInformation());
            breadcrumb.append("</span>");
        }
    }

    private String printScript() {
        return JavascriptPluginInclusion.scriptContent("function goSpace(spaceId) {spWindow.loadSpace(spaceId);}").toString();
    }

    @Override
    public String getBreadCrumb() {
        try {
            return this.getTextBreadCrumb(this.printBreadCrumb());
        }
        catch (IOException e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    String getTextBreadCrumb(String html2) throws IOException {
        HtmlCleaner cleaner = new HtmlCleaner();
        return cleaner.cleanHtmlFragment(html2);
    }
}

