/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.treemenu.taglib;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.silverpeas.core.admin.component.model.WAComponent;

public class TreeMenuHtmlHeadTag
extends TagSupport {
    private static String iconStyle = null;
    private boolean displayCssFile = false;
    private boolean displayJavascriptFile = false;
    private boolean displayIconsStyles = false;
    private String contextName = null;
    private static final long serialVersionUID = 2678199573554487425L;

    public int doEndTag() throws JspException {
        try {
            StringBuilder builder = new StringBuilder();
            if (this.displayCssFile) {
                String stylePrefix = "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.contextName;
                builder.append(stylePrefix).append("/util/styleSheets/treeMenu/fonts-min.css\">");
                builder.append(stylePrefix).append("/util/styleSheets/treeMenu/treeview.css\">");
                builder.append(stylePrefix).append("/util/styleSheets/treeMenu/tree.css\">");
            }
            if (this.displayJavascriptFile) {
                String jsPrefix = "<script type=\"text/javascript\" src=\"" + this.contextName;
                builder.append(jsPrefix).append("/util/yui/yahoo-dom-event/yahoo-dom-event.js\"></script>");
                builder.append(jsPrefix).append("/util/yui/json/json-min.js\"></script>");
                builder.append(jsPrefix).append("/util/yui/connection/connection-min.js\"></script>");
                builder.append(jsPrefix).append("/util/yui/treeview/treeview-min.js\"></script>");
                builder.append(jsPrefix).append("/util/javaScript/treeMenu/menu.js\"></script>");
            }
            if (this.displayIconsStyles) {
                if (iconStyle == null) {
                    StringBuilder iconStyleBuilder = new StringBuilder();
                    Collection components = WAComponent.getAll();
                    if (!components.isEmpty()) {
                        iconStyleBuilder.append("<style type=\"text/css\">");
                    }
                    for (WAComponent component : components) {
                        String name = component.getName();
                        iconStyleBuilder.append(".").append("icon-").append(name).append("{ display:block; height: 15px; padding-left: 20px; background: transparent url(").append(this.contextName).append("/util/icons/component/").append(name).append("Small.gif) 0 0px no-repeat; } ");
                    }
                    if (iconStyleBuilder.length() > 1) {
                        iconStyleBuilder.append("</style>");
                        iconStyle = iconStyleBuilder.toString();
                    }
                }
                builder.append(iconStyle);
            }
            this.pageContext.getOut().println(builder.toString());
        }
        catch (IOException e) {
            throw new JspException("TreeMenuHtmlHeadTag Tag", (Throwable)e);
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        return 1;
    }

    public boolean isDisplayCssFile() {
        return this.displayCssFile;
    }

    public void setDisplayCssFile(boolean displayCssFile) {
        this.displayCssFile = displayCssFile;
    }

    public boolean isDisplayJavascriptFile() {
        return this.displayJavascriptFile;
    }

    public void setDisplayJavascriptFile(boolean displayJavascriptFile) {
        this.displayJavascriptFile = displayJavascriptFile;
    }

    public boolean isDisplayIconsStyles() {
        return this.displayIconsStyles;
    }

    public void setDisplayIconsStyles(boolean displayIconStyle) {
        this.displayIconsStyles = displayIconStyle;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }
}

