/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.webcomponent;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Produces;
import org.silverpeas.core.util.MapUtil;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentRequestContext;
import org.silverpeas.core.web.mvc.webcomponent.annotation.InvokeAfter;
import org.silverpeas.core.web.mvc.webcomponent.annotation.InvokeBefore;
import org.silverpeas.core.web.mvc.webcomponent.annotation.LowestRoleAccess;
import org.silverpeas.core.web.mvc.webcomponent.annotation.NavigationStep;

class Path {
    private static final String REGEXP_SEPARATOR = "@#@#@";
    private static final Pattern VARIABLE_MATCHER = Pattern.compile("(\\{[^/\\?]+\\})");
    private static final Pattern VARIABLE_NAME = Pattern.compile("\\{\\s*([\\w_]+)");
    private static final Pattern VARIABLE_REGEXP_CHECK = Pattern.compile(":\\s*(.+)\\s*\\}");
    private final String path;
    private List<String> pathVariables = null;
    private final Method resourceMethod;
    private final LowestRoleAccess lowestRoleAccess;
    private final NavigationStep navigationStep;
    private final Annotation redirectTo;
    private final Produces produces;
    private final String[] invokeBeforeIdentifiers;
    private final String[] invokeAfterIdentifiers;

    Path(String path, LowestRoleAccess lowestRoleAccess, Method resourceMethod, NavigationStep navigationStep, Annotation redirectTo, Produces produces, InvokeBefore invokeBefore, InvokeAfter invokeAfter) {
        this.resourceMethod = resourceMethod;
        this.lowestRoleAccess = lowestRoleAccess;
        this.navigationStep = navigationStep;
        this.redirectTo = redirectTo;
        this.produces = produces;
        this.invokeBeforeIdentifiers = invokeBefore != null ? invokeBefore.value() : new String[]{};
        this.invokeAfterIdentifiers = invokeAfter != null ? invokeAfter.value() : new String[]{};
        this.path = this.parsePath(path);
    }

    private String parsePath(String aPath) {
        StringBuilder newPath = new StringBuilder();
        StringTokenizer aPathTokenizer = new StringTokenizer(aPath, "/");
        while (aPathTokenizer.hasMoreTokens()) {
            StringBuilder newPathPart = new StringBuilder();
            String pathPart = aPathTokenizer.nextToken();
            Matcher variableMatcher = VARIABLE_MATCHER.matcher(pathPart);
            if (variableMatcher.find()) {
                newPathPart.append(pathPart.substring(0, variableMatcher.start()));
                String variableDefinition = variableMatcher.group(1);
                Matcher variableName = VARIABLE_NAME.matcher(variableDefinition);
                if (!variableName.find()) {
                    throw new IllegalArgumentException("trying to handle a path variable " + variableDefinition + ", but variable name not found");
                }
                if (this.pathVariables == null) {
                    this.pathVariables = new ArrayList<String>();
                }
                this.pathVariables.add(variableName.group(1).trim());
                newPathPart.append(REGEXP_SEPARATOR);
                newPathPart.append("(");
                Matcher variableRegexpCheck = VARIABLE_REGEXP_CHECK.matcher(variableDefinition);
                if (variableRegexpCheck.find()) {
                    newPathPart.append(variableRegexpCheck.group(1).trim());
                } else {
                    newPathPart.append(".*");
                }
                newPathPart.append(")");
                newPathPart.append(pathPart.substring(variableMatcher.end()));
            }
            if (newPath.length() > 0) {
                newPath.append("/");
            }
            newPath.append(newPathPart.length() > 0 ? newPathPart.toString() : pathPart);
        }
        return newPath.toString();
    }

    public boolean matches(String path, boolean skipPathsWithVariables, WebComponentRequestContext requestContext) {
        Iterator<String> pathVariablesIt;
        StringTokenizer pathTokenizer = new StringTokenizer(path, "/");
        StringTokenizer registredPathTokenizer = new StringTokenizer(this.path, "/");
        Iterator<String> iterator = pathVariablesIt = this.pathVariables != null ? this.pathVariables.iterator() : null;
        if (pathTokenizer.countTokens() != registredPathTokenizer.countTokens()) {
            return false;
        }
        LinkedHashMap matchedPathVariables = new LinkedHashMap();
        while (pathTokenizer.hasMoreTokens()) {
            String registredPathPart;
            String pathPart = pathTokenizer.nextToken();
            if (pathPart.equals(registredPathPart = registredPathTokenizer.nextToken())) continue;
            if (pathVariablesIt == null || skipPathsWithVariables || !registredPathPart.contains(REGEXP_SEPARATOR)) {
                return false;
            }
            Matcher matcher = Pattern.compile(registredPathPart.replaceFirst(REGEXP_SEPARATOR, "")).matcher(pathPart);
            if (!matcher.find()) {
                return false;
            }
            MapUtil.putAddSet(matchedPathVariables, (Object)pathVariablesIt.next(), (Object)matcher.group(1));
        }
        for (Map.Entry entry : matchedPathVariables.entrySet()) {
            for (String value : (Set)entry.getValue()) {
                requestContext.addPathVariable((String)entry.getKey(), value);
            }
        }
        return true;
    }

    public String getPath() {
        return this.path;
    }

    public LowestRoleAccess getLowestRoleAccess() {
        return this.lowestRoleAccess;
    }

    public Method getResourceMethod() {
        return this.resourceMethod;
    }

    public NavigationStep getNavigationStep() {
        return this.navigationStep;
    }

    public Annotation getRedirectTo() {
        return this.redirectTo;
    }

    public Produces getProduces() {
        return this.produces;
    }

    public String[] getInvokeBeforeIdentifiers() {
        return this.invokeBeforeIdentifiers;
    }

    public String[] getInvokeAfterIdentifiers() {
        return this.invokeAfterIdentifiers;
    }
}

