/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.route;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.contribution.ContributionOperationContextPropertyHandler;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.CoreContributionType;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.security.token.Token;
import org.silverpeas.core.security.token.exception.TokenValidationException;
import org.silverpeas.core.silverstatistics.volume.service.SilverStatisticsManager;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.util.MultiSilverpeasBundle;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.security.SecuritySettings;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.core.web.mvc.controller.ComponentContext;
import org.silverpeas.core.web.mvc.controller.ComponentSessionController;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.mvc.controller.PeasCoreException;
import org.silverpeas.core.web.mvc.controller.SilverpeasWebUtil;
import org.silverpeas.core.web.mvc.processor.UserAndGroupSelectionProcessor;
import org.silverpeas.core.web.mvc.util.WysiwygRouting;
import org.silverpeas.core.web.mvc.webcomponent.SilverpeasAuthenticatedHttpServlet;
import org.silverpeas.core.web.token.SynchronizerTokenService;
import org.silverpeas.core.web.util.SilverpeasTransverseWebErrorUtil;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class ComponentRequestRouter<T extends ComponentSessionController>
extends SilverpeasAuthenticatedHttpServlet {
    private static final long serialVersionUID = -8055016885655445663L;
    private static final String MANUAL_JSON_RESPONSE_PREFIX = "MANUAL_JSON_RESPONSE_";
    private static final String SESSION_ATTR_PREFIX = "Silverpeas_";
    @Inject
    private UserAndGroupSelectionProcessor selectionProcessor;
    @Inject
    private OrganizationController organizationController;
    private static final Collection<Pattern> SESSION_SECURITY_GENERATION_FUNCTION_PATTERNS = new ArrayList<Pattern>();

    public abstract String getSessionControlBeanName();

    public abstract String getDestination(String var1, T var2, HttpRequest var3);

    protected boolean checkUserAuthorization(String function, T componentSC) {
        return true;
    }

    public abstract T createComponentSessionController(MainSessionController var1, ComponentContext var2);

    protected final boolean hasTheSessionSecurityTokenToBeRenewed(HttpServletRequest request, String function) {
        boolean hasToBeRenewed = SecuritySettings.isSessionTokenRenewEnabled();
        if (hasToBeRenewed) {
            Pattern sessionSecurityTokenPattern;
            Iterator<Pattern> iterator = SESSION_SECURITY_GENERATION_FUNCTION_PATTERNS.iterator();
            while (iterator.hasNext() && !(hasToBeRenewed = (sessionSecurityTokenPattern = iterator.next()).matcher(function).matches())) {
            }
        }
        if (hasToBeRenewed) {
            String referer = StringUtil.defaultStringIfNotDefined((String)request.getHeader("Referer"), (String)"");
            hasToBeRenewed = !request.getRequestURL().toString().equals(referer);
        }
        return hasToBeRenewed;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        String destination = this.computeDestination(request);
        if (!StringUtil.isDefined((String)destination)) {
            this.throwHttpNotFoundError();
        }
        this.redirectService(request, response, destination);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doPost(request, response);
    }

    private String computeDestination(HttpServletRequest request) {
        String destination;
        HttpSession session = request.getSession(false);
        MainSessionController mainSessionCtrl = this.getMainSessionController(request);
        if (MainSessionController.isAppInMaintenance() && !mainSessionCtrl.getCurrentUserDetail().isAccessAdmin()) {
            return ResourceLocator.getGeneralSettingBundle().getString("redirectAppInMaintenance");
        }
        String[] context = ComponentRequestRouter.getComponentId(request, mainSessionCtrl);
        String spaceId = context[0];
        String componentId = context[1];
        String function = context[2];
        boolean isSpaceInMaintenance = mainSessionCtrl.isSpaceInMaintenance(spaceId);
        if (isSpaceInMaintenance && !mainSessionCtrl.getCurrentUserDetail().isAccessAdmin()) {
            return "/admin/jsp/spaceInMaintenance.jsp";
        }
        boolean bCompoAllowed = this.isUserAllowed(mainSessionCtrl, componentId);
        if (!bCompoAllowed) {
            SilverLogger.getLogger((Object)((Object)this)).warn("User {0} not allowed to access application {1} in space {2}", new Object[]{mainSessionCtrl.getUserId(), componentId, spaceId});
            String destination2 = "/admin/jsp/spaceOrCompAccessForbidden.jsp";
            return destination2;
        }
        this.validateSecurityTokens(request);
        T ctrl = this.getComponentSessionController(session, componentId);
        if (ctrl == null) {
            ctrl = this.setComponentSessionController(session, mainSessionCtrl, spaceId, componentId);
        }
        this.setNavigationContext(request, ctrl);
        HttpRequest httpRequest = HttpRequest.decorate((HttpServletRequest)request);
        this.initLookContext(httpRequest, session, spaceId, componentId, function, ctrl);
        this.updateSilverStatistics(componentId, function, ctrl);
        if (this.selectionProcessor.isComeFromSelectionPanel(request) && StringUtil.isDefined((String)(destination = this.selectionProcessor.processSelection(mainSessionCtrl.getSelection(), request)))) {
            return destination;
        }
        ContributionOperationContextPropertyHandler.parseRequest((HttpServletRequest)request);
        destination = this.computeNextDestination(httpRequest, componentId, function, ctrl);
        if (StringUtil.isDefined((String)componentId) && this.hasTheSessionSecurityTokenToBeRenewed(request, function)) {
            this.renewSessionSecurityToken(request);
        }
        SilverpeasTransverseWebErrorUtil.verifyErrorFromRequest((ServletRequest)request, ctrl.getLanguage());
        if (this.selectionProcessor.isSelectionAsked(destination)) {
            this.selectionProcessor.prepareSelection(mainSessionCtrl.getSelection(), request);
        }
        if (!"POPUP".equals(this.getSessionControlBeanName()) || !function.startsWith("ReadMessage")) {
            this.updateSessionManagement(session, destination);
        }
        request.setAttribute(this.getSessionControlBeanName(), ctrl);
        return destination;
    }

    private String computeNextDestination(HttpRequest httpRequest, String componentId, String function, T component) {
        String destination;
        if (this.checkUserAuthorization(function, component)) {
            destination = "EditComponentInstanceIntro".equals(function) ? this.getComponentInstanceIntroDestination((ComponentSessionController)component) : this.getDestination(function, component, httpRequest);
        } else {
            SilverLogger.getLogger((Object)((Object)this)).warn("User {0} not allowed to invoke {1} for application {2}", new Object[]{component.getUserId(), function, componentId});
            destination = "/admin/jsp/accessForbidden.jsp";
        }
        return destination;
    }

    private void updateSilverStatistics(String componentId, String function, T component) {
        if (componentId != null && function.equals("Main") || function.startsWith("searchResult") || function.startsWith("portlet") || function.equals("GoToFilesTab")) {
            SilverStatisticsManager.getInstance().addStatAccess(component.getUserId(), new Date(), component.getComponentName(), component.getSpaceId(), component.getComponentId());
        }
    }

    private void initLookContext(HttpRequest httpRequest, HttpSession session, String spaceId, String componentId, String function, T component) {
        if (!("Idle.jsp".equals(function) || "ChangeSearchTypeToExpert".equals(function) || "markAsRead".equals(function))) {
            GraphicElementFactory gef = (GraphicElementFactory)session.getAttribute("SessionGraphicElementFactory");
            gef.setComponentIdForCurrentRequest(component.getComponentId());
            gef.setHttpRequest(httpRequest);
        }
        Optional.ofNullable(session).map(LookHelper::getLookHelper).ifPresent(h -> {
            if (StringUtil.isDefined((String)componentId)) {
                h.setComponentIdAndSpaceIds(null, null, componentId);
            } else if (StringUtil.isDefined((String)spaceId)) {
                h.setSpaceIdAndSubSpaceId(spaceId);
            }
        });
    }

    private void setNavigationContext(HttpServletRequest request, T component) {
        MultiSilverpeasBundle resources = new MultiSilverpeasBundle(component.getMultilang(), component.getIcon(), component.getSettings(), component.getLanguage());
        request.setAttribute("resources", (Object)resources);
        String[] browseContext = new String[]{component.getSpaceLabel(), component.getComponentLabel(), component.getSpaceId(), component.getComponentId(), component.getComponentUrl()};
        request.setAttribute("browseContext", (Object)browseContext);
        request.setAttribute("myComponentURL", (Object)(URLUtil.getApplicationURL() + component.getComponentUrl()));
    }

    public void updateSessionManagement(HttpSession session, String destination) {
        StringUtil.requireDefined((String)destination);
        SessionManagement sessionManagement = SessionManagementProvider.getSessionManagement();
        sessionManagement.validateSession(session.getId());
    }

    private void validateSecurityTokens(HttpServletRequest request) {
        try {
            SynchronizerTokenService.getInstance().validate(request, true);
        }
        catch (TokenValidationException ex) {
            this.throwHttpForbiddenError();
        }
    }

    private boolean isUserAllowed(MainSessionController controller, String componentId) {
        boolean[] userAllowed = new boolean[]{componentId == null || this.getOrganizationController().isComponentAvailableToUser(componentId, controller.getUserId())};
        if (!userAllowed[0]) {
            PersonalComponentInstance.from((String)componentId).ifPresent(personalComponentInstance -> {
                userAllowed[0] = personalComponentInstance.getUser().getId().equals(controller.getUserId());
            });
        }
        return userAllowed[0];
    }

    protected String emptyJsonResponse() {
        return this.sendJson(JSONCodec.encodeObject(o -> o));
    }

    protected String sendJson(String jsonContent) {
        return MANUAL_JSON_RESPONSE_PREFIX + jsonContent;
    }

    private void redirectService(HttpServletRequest request, HttpServletResponse response, String destination) {
        try {
            if (destination.startsWith(MANUAL_JSON_RESPONSE_PREFIX)) {
                response.setHeader("Content-Type", "application/json; charset=UTF-8");
                response.setHeader("Cache-Control", "no-store");
                response.setHeader("Pragma", "no-cache");
                response.setDateHeader("Expires", -1L);
                response.getWriter().append(destination.substring(MANUAL_JSON_RESPONSE_PREFIX.length()));
                response.flushBuffer();
            } else if (destination.startsWith("PRODUCES_")) {
                response.flushBuffer();
            } else if (destination.startsWith("http") || destination.startsWith("ftp")) {
                response.sendRedirect(destination);
            } else {
                request.setAttribute("org.silverpeas.servlets.ComponentRequestRouter.requestURI", (Object)request.getRequestURI());
                Token token = this.getSynchronizerTokenService().getSessionToken(request);
                request.setAttribute("X-STKN", (Object)token.getValue());
                RequestDispatcher requestDispatcher = this.getServletConfig().getServletContext().getRequestDispatcher(destination);
                if (requestDispatcher != null) {
                    requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    SilverLogger.getLogger((Object)((Object)this)).warn("Web page dispatching failure: destination {0} not found!", new Object[]{destination});
                }
            }
        }
        catch (Exception e) {
            try {
                request.setAttribute("javax.servlet.jsp.jspException", (Object)new PeasCoreException("ComponentRequestRouter.redirectService", "peasCore.EX_REDIRECT_SERVICE_FAILED", "Destination=" + destination, e));
                this.getServletConfig().getServletContext().getRequestDispatcher("/admin/jsp/errorpageMain.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception ex) {
                SilverLogger.getLogger((Object)((Object)this)).error("Web page dispatching to {0} failed: {1}", (Object[])new String[]{destination, e.getMessage()}, (Throwable)e);
            }
        }
    }

    public static String[] getComponentId(HttpServletRequest request, MainSessionController mainSessionCtrl) {
        SilverpeasWebUtil webUtil = (SilverpeasWebUtil)ServiceProvider.getService(SilverpeasWebUtil.class, (Annotation[])new Annotation[0]);
        return webUtil.getComponentId(request);
    }

    protected OrganizationController getOrganizationController() {
        return this.organizationController;
    }

    private T getComponentSessionController(HttpSession session, String componentId) {
        if (componentId == null) {
            return (T)((ComponentSessionController)session.getAttribute(SESSION_ATTR_PREFIX + this.getSessionControlBeanName()));
        }
        return (T)((ComponentSessionController)session.getAttribute(SESSION_ATTR_PREFIX + this.getSessionControlBeanName() + "_" + componentId));
    }

    private T setComponentSessionController(HttpSession session, MainSessionController mainSessionCtrl, String spaceId, String componentId) {
        ComponentContext componentContext = mainSessionCtrl.createComponentContext(spaceId, componentId);
        T component = this.createComponentSessionController(mainSessionCtrl, componentContext);
        if (componentId == null) {
            session.setAttribute(SESSION_ATTR_PREFIX + this.getSessionControlBeanName(), component);
        } else {
            session.setAttribute(SESSION_ATTR_PREFIX + this.getSessionControlBeanName() + "_" + componentId, component);
        }
        return component;
    }

    private String getComponentInstanceIntroDestination(ComponentSessionController sc) {
        String returnURL = URLUtil.getApplicationURL() + URLUtil.getComponentInstanceURL((String)sc.getComponentId()) + "Main";
        ContributionIdentifier id = ContributionIdentifier.from((String)sc.getComponentId(), (String)"Intro", (CoreContributionType)CoreContributionType.COMPONENT_INSTANCE);
        if (sc.getComponentId().startsWith("classifieds")) {
            id = ContributionIdentifier.from((String)sc.getComponentId(), (String)"Node_0", (CoreContributionType)CoreContributionType.NODE);
        } else {
            ComponentInstLight component = OrganizationController.get().getComponentInstLight(sc.getComponentId());
            if (component.isWorkflow()) {
                id = ContributionIdentifier.from((String)sc.getComponentId(), (String)sc.getComponentId(), (CoreContributionType)CoreContributionType.COMPONENT_INSTANCE);
            }
        }
        WysiwygRouting routing = new WysiwygRouting();
        WysiwygRouting.WysiwygRoutingContext context = WysiwygRouting.WysiwygRoutingContext.fromComponentSessionController(sc).withContributionId(id).withLanguage(sc.getLanguage()).withComeBackUrl(returnURL).withBrowseInfo(sc.getMultilang().getString("GML.operations.editComponentIntro"));
        try {
            return routing.getDestinationToWysiwygEditor(context);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e);
            return "#";
        }
    }

    static {
        SESSION_SECURITY_GENERATION_FUNCTION_PATTERNS.add(Pattern.compile("^(?i)(main)"));
    }
}

