/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.external.webconnections.dao;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstanceDeletion;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.security.authorization.ForbiddenRuntimeException;
import org.silverpeas.core.web.external.webconnections.dao.ConnectionDAO;
import org.silverpeas.core.web.external.webconnections.dao.WebConnectionsRuntimeException;
import org.silverpeas.core.web.external.webconnections.model.ConnectionDetail;
import org.silverpeas.core.web.external.webconnections.model.WebConnectionsInterface;

@Service
@Singleton
public class WebConnectionService
implements WebConnectionsInterface,
ComponentInstanceDeletion {
    private ConnectionDAO dao;

    protected WebConnectionService() {
    }

    @PostConstruct
    private void initialize() {
        this.dao = new ConnectionDAO();
    }

    @Transactional
    public void delete(String componentInstanceId) {
        try {
            this.dao.deleteByComponentInstanceId(componentInstanceId);
        }
        catch (SQLException e) {
            throw new WebConnectionsRuntimeException(e);
        }
    }

    @Override
    public ConnectionDetail getWebConnection(String componentId, String userId) {
        ConnectionDetail connectionDetail;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                connectionDetail = this.dao.getConnection(con, componentId, userId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new WebConnectionsRuntimeException(e);
                }
            }
            con.close();
        }
        return connectionDetail;
    }

    @Override
    public ConnectionDetail getWebConnectionById(String connectionId, String userId) {
        ConnectionDetail connectionDetail;
        block9: {
            Connection con = DBUtil.openConnection();
            try {
                ConnectionDetail connectionDetail2 = this.dao.getConnectionById(con, connectionId);
                if (!userId.equals(connectionDetail2.getUserId())) {
                    throw new ForbiddenRuntimeException("Web connection " + connectionId + " unauthorized for user " + userId);
                }
                connectionDetail = connectionDetail2;
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new WebConnectionsRuntimeException(e);
                }
            }
            con.close();
        }
        return connectionDetail;
    }

    @Override
    @Transactional
    public void createWebConnection(ConnectionDetail connection) {
        try (Connection con = DBUtil.openConnection();){
            this.dao.createConnection(con, connection);
        }
        catch (Exception e) {
            throw new WebConnectionsRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void deleteWebConnection(String connectionId, String userId) {
        try (Connection con = DBUtil.openConnection();){
            this.getWebConnectionById(connectionId, userId);
            this.dao.deleteConnection(con, connectionId);
        }
        catch (Exception e) {
            throw new WebConnectionsRuntimeException(e);
        }
    }

    @Override
    @Transactional
    public void updateWebConnection(String connectionId, String login, String password, String userId) {
        try (Connection con = DBUtil.openConnection();){
            this.getWebConnectionById(connectionId, userId);
            this.dao.updateConnection(con, connectionId, login, password);
        }
        catch (Exception e) {
            throw new WebConnectionsRuntimeException(e);
        }
    }

    @Override
    public List<ConnectionDetail> listWebConnectionsOfUser(String userId) throws RemoteException {
        List<ConnectionDetail> list;
        block8: {
            Connection con = DBUtil.openConnection();
            try {
                list = this.dao.getConnectionsByUser(con, userId);
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new WebConnectionsRuntimeException(e);
                }
            }
            con.close();
        }
        return list;
    }
}

