/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import java.util.NoSuchElementException;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.admin.service.AdminException;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.security.authentication.AuthDomain;
import org.silverpeas.core.security.authentication.Authentication;
import org.silverpeas.core.web.authentication.credentials.CredentialsFunctionHandler;
import org.silverpeas.core.web.authentication.credentials.HttpFunctionHandlerRegistering;

public abstract class CredentialsFunctionFromLoginHandler
extends CredentialsFunctionHandler {
    @Inject
    private Authentication authenticator;

    @Override
    public void registerWith(HttpFunctionHandlerRegistering registering) {
        registering.register(this, true);
    }

    protected LoginData fetchLoginData(HttpServletRequest request) {
        String loginId = request.getParameter("Login");
        String domainId = request.getParameter("DomainId");
        AuthDomain domain = null;
        try {
            domain = this.authenticator.getAllAuthDomains().stream().filter(d -> d.getId().equals(domainId)).findFirst().orElseThrow();
            User user = Optional.ofNullable(this.getAdminService().getUserIdByLoginAndDomain(loginId, domainId)).map(User::getById).orElseThrow();
            return new ValidLoginData(user, domain);
        }
        catch (NoSuchElementException | AdminException e) {
            return new InvalidLoginData(loginId, domain);
        }
    }

    protected Authentication getAuthenticator() {
        return this.authenticator;
    }

    protected static class InvalidLoginData
    implements LoginData {
        private final String loginId;
        private final String domainName;

        public InvalidLoginData(String loginId, AuthDomain domain) {
            this.loginId = loginId;
            this.domainName = domain == null ? "" : domain.getName();
        }

        @Override
        public String getDomainName() {
            return this.domainName;
        }

        @Override
        public String getLoginId() {
            return this.loginId;
        }

        @Override
        public boolean isInvalid() {
            return true;
        }
    }

    protected static class ValidLoginData
    implements LoginData {
        private final User user;
        private final AuthDomain domain;

        public ValidLoginData(User user, AuthDomain domain) {
            this.user = user;
            this.domain = domain;
        }

        public User getUser() {
            return this.user;
        }

        public AuthDomain getDomain() {
            return this.domain;
        }

        @Override
        public String getDomainName() {
            return this.domain.getName();
        }

        @Override
        public String getLoginId() {
            return this.user.getLogin();
        }

        @Override
        public boolean isInvalid() {
            return false;
        }
    }

    protected static interface LoginData {
        public String getDomainName();

        public String getLoginId();

        public boolean isInvalid();
    }
}

