/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.status;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.status.Status;
import org.silverpeas.core.socialnetwork.status.StatusDao;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class StatusService {
    @Inject
    private StatusDao statusDao;

    protected StatusService() {
    }

    private Connection getConnection() throws SQLException {
        return DBUtil.openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String changeStatus(Status status) {
        Connection connection = null;
        int id = -1;
        try {
            connection = this.getConnection();
            id = this.statusDao.changeStatus(connection, status);
            if (id >= 0) {
                String string = status.getDescription();
                return string;
            }
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getLastStatus(int userid) {
        Connection connection = null;
        Status status = new Status();
        try {
            connection = this.getConnection();
            status = this.statusDao.getLastStatus(connection, userid);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformation> getAllStatus(int userId, Date begin, Date end) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            List<SocialInformation> list = this.statusDao.getAllStatus(connection, userId, begin, end);
            return list;
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SocialInformation> getSocialInformationListOfMyContacts(List<String> myContactsIds, Date begin, Date end) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            List<SocialInformation> list = this.statusDao.getSocialInformationListOfMyContacts(connection, myContactsIds, begin, end);
            return list;
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            DBUtil.close((Connection)connection);
        }
        return Collections.emptyList();
    }
}

