/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.socialnetwork.relationship;

import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.socialnetwork.model.SocialInformation;
import org.silverpeas.core.socialnetwork.relationship.RelationShip;
import org.silverpeas.core.socialnetwork.relationship.RelationShipDao;
import org.silverpeas.core.socialnetwork.relationship.RelationShipEventNotifier;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Transactional
public class RelationShipService {
    @Inject
    private RelationShipDao relationShipDao;
    @Inject
    private RelationShipEventNotifier relationShipEventNotifier;

    public static RelationShipService get() {
        return (RelationShipService)ServiceProvider.getService(RelationShipService.class, (Annotation[])new Annotation[0]);
    }

    protected RelationShipService() {
    }

    public boolean removeRelationShip(int idUser1, int idUser2) {
        boolean endAction = false;
        try (Connection connection = DBUtil.openConnection();){
            RelationShip rel1to2 = this.relationShipDao.getRelationShip(connection, idUser1, idUser2);
            RelationShip rel2to1 = this.relationShipDao.getRelationShip(connection, idUser2, idUser1);
            this.relationShipDao.deleteRelationShip(connection, idUser1, idUser2);
            this.relationShipDao.deleteRelationShip(connection, idUser2, idUser1);
            endAction = true;
            for (RelationShip ship : Arrays.asList(rel1to2, rel2to1)) {
                if (ship == null) continue;
                this.relationShipEventNotifier.notifyEventOn(ResourceEvent.Type.DELETION, new RelationShip[]{ship});
            }
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return endAction;
    }

    public boolean isInRelationShip(int user1Id, int user2Id) {
        boolean isInRelationShip = false;
        try (Connection connection = DBUtil.openConnection();){
            isInRelationShip = this.relationShipDao.isInRelationShip(connection, user1Id, user2Id);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return isInRelationShip;
    }

    public List<RelationShip> getAllMyRelationShips(int myId) {
        ArrayList<RelationShip> listMyRelation = new ArrayList();
        try (Connection connection = DBUtil.openConnection();){
            listMyRelation = this.relationShipDao.getAllMyRelationShips(connection, myId);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return listMyRelation;
    }

    public List<String> getMyContactsIds(int myId) {
        ArrayList<String> myContactsIds = new ArrayList();
        try (Connection connection = DBUtil.openConnection();){
            myContactsIds = this.relationShipDao.getMyContactsIds(connection, myId);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return myContactsIds;
    }

    public List<String> getAllCommonContactsIds(int user1Id, int user2Id) {
        List<String> myContactsIds = new ArrayList<String>();
        try (Connection connection = DBUtil.openConnection();){
            myContactsIds = this.relationShipDao.getAllCommonContactsIds(connection, user1Id, user2Id);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return myContactsIds;
    }

    public List<SocialInformation> getAllMyRelationShips(String userId, Date begin, Date end) {
        List<SocialInformation> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.relationShipDao.getAllMyRelationShips(connection, userId, begin, end);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
                    return new ArrayList<SocialInformation>();
                }
            }
            connection.close();
        }
        return list;
    }

    public List<SocialInformation> getAllRelationShipsOfContacts(List<String> myContactsIds, Date begin, Date end) {
        List<SocialInformation> list;
        block8: {
            Connection connection = DBUtil.openConnection();
            try {
                list = this.relationShipDao.getAllRelationShipsOfContacts(connection, myContactsIds, begin, end);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
                    return new ArrayList<SocialInformation>();
                }
            }
            connection.close();
        }
        return list;
    }

    public RelationShip getRelationShip(int user1Id, int user2Id) {
        RelationShip relation = null;
        try (Connection connection = DBUtil.openConnection();){
            relation = this.relationShipDao.getRelationShip(connection, user1Id, user2Id);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
        }
        return relation;
    }
}

