/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.encryption;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.stream.Stream;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilverpeasX509TrustManager
implements X509TrustManager {
    final Logger logger = LoggerFactory.getLogger(SilverpeasX509TrustManager.class);
    private X509TrustManager defaultTrustManager;

    public SilverpeasX509TrustManager(String trustStoreFile, char[] password) {
        try {
            KeyStore truststore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.initTrustManager(trustStoreFile, truststore, password);
        }
        catch (GeneralSecurityException secEx) {
            this.logger.error(String.format("Couldn't create truststore %s", trustStoreFile), (Throwable)secEx);
        }
    }

    private void initTrustManager(String trustStoreFile, KeyStore keyStore, char[] password) throws GeneralSecurityException {
        try (FileInputStream fis = new FileInputStream(trustStoreFile);){
            keyStore.load(fis, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            tmf.init(keyStore);
            TrustManager[] tms = tmf.getTrustManagers();
            this.defaultTrustManager = Stream.of(tms).filter(X509TrustManager.class::isInstance).map(t -> (X509TrustManager)t).findFirst().orElseThrow(() -> new GeneralSecurityException("No X509 TrustStore Manager found!"));
        }
        catch (IOException e) {
            this.logger.error(String.format("Couldn't load truststore %s", trustStoreFile), (Throwable)e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(xcs, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        this.defaultTrustManager.checkServerTrusted(xcs, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }
}

