/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authorization;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.ProfiledObjectId;
import org.silverpeas.core.admin.ProfiledObjectIds;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.node.model.NodeRuntimeException;
import org.silverpeas.core.node.service.NodeService;
import org.silverpeas.core.security.authorization.AbstractAccessController;
import org.silverpeas.core.security.authorization.AccessControlContext;
import org.silverpeas.core.security.authorization.AccessControlOperation;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.ComponentAccessController;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Pair;

@Service
@Singleton
public class NodeAccessController
extends AbstractAccessController<NodePK>
implements NodeAccessControl {
    private static final String DATA_MANAGER_CONTEXT_KEY = "NodeAccessControllerDataManager";
    private ComponentAccessControl componentAccessController;

    @Inject
    NodeAccessController(ComponentAccessControl componentAccessController) {
        this.componentAccessController = componentAccessController;
    }

    static DataManager getDataManager(AccessControlContext context) {
        DataManager manager = (DataManager)context.get(DATA_MANAGER_CONTEXT_KEY, DataManager.class);
        if (manager == null) {
            manager = new DataManager(context);
            context.put(DATA_MANAGER_CONTEXT_KEY, (Object)manager);
        }
        return manager;
    }

    @Override
    public Stream<NodePK> filterAuthorizedByUser(Collection<NodePK> nodePks, String userId, AccessControlContext context) {
        List<String> instancesIds = nodePks.stream().map(WAPrimaryKey::getInstanceId).distinct().collect(Collectors.toList());
        NodeAccessController.getDataManager(context).loadCaches(userId, instancesIds);
        return nodePks.stream().filter(n -> this.isUserAuthorized(userId, (NodePK)n, context));
    }

    @Override
    public boolean isUserAuthorized(String userId, ResourceIdentifier id) {
        ContributionIdentifier nodeId = (ContributionIdentifier)id;
        NodePK nodePK = new NodePK(nodeId.getLocalId(), nodeId.getComponentInstanceId());
        NodeDetail nodeDetail = NodeService.get().getDetail(nodePK);
        return this.isUserAuthorized(userId, nodeDetail);
    }

    @Override
    public boolean isUserAuthorized(String userId, NodeDetail nodeDetail) {
        return this.isUserAuthorized(userId, nodeDetail, AccessControlContext.init());
    }

    @Override
    public boolean isUserAuthorized(String userId, NodeDetail nodeDetail, AccessControlContext context) {
        NodeAccessController.getDataManager(context).loadCachesWithLoadedNode(nodeDetail);
        return this.isUserAuthorized(userId, nodeDetail.getNodePK(), context);
    }

    public boolean isUserAuthorized(String userId, NodePK nodePK, AccessControlContext context) {
        Set<SilverpeasRole> userRoles = this.getUserRoles(userId, nodePK, context);
        MemoizedSupplier highestRole = new MemoizedSupplier(() -> {
            SilverpeasRole highestUserRole = SilverpeasRole.getHighestFrom((Collection)userRoles);
            return highestUserRole != null ? highestUserRole : SilverpeasRole.READER;
        });
        ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(context);
        boolean authorized = this.isUserAuthorized(userRoles);
        if (authorized && componentDataManager.isTopicTrackerSupported(nodePK.getInstanceId()) && nodePK.isTrash()) {
            authorized = ((SilverpeasRole)highestRole.get()).isGreaterThanOrEquals(SilverpeasRole.WRITER);
        }
        if (authorized && AccessControlOperation.isSharingActionFrom((Collection)context.getOperations())) {
            SilverpeasRole highestUserRole = (SilverpeasRole)highestRole.get();
            User user = User.getById((String)userId);
            authorized = !user.isAnonymous() && !user.isAccessGuest() && componentDataManager.isFolderSharingEnabledForRole(nodePK.getInstanceId(), highestUserRole);
        }
        return authorized;
    }

    public boolean isGroupAuthorized(String groupId, NodePK nodePK) {
        boolean authorized = false;
        if (this.componentAccessController.isGroupAuthorized(groupId, (Object)nodePK.getInstanceId())) {
            if (!this.componentAccessController.isRightOnTopicsEnabled(nodePK.getInstanceId())) {
                authorized = true;
            } else {
                try {
                    NodeDetail node = NodeService.get().getHeader(nodePK, false);
                    if (node != null) {
                        if (node.haveRights()) {
                            NodePK objectPK = node.getNodePK();
                            authorized = OrganizationController.get().isObjectAvailableToGroup(ProfiledObjectId.fromNode(node.getRightsDependsOn()), objectPK.getInstanceId(), groupId);
                        } else {
                            authorized = true;
                        }
                    }
                }
                catch (Exception e) {
                    SilverLogger.getLogger((Object)this).warn((Throwable)e);
                    authorized = false;
                }
            }
        }
        return authorized;
    }

    @Override
    protected void fillUserRoles(Set<SilverpeasRole> userRoles, AccessControlContext context, String userId, NodePK nodePK) {
        ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(context);
        String instanceId = nodePK.getInstanceId();
        Set componentUserRoles = this.componentAccessController.getUserRoles(userId, (Object)instanceId, context);
        boolean componentUserAuthorized = this.componentAccessController.isUserAuthorized(componentUserRoles);
        if (!componentUserAuthorized) {
            if (!nodePK.isRoot() && !nodePK.isTrash() && !nodePK.isUnclassed() && componentDataManager.hasUserHasReadAccessAtLeast(instanceId) && componentDataManager.isRightOnTopicsEnabled(instanceId)) {
                this.fillNodeUserRoles(userRoles, context, userId, nodePK, componentUserRoles);
            }
            return;
        }
        if (!componentDataManager.isRightOnTopicsEnabled(instanceId) || nodePK.isRoot() || nodePK.isTrash() || nodePK.isUnclassed()) {
            userRoles.addAll(componentUserRoles);
            return;
        }
        this.fillNodeUserRoles(userRoles, context, userId, nodePK, componentUserRoles);
    }

    private void fillNodeUserRoles(Set<SilverpeasRole> userRoles, AccessControlContext context, String userId, NodePK nodePK, Set<SilverpeasRole> componentUserRoles) {
        DataManager dataManager = NodeAccessController.getDataManager(context);
        NodeDetail node = dataManager.getNodeHeader(nodePK);
        if (node != null) {
            if (!node.haveRights()) {
                userRoles.addAll(componentUserRoles);
                return;
            }
            Set nodeRoles = SilverpeasRole.fromStrings((String[])dataManager.getUserProfiles(userId, node));
            if (AccessControlOperation.isPersistActionFrom((Collection)context.getOperations())) {
                nodeRoles.remove(SilverpeasRole.USER);
            }
            userRoles.addAll(nodeRoles);
        }
    }

    static class DataManager {
        private final AccessControlContext context;
        private OrganizationController controller;
        private NodeService nodeService;
        Map<String, NodeDetail> nodeDetailCache = null;
        Map<Pair<String, String>, Set<String>> userProfiles = null;

        DataManager(AccessControlContext context) {
            this.context = context;
            this.controller = OrganizationController.get();
            this.nodeService = NodeService.get();
        }

        void loadCachesWithLoadedNode(NodeDetail nodeDetail) {
            this.nodeDetailCache = Collections.singletonMap(this.computeNodeCacheKey(nodeDetail.getNodePK()), nodeDetail);
        }

        void loadCaches(String userId, Collection<String> instanceIds) {
            if (this.userProfiles == null && !instanceIds.isEmpty()) {
                this.completeCaches(userId, instanceIds);
            }
        }

        void completeCaches(String userId, Collection<String> instanceIds) {
            boolean firstLoad;
            ComponentAccessController.DataManager componentDataManager = ComponentAccessController.getDataManager(this.context);
            boolean bl = firstLoad = this.nodeDetailCache == null;
            if (firstLoad) {
                componentDataManager.loadCaches(userId, instanceIds);
            } else {
                componentDataManager.completeCaches(userId, instanceIds);
            }
            Set<String> instanceIdsWithRightsOnTopic = instanceIds.stream().filter(componentDataManager::isRightOnTopicsEnabled).collect(Collectors.toSet());
            if (firstLoad) {
                if (instanceIdsWithRightsOnTopic.isEmpty()) {
                    this.nodeDetailCache = new HashMap<String, NodeDetail>(0);
                    this.userProfiles = new HashMap<Pair<String, String>, Set<String>>(0);
                } else {
                    Pair<Map<String, NodeDetail>, Map<Pair<String, String>, Set<String>>> caches = this.loadNodesAndUserProfiles(userId, instanceIdsWithRightsOnTopic);
                    this.nodeDetailCache = (Map)caches.getFirst();
                    this.userProfiles = (Map)caches.getSecond();
                }
            } else {
                Pair<Map<String, NodeDetail>, Map<Pair<String, String>, Set<String>>> caches = this.loadNodesAndUserProfiles(userId, instanceIdsWithRightsOnTopic);
                ((Map)caches.getFirst()).forEach((k, v) -> this.nodeDetailCache.put((String)k, (NodeDetail)v));
                ((Map)caches.getSecond()).forEach((k, v) -> this.userProfiles.put((Pair<String, String>)k, (Set<String>)v));
            }
        }

        private Pair<Map<String, NodeDetail>, Map<Pair<String, String>, Set<String>>> loadNodesAndUserProfiles(String userId, Set<String> instanceIdsWithRightsOnTopic) {
            List<NodeDetail> nodeDetails = this.nodeService.getMinimalDataByInstances(instanceIdsWithRightsOnTopic);
            HashMap currentNodeDetailCache = new HashMap(nodeDetails.size());
            nodeDetails.forEach(n -> currentNodeDetailCache.put(this.computeNodeCacheKey(n.getNodePK()), n));
            Set<String> nodeIds = nodeDetails.stream().map(NodeDetail::getRightsDependsOn).filter(i -> !i.equals("-1")).collect(Collectors.toSet());
            Map<Object, Object> currentUserProfiles = nodeIds.isEmpty() ? new HashMap(0) : this.controller.getUserProfilesByComponentIdAndObjectId(userId, instanceIdsWithRightsOnTopic, ProfiledObjectIds.fromNodeIds(nodeIds));
            return Pair.of(currentNodeDetailCache, currentUserProfiles);
        }

        private String computeNodeCacheKey(NodePK nodePK) {
            return nodePK.getInstanceId() + "@" + nodePK.getId();
        }

        String[] getUserProfiles(String userId, NodeDetail node) {
            NodePK nodePK = node.getNodePK();
            if (this.userProfiles != null) {
                Pair key = Pair.of((Object)nodePK.getInstanceId(), (Object)node.getRightsDependsOn());
                return this.userProfiles.getOrDefault(key, Collections.emptySet()).toArray(new String[0]);
            }
            return this.controller.getUserProfiles(userId, nodePK.getInstanceId(), ProfiledObjectId.fromNode(node.getRightsDependsOn()));
        }

        public NodeDetail getNodeHeader(NodePK nodePK) {
            if (this.nodeDetailCache != null) {
                return this.nodeDetailCache.get(this.computeNodeCacheKey(nodePK));
            }
            try {
                return this.nodeService.getHeader(nodePK, false);
            }
            catch (NodeRuntimeException ex) {
                SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)((Object)ex));
                return null;
            }
        }
    }
}

