/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.security.authentication;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.AuthenticationProtocol;
import org.silverpeas.core.security.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.security.authentication.exception.AuthenticationExceptionVisitor;
import org.silverpeas.core.security.authentication.exception.AuthenticationHostException;
import org.silverpeas.core.security.authentication.exception.AuthenticationPasswordAboutToExpireException;
import org.silverpeas.core.security.authentication.exception.AuthenticationPwdChangeNotAvailException;
import org.silverpeas.core.security.authentication.exception.AuthenticationPwdNotAvailException;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;

public class AuthenticationServer {
    private String fallbackMode;
    private List<AuthenticationProtocol> authProtocols;
    private boolean passwordChangeAllowed;

    public static AuthenticationServer getAuthenticationServer(String serverName) {
        return new AuthenticationServer(serverName);
    }

    private AuthenticationServer(String authServerName) {
        try {
            SettingBundle serverSettings = ResourceLocator.getSettingBundle((String)("org.silverpeas.authentication." + authServerName));
            this.fallbackMode = serverSettings.getString("fallbackType");
            this.passwordChangeAllowed = serverSettings.getBoolean("allowPasswordChange", false);
            int nbServers = Integer.parseInt(serverSettings.getString("autServersCount"));
            this.authProtocols = new ArrayList<AuthenticationProtocol>(nbServers);
            for (int i = 0; i < nbServers; ++i) {
                String serverName = "autServer" + i;
                if (!serverSettings.getBoolean(serverName + ".enabled", true)) continue;
                this.addAuthenticationService(serverName, authServerName, serverSettings);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Server=" + authServerName, (Throwable)e);
        }
    }

    private void addAuthenticationService(String serverName, String authServerName, SettingBundle serverSettings) {
        try {
            Constructor<?> constructor = Class.forName(serverSettings.getString(serverName + ".type")).getConstructor(new Class[0]);
            AuthenticationProtocol authProtocol = (AuthenticationProtocol)constructor.newInstance(new Object[0]);
            authProtocol.init(serverName, serverSettings);
            this.authProtocols.add(authProtocol);
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)this).error(authServerName + " / " + serverName, (Throwable)ex);
        }
    }

    public boolean hasProtocols() {
        return !this.authProtocols.isEmpty();
    }

    public void authenticate(final AuthenticationCredential credential) throws AuthenticationException {
        this.doSecurityOperation(new SecurityOperation("authenticate", credential){

            @Override
            public void performWith(AuthenticationProtocol authProtocol) throws AuthenticationException {
                authProtocol.authenticate(credential);
            }
        });
    }

    public void changePassword(final AuthenticationCredential credential, final String newPassword) throws AuthenticationException {
        if (!this.passwordChangeAllowed) {
            throw new AuthenticationPwdChangeNotAvailException("The password modification isn't available", new String[0]);
        }
        this.doSecurityOperation(new SecurityOperation("changePassword", credential){

            @Override
            public void performWith(AuthenticationProtocol authProtocol) throws AuthenticationException {
                authProtocol.changePassword(credential, newPassword);
            }
        });
    }

    public boolean isPasswordChangeAllowed() {
        return this.passwordChangeAllowed;
    }

    public void resetPassword(final String login, final boolean loginIgnoreCase, final String newPassword) throws AuthenticationException {
        if (!this.passwordChangeAllowed) {
            throw new AuthenticationPwdChangeNotAvailException("The password reset isn't available", new String[0]);
        }
        this.doSecurityOperation(new SecurityOperation("resetPassword", AuthenticationCredential.newWithAsLogin((String)login)){

            @Override
            public void performWith(AuthenticationProtocol authentication) throws AuthenticationException {
                authentication.resetPassword(login, loginIgnoreCase, newPassword);
            }
        });
    }

    private void doSecurityOperation(SecurityOperation op) throws AuthenticationException {
        boolean serverNotFound = true;
        AuthenticationException lastException = null;
        for (AuthenticationProtocol authProtocol : this.authProtocols) {
            if (authProtocol.isEnabled()) {
                try {
                    op.performWith(authProtocol);
                    serverNotFound = false;
                }
                catch (AuthenticationException ex) {
                    AuthenticationExceptionProcessor processor = new AuthenticationExceptionProcessor(op);
                    serverNotFound = processor.processAuthenticationException(ex);
                    lastException = ex;
                }
            }
            if (serverNotFound) continue;
            break;
        }
        if (serverNotFound) {
            if (lastException == null) {
                throw new AuthenticationException("No server definition found", new String[0]);
            }
            throw lastException;
        }
    }

    private class AuthenticationExceptionProcessor
    implements AuthenticationExceptionVisitor {
        private final AuthenticationCredential credential;
        private boolean continueAuthentication = true;

        public AuthenticationExceptionProcessor(SecurityOperation operation) {
            this.credential = operation.getAuthenticationCredential();
        }

        public boolean processAuthenticationException(AuthenticationException ex) throws AuthenticationException {
            ex.accept((AuthenticationExceptionVisitor)this);
            return this.continueAuthentication;
        }

        public void visit(AuthenticationBadCredentialException ex) throws AuthenticationException {
            if (AuthenticationServer.this.fallbackMode.equals("none") || AuthenticationServer.this.fallbackMode.equals("ifNotRejected")) {
                throw ex;
            }
            this.continueAuthentication = true;
        }

        public void visit(AuthenticationHostException ex) throws AuthenticationException {
            if (AuthenticationServer.this.fallbackMode.equals("none")) {
                throw ex;
            }
            this.continueAuthentication = true;
        }

        public void visit(AuthenticationException ex) throws AuthenticationException {
            if (AuthenticationServer.this.fallbackMode.equals("none")) {
                throw ex;
            }
            this.continueAuthentication = true;
        }

        public void visit(AuthenticationPwdNotAvailException ex) {
            this.continueAuthentication = true;
        }

        public void visit(AuthenticationPasswordAboutToExpireException ex) {
            this.credential.getCapabilities().put("Svp_Pwd_About_To_Expire", Boolean.TRUE);
            this.continueAuthentication = false;
        }

        public void visit(AuthenticationPwdChangeNotAvailException ex) {
            this.continueAuthentication = true;
        }
    }

    private static abstract class SecurityOperation {
        public static final String AUTHENTICATION = "authenticate";
        public static final String P_CHANGE = "changePassword";
        public static final String P_RESET = "resetPassword";
        private final String name;
        private final AuthenticationCredential credential;

        public SecurityOperation(String operationName, AuthenticationCredential credential) {
            this.credential = credential;
            this.name = operationName;
        }

        public String getName() {
            return this.name;
        }

        public AuthenticationCredential getAuthenticationCredential() {
            return this.credential;
        }

        public abstract void performWith(AuthenticationProtocol var1) throws AuthenticationException;
    }
}

