/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.server.channel.silvermail;

import java.util.List;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.notification.user.server.channel.silvermail.SilvermailCriteria;
import org.silverpeas.core.notification.user.server.channel.silvermail.SilvermailCriteriaProcessor;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.repository.PaginationCriterion;
import org.silverpeas.core.persistence.datasource.repository.Parameters;
import org.silverpeas.core.persistence.datasource.repository.QueryCriteria;
import org.silverpeas.core.persistence.datasource.repository.SimpleQueryCriteria;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;

public class JPQLQueryBuilder
implements SilvermailCriteriaProcessor {
    private StringBuilder orderBy = null;
    private boolean done = false;
    private final SimpleQueryCriteria jpqlCriteria;
    private String conjonction;

    public JPQLQueryBuilder(NamedParameters parameters) {
        this.jpqlCriteria = new SimpleQueryCriteria((Parameters)parameters);
    }

    @Override
    public void startProcessing() {
    }

    @Override
    public void endProcessing() {
        if (this.orderBy != null && this.orderBy.length() > 0) {
            this.jpqlCriteria.clause().add(this.orderBy.toString());
        }
        this.done = true;
    }

    public QueryCriteria result() {
        return this.jpqlCriteria;
    }

    @Override
    public SilvermailCriteriaProcessor then() {
        if (!this.done && this.jpqlCriteria.clause().text().length() > 0) {
            this.conjonction = "and";
        }
        return this;
    }

    @Override
    public SilvermailCriteriaProcessor processByIds(List<Long> ids) {
        if (!this.done) {
            List convertedIds = ids.stream().map(i -> new UniqueLongIdentifier().fromString(String.valueOf(i))).collect(Collectors.toList());
            this.jpqlCriteria.clause().add(this.conjonction).add("id = :ids").parameters().add("ids", convertedIds);
            this.conjonction = null;
        }
        return this;
    }

    @Override
    public SilvermailCriteriaProcessor processUserId(long userId) {
        if (!this.done) {
            this.jpqlCriteria.clause().add(this.conjonction).add("userId = :userId").parameters().add("userId", (Object)userId);
            this.conjonction = null;
        }
        return this;
    }

    @Override
    public SilvermailCriteriaProcessor processFolderId(long folderId) {
        if (!this.done) {
            this.jpqlCriteria.clause().add(this.conjonction).add("folderId = :folderId").parameters().add("folderId", (Object)folderId);
            this.conjonction = null;
        }
        return this;
    }

    @Override
    public SilvermailCriteriaProcessor processReadState(int readState) {
        if (!this.done) {
            this.jpqlCriteria.clause().add(this.conjonction).add("readen = :readState").parameters().add("readState", (Object)readState);
            this.conjonction = null;
        }
        return this;
    }

    @Override
    public SilvermailCriteriaProcessor processOrdering(List<SilvermailCriteria.QUERY_ORDER_BY> orderings) {
        if (!this.done) {
            for (SilvermailCriteria.QUERY_ORDER_BY anOrdering : orderings) {
                if (this.orderBy == null) {
                    this.orderBy = new StringBuilder("order by ");
                } else {
                    this.orderBy.append(", ");
                }
                this.orderBy.append(anOrdering.getPropertyName());
                this.orderBy.append(" ");
                this.orderBy.append(anOrdering.isAsc() ? "asc" : "desc");
            }
            this.conjonction = null;
        }
        return this;
    }

    @Override
    public SilvermailCriteriaProcessor processPagination(PaginationPage pagination) {
        this.jpqlCriteria.withPagination(new PaginationCriterion(pagination.getPageNumber(), pagination.getPageSize()));
        this.conjonction = null;
        return this;
    }
}

