/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client;

import java.sql.SQLException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.notification.UserEvent;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.notification.system.CDIResourceEventListener;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.notification.user.client.constant.BuiltInNotifAddress;
import org.silverpeas.core.notification.user.client.constant.NotifChannel;
import org.silverpeas.core.notification.user.client.model.NotifDefaultAddressRow;
import org.silverpeas.core.notification.user.client.model.NotifDefaultAddressTable;
import org.silverpeas.core.notification.user.client.model.NotificationSchema;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

@Bean
@Singleton
public class NotificationUserEventListener
extends CDIResourceEventListener<UserEvent> {
    @Inject
    private NotificationSchema notificationSchema;

    @Transactional
    public void onDeletion(UserEvent event) {
        this.dereferenceUserFromUserNotification(event);
    }

    @Transactional
    public void dereferenceUserFromUserNotification(UserEvent event) {
        UserDetail user = (UserDetail)((Object)event.getTransition().getBefore());
        int userId = Integer.parseInt(user.getId());
        try {
            this.notificationSchema.notifDefaultAddress().dereferenceUserId(userId);
            this.notificationSchema.notifPreference().dereferenceUserId(userId);
            this.notificationSchema.notifAddress().dereferenceUserId(userId);
        }
        catch (SQLException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    @Transactional
    public void onCreation(UserEvent event) {
        UserDetail user = (UserDetail)((Object)event.getTransition().getAfter());
        this.checkNotificationChannel(user);
    }

    @Transactional
    public void checkNotificationChannel(UserDetail user) {
        if (StringUtil.isNotDefined((String)user.getEmailAddress())) {
            int silverMailChannelId = BuiltInNotifAddress.BASIC_SILVERMAIL.getId();
            int userId = Integer.parseInt(user.getId());
            Optional<NotifChannel> silverMailChannelAsDefault = NotificationManagerSettings.getDefaultChannels().stream().filter(c -> c.getMediaType().getId() == silverMailChannelId).findFirst();
            if (silverMailChannelAsDefault.isEmpty()) {
                NotifDefaultAddressTable ndat = this.notificationSchema.notifDefaultAddress();
                NotifDefaultAddressRow newRow = new NotifDefaultAddressRow(-1, userId, silverMailChannelId);
                try {
                    ndat.create(newRow);
                }
                catch (SQLException e) {
                    throw new SilverpeasRuntimeException((Throwable)e);
                }
            }
        }
    }
}

