/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.io.file;

import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ServiceRegistry;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;

@Technical
@Bean
@Singleton
public class IIOProviderInitializer
implements Initialization {
    public void init() {
        SilverLogger.getLogger((Object)this).info("Registers all available IIO plugins...", new Object[0]);
        ImageIO.scanForPlugins();
    }

    public void release() {
        SilverLogger.getLogger((Object)this).info("Unregisters all available IIO plugins...", new Object[0]);
        LocalFilter localFilter = new LocalFilter(Thread.currentThread().getContextClassLoader());
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<Class<?>> categories = registry.getCategories();
        while (categories.hasNext()) {
            IIOProviderInitializer.deregisterLocalProvidersForCategory(registry, localFilter, categories.next());
        }
    }

    private static <T> void deregisterLocalProvidersForCategory(IIORegistry registry, LocalFilter localFilter, Class<T> category) {
        Iterator<T> providers = registry.getServiceProviders(category, localFilter, false);
        ArrayList<T> providersCopy = new ArrayList<T>();
        while (providers.hasNext()) {
            providersCopy.add(providers.next());
        }
        for (Object provider : providersCopy) {
            registry.deregisterServiceProvider(provider, category);
        }
    }

    static class LocalFilter
    implements ServiceRegistry.Filter {
        private final ClassLoader loader;

        public LocalFilter(ClassLoader loader) {
            this.loader = loader;
        }

        @Override
        public boolean filter(Object provider) {
            return provider.getClass().getClassLoader() == this.loader;
        }
    }
}

