/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.index.indexing.model;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.index.indexing.IndexingLogger;
import org.silverpeas.core.index.indexing.model.DirectorySPFilter;
import org.silverpeas.core.index.indexing.model.FileSPFilter;
import org.silverpeas.core.index.indexing.model.FilenameComparator;
import org.silverpeas.core.index.indexing.model.FullIndexEntry;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.index.indexing.model.IndexEntryKey;
import org.silverpeas.core.util.file.FileUtil;

public class RepositoryIndexer {
    private static final String ADD_ACTION = "add";
    private static final String REMOVE_ACTION = "remove";
    private String spaceId = null;
    private String componentId = null;
    private int count = 0;

    public RepositoryIndexer(String spaceId, String componentId) {
        this.spaceId = spaceId;
        this.componentId = componentId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void addPath(Path path, String creatorId) {
        this.performPath(path, LocalDate.now(), creatorId, ADD_ACTION);
    }

    public void removePath(Path path, String creatorId) {
        this.performPath(path, LocalDate.now(), creatorId, REMOVE_ACTION);
    }

    private void performPath(Path path, LocalDate creationDate, String creatorId, String action) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.indexDirectory(path, creationDate, creatorId, action);
            this.processFileList(path, creationDate, creatorId, action);
        } else if (Files.exists(path, new LinkOption[0])) {
            this.indexFile(path.toFile(), creationDate, creatorId, action);
        }
    }

    private void processFileList(Path dir, LocalDate creationDate, String creatorId, String action) {
        if (this.count % 10000 == 0) {
            IndexingLogger.indexingLogger().debug("# of indexed documents = {0}", new Object[]{this.count});
        }
        File[] dirs = dir.toFile().listFiles(DirectorySPFilter.getInstance());
        File[] files = dir.toFile().listFiles(FileSPFilter.getInstance());
        List<File> dirList = Arrays.asList(dirs != null ? dirs : new File[]{});
        dirList.sort(FilenameComparator.comparator);
        List<File> fileList = Arrays.asList(files != null ? files : new File[]{});
        fileList.sort(FilenameComparator.comparator);
        for (File currentFile : fileList) {
            this.indexFile(currentFile, creationDate, creatorId, action);
        }
        for (File currentDir : dirList) {
            Path currentDirectoryPath = currentDir.toPath();
            this.indexDirectory(currentDirectoryPath, creationDate, creatorId, action);
            this.processFileList(currentDirectoryPath, creationDate, creatorId, action);
        }
    }

    private void indexDirectory(Path directory, LocalDate creationDate, String creatorId, String action) {
        String unixDirectory = FilenameUtils.separatorsToUnix((String)directory.toString());
        if (ADD_ACTION.equals(action)) {
            FullIndexEntry fullIndexEntry = new FullIndexEntry(new IndexEntryKey(this.getComponentId(), "LinkedDir", unixDirectory));
            fullIndexEntry.setTitle(directory.toFile().getName());
            fullIndexEntry.setCreationDate(creationDate);
            fullIndexEntry.setCreationUser(creatorId);
            IndexEngineProxy.addIndexEntry(fullIndexEntry);
            ++this.count;
        } else if (REMOVE_ACTION.equals(action)) {
            IndexEntryKey indexEntry = new IndexEntryKey(this.getComponentId(), "LinkedDir", unixDirectory);
            IndexEngineProxy.removeIndexEntry(indexEntry);
        }
    }

    private void indexFile(File file, LocalDate creationDate, String creatorId, String action) {
        String unixFilePath = FilenameUtils.separatorsToUnix((String)file.getPath());
        if (ADD_ACTION.equals(action)) {
            boolean haveGotExtension;
            String fileName = file.getName();
            FullIndexEntry fullIndexEntry = new FullIndexEntry(new IndexEntryKey(this.getComponentId(), "LinkedFile", unixFilePath));
            fullIndexEntry.setTitle(fileName);
            boolean bl = haveGotExtension = fileName.lastIndexOf(46) != -1;
            if (haveGotExtension) {
                fullIndexEntry.setPreview(fileName.substring(0, fileName.lastIndexOf(46)));
            } else {
                fullIndexEntry.setPreview(fileName);
            }
            fullIndexEntry.setCreationDate(creationDate);
            fullIndexEntry.setCreationUser(creatorId);
            if (haveGotExtension && !fileName.startsWith("~")) {
                String format = FileUtil.getMimeType(fileName);
                String lang = "fr";
                fullIndexEntry.addFileContent(unixFilePath, null, format, lang);
            }
            IndexEngineProxy.addIndexEntry(fullIndexEntry);
            ++this.count;
        } else if (REMOVE_ACTION.equals(action)) {
            IndexEntryKey indexEntry = new IndexEntryKey(this.getComponentId(), "LinkedFile", unixFilePath);
            IndexEngineProxy.removeIndexEntry(indexEntry);
        }
    }
}

