/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.template.publication;

import java.util.Set;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.backgroundprocess.AbstractBackgroundProcessRequest;
import org.silverpeas.core.backgroundprocess.BackgroundProcessTask;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSetManager;
import org.silverpeas.core.contribution.template.publication.PublicationTemplateManager;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class PublicationTemplateIntegrityProcessor
implements Initialization {
    public void init() {
        BackgroundProcessTask.push((AbstractBackgroundProcessRequest)new DeprecatedTemplateCleaner());
    }

    private static class DeprecatedTemplateCleaner
    extends AbstractBackgroundProcessRequest {
        private DeprecatedTemplateCleaner() {
        }

        protected void process() {
            try {
                Set<String> componentIds = GenericRecordSetManager.getInstance().getAllComponentIdsOfRecords();
                Transaction.performInOne(() -> {
                    componentIds.stream().filter(c -> StringUtil.isDefined((String)SilverpeasComponentInstance.getComponentName((String)c))).filter(c -> SilverpeasComponentInstance.getById((String)c).isEmpty()).forEach(c -> PublicationTemplateManager.getInstance().delete((String)c));
                    return null;
                });
            }
            catch (FormException e) {
                SilverLogger.getLogger((Object)((Object)this)).error((Throwable)((Object)e));
            }
        }
    }
}

