/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.publication.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.RemovedSpaceAndComponentInstanceChecker;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.contribution.publication.dao.DistributionTreeCriteria;
import org.silverpeas.core.contribution.publication.dao.PublicationCriteria;
import org.silverpeas.core.contribution.publication.dao.PublicationFatherDAO;
import org.silverpeas.core.contribution.publication.dao.QueryStringFactory;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.PublicationRuntimeException;
import org.silverpeas.core.contribution.publication.model.PublicationWithStatus;
import org.silverpeas.core.contribution.publication.social.SocialInformationPublication;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.persistence.datasource.repository.PaginationCriterion;
import org.silverpeas.core.persistence.jdbc.AbstractDAO;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.MapUtil;
import org.silverpeas.core.util.SilverpeasArrayList;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Repository
public class PublicationDAO
extends AbstractDAO {
    private static final String NULL_BEGIN_DATE = "0000/00/00";
    private static final String NULL_END_DATE = "9999/99/99";
    private static final String NULL_BEGIN_HOUR = "00:00";
    private static final String NULL_END_HOUR = "23:59";
    private static final String UNDEFINED_ID = "unknown";
    private static final String PUB_ID = "pubId";
    private static final String SB_PUBLICATION_PUBLI_TABLE = "sb_publication_publi";
    private static final String PUBSTATUS_VALID_CRITERION = "pubstatus = 'Valid'";
    private static final String SELECT_FROM_SB_PUBLICATION_PUBLI = "select * from sb_publication_publi ";
    private static final String FATHER_F = "Father F ";
    private static final String P_PUB_BEGIN_DATE_AND_P_PUB_END_DATE_OR = "( ? > P.pubBeginDate AND ? < P.pubEndDate ) OR ";
    private static final String P_PUB_BEGIN_DATE_AND_P_PUB_END_DATE_AND_P_PUB_BEGIN_HOUR_OR = "( ? = P.pubBeginDate AND ? < P.pubEndDate AND ? > P.pubBeginHour ) OR ";
    private static final String P_PUB_BEGIN_DATE_AND_P_PUB_END_DATE_AND_P_PUB_END_HOUR_OR = "( ? > P.pubBeginDate AND ? = P.pubEndDate AND ? < P.pubEndHour ) OR ";
    private static final String PUBLICATION_DAO_RESULT_SET_2_PUBLICATION_DETAIL_INTERNAL_ERROR = "PublicationDAO : resultSet2PublicationDetail() : internal error : ";
    private static final String ORDER_BY = " order by ";
    private static final String AND_F_PUB_ID_EQUAL_P_PUB_ID = " and F.pubId = P.pubId ";
    private static final String SELECT_FROM = "select * from ";
    private static final String AND = " and (";
    static final String PUBLICATION_TABLE_NAME = "SB_Publication_Publi";
    private static final String UPDATE_PUBLICATION = "UPDATE SB_Publication_Publi SET infoId = ?, pubName = ?, pubDescription = ?, pubCreationDate = ?, pubBeginDate = ?, pubEndDate = ?, pubCreatorId = ?, pubImportance = ?, pubVersion = ?, pubKeywords = ?, pubContent = ?, pubStatus = ?, pubUpdateDate = ?, pubUpdaterId = ?, instanceId = ?, pubValidatorId = ?, pubValidateDate = ?, pubBeginHour = ?, pubEndHour = ?, pubAuthor = ?, pubTargetValidatorId = ?, pubCloneId = ?, pubCloneStatus = ?, lang = ? WHERE pubId = ? ";
    private static final String WHERE_CONJUNCTION = "WHERE ";
    private static final String AND_CONJUNCTION = "AND ";
    private static final String INSTANCE_ID = "instanceId = ?";
    private static final String PUB_REMOVAL_DATE = "pubRemovalDate";
    private static final String PUB_REMOVER_ID = "pubRemoverId";

    private PublicationDAO() {
    }

    public void deleteComponentInstanceData(String componentInstanceId) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)PUBLICATION_TABLE_NAME).where(INSTANCE_ID, new Object[]{componentInstanceId}).execute();
    }

    public void removePubByPk(Connection con, PublicationPK pk, String userId) throws SQLException {
        JdbcSqlQuery.update((String)PUBLICATION_TABLE_NAME).withUpdateParam(PUB_REMOVAL_DATE, (Object)DateUtil.today2SQLDate()).withUpdateParam(PUB_REMOVER_ID, (Object)userId).where("pubId = ?", new Object[]{Integer.parseInt(pk.getId())}).and(INSTANCE_ID, new Object[]{pk.getInstanceId()}).executeWith(con);
    }

    public void restorePubByPk(Connection con, PublicationPK pk) throws SQLException {
        JdbcSqlQuery.update((String)PUBLICATION_TABLE_NAME).withUpdateParam(PUB_REMOVAL_DATE, null).withUpdateParam(PUB_REMOVER_ID, null).where("pubId = ?", new Object[]{Integer.parseInt(pk.getId())}).and(INSTANCE_ID, new Object[]{pk.getInstanceId()}).executeWith(con);
    }

    public int getNbPubByFatherPath(Connection con, NodePK fatherPK, String fatherPath) throws SQLException {
        int result = 0;
        PublicationPK pubPK = new PublicationPK(UNDEFINED_ID, fatherPK);
        if (!fatherPath.isEmpty()) {
            String selectStatement = "select count(F.pubId) from " + pubPK.getTableName() + "Father F, " + pubPK.getTableName() + " P, " + fatherPK.getTableName() + " N  where F.pubId = P.pubId  and F.nodeId = N.nodeId  and P.instanceId = ?  and N.instanceId  = ?  and (( ? > P.pubBeginDate AND ? < P.pubEndDate ) OR ( ? = P.pubBeginDate AND ? < P.pubEndDate AND ? > P.pubBeginHour ) OR ( ? > P.pubBeginDate AND ? = P.pubEndDate AND ? < P.pubEndHour ) OR ( ? = P.pubBeginDate AND ? = P.pubEndDate AND ? > P.pubBeginHour AND ? < P.pubEndHour) )  and (N.nodePath like '" + fatherPath + "/" + fatherPK.getId() + "%' or N.nodeId = " + fatherPK.getId() + ")";
            try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
                Date now = new Date();
                String dateNow = DateUtil.formatDate((Date)now);
                String hourNow = DateUtil.formatTime((Date)now);
                prepStmt.setString(1, fatherPK.getComponentName());
                prepStmt.setString(2, fatherPK.getComponentName());
                PublicationDAO.setDateVisibility(prepStmt, dateNow, hourNow, true);
                try (ResultSet rs = prepStmt.executeQuery();){
                    if (rs.next()) {
                        result = rs.getInt(1);
                    }
                }
            }
        }
        return result;
    }

    private static void setDateVisibility(PreparedStatement prepStmt, String dateNow, String hourNow, boolean withRangeHour) throws SQLException {
        prepStmt.setString(3, dateNow);
        prepStmt.setString(4, dateNow);
        prepStmt.setString(5, dateNow);
        prepStmt.setString(6, dateNow);
        prepStmt.setString(7, hourNow);
        prepStmt.setString(8, dateNow);
        prepStmt.setString(9, dateNow);
        prepStmt.setString(10, hourNow);
        prepStmt.setString(11, dateNow);
        prepStmt.setString(12, dateNow);
        if (withRangeHour) {
            prepStmt.setString(13, hourNow);
            prepStmt.setString(14, hourNow);
        }
    }

    public Map<String, Integer> getDistributionTree(Connection con, DistributionTreeCriteria criteria) throws SQLException {
        DistributionTreeCriteria completedCriteria = new DistributionTreeCriteria(criteria).ignoringInstanceIds(this.getRemovedInstanceIdsLinkedToInstance(con, criteria));
        return this.loadDistributionTree(con, completedCriteria);
    }

    private List<String> getRemovedInstanceIdsLinkedToInstance(Connection con, DistributionTreeCriteria criteria) throws SQLException {
        String instanceId = criteria.getInstanceId();
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"distinct sb_publication_publi.instanceId AS instanceId").from(new String[]{"sb_node_node"}).join("sb_publication_publifather").on("sb_publication_publifather.nodeid = sb_node_node.nodeid", new Object[0]).and("sb_publication_publifather.instanceId = ?", new Object[]{instanceId}).join(SB_PUBLICATION_PUBLI_TABLE).on("sb_publication_publifather.pubId = sb_publication_publi.pubId", new Object[0]);
        criteria.getStatusSubQuery().ifPresent(x$0 -> query.addSqlPart(x$0, new Object[0]));
        if (criteria.visibilityCheckRequired()) {
            this.visibleFilter(query, AND_CONJUNCTION, OffsetDateTime.now(), SB_PUBLICATION_PUBLI_TABLE);
        }
        RemovedSpaceAndComponentInstanceChecker checker = RemovedSpaceAndComponentInstanceChecker.create();
        return query.where("sb_publication_publi.instanceId <> ?", new Object[]{instanceId}).executeWith(con, r -> Optional.of(r.getString("instanceId")).filter(checker::isRemovedComponentInstanceById).orElse(null));
    }

    private Map<String, Integer> loadDistributionTree(Connection con, DistributionTreeCriteria criteria) throws SQLException {
        String instanceId = criteria.getInstanceId();
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"sb_node_node.nodeId, sb_node_node.nodefatherid, COUNT(sb_publication_publi.pubName) AS nbPubli").from(new String[]{"sb_node_node"}).outerJoin("sb_publication_publifather").on("sb_publication_publifather.nodeid = sb_node_node.nodeid", new Object[0]).and("sb_publication_publifather.instanceId = ?", new Object[]{instanceId}).outerJoin(SB_PUBLICATION_PUBLI_TABLE).on("sb_publication_publifather.pubId = sb_publication_publi.pubId", new Object[0]);
        Collection<String> instanceIdsToIgnore = criteria.getInstanceIdsToIgnore();
        if (!instanceIdsToIgnore.isEmpty()) {
            query.and("sb_publication_publi.instanceId", new Object[0]).notIn(instanceIdsToIgnore);
        }
        criteria.getStatusSubQuery().ifPresent(x$0 -> query.addSqlPart(x$0, new Object[0]));
        if (criteria.visibilityCheckRequired()) {
            this.visibleFilter(query, AND_CONJUNCTION, OffsetDateTime.now(), SB_PUBLICATION_PUBLI_TABLE);
        }
        HashMap<String, Integer> nodes = new HashMap<String, Integer>();
        query.where("sb_node_node.instanceId = ?", new Object[]{instanceId}).groupBy(new String[]{"sb_node_node.nodeId, sb_node_node.nodefatherid"}).executeWith(con, r -> {
            int nodeId = r.getInt("nodeId");
            String nodeIdentifier = String.valueOf(nodeId);
            nodes.put(nodeIdentifier, r.getInt("nbPubli"));
            return null;
        });
        return nodes;
    }

    public void insertRow(Connection con, PublicationDetail detail) {
        String insertStatement = "insert into " + detail.getPK().getTableName() + " (pubId, infoId, pubName, pubDescription, pubCreationDate, pubBeginDate, pubEndDate, pubCreatorId, pubImportance, pubVersion, pubKeywords, pubContent, pubStatus, pubUpdateDate, instanceId, pubUpdaterId, pubValidateDate, pubValidatorId, pubBeginHour, pubEndHour, pubAuthor, pubTargetValidatorId, pubCloneId, pubCloneStatus, lang, pubRemovalDate, pubRemoverId) values ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ?, ?, ? , ? , ? , ? , ? , ? , ? , ?, ?, ?)";
        try (PreparedStatement prepStmt = con.prepareStatement(insertStatement);){
            prepStmt.setInt(1, Integer.parseInt(detail.getPK().getId()));
            PublicationDAO.setStringParameter((PreparedStatement)prepStmt, (int)2, (String)detail.getInfoId(), (String)"0");
            prepStmt.setString(3, detail.getName());
            prepStmt.setString(4, detail.getDescription());
            PublicationDAO.setDateParameter((PreparedStatement)prepStmt, (int)5, (Date)detail.getCreationDate(), (String)DateUtil.today2SQLDate());
            PublicationDAO.setDateParameter((PreparedStatement)prepStmt, (int)6, (Date)detail.getBeginDate(), (String)NULL_BEGIN_DATE);
            PublicationDAO.setDateParameter((PreparedStatement)prepStmt, (int)7, (Date)detail.getEndDate(), (String)NULL_END_DATE);
            prepStmt.setString(8, detail.getCreatorId());
            prepStmt.setInt(9, detail.getImportance());
            prepStmt.setString(10, detail.getVersion());
            prepStmt.setString(11, detail.getKeywords());
            prepStmt.setString(12, detail.getContentPagePath());
            prepStmt.setString(13, detail.getStatus());
            if (detail.isUpdateDataMustBeSet() && detail.getLastUpdateDate() != null) {
                prepStmt.setString(14, DateUtil.formatDate((Date)detail.getLastUpdateDate()));
            } else {
                PublicationDAO.setDateParameter((PreparedStatement)prepStmt, (int)14, (Date)detail.getCreationDate(), (String)DateUtil.today2SQLDate());
            }
            prepStmt.setString(15, detail.getPK().getComponentName());
            if (detail.isUpdateDataMustBeSet() && StringUtil.isDefined((String)detail.getUpdaterId())) {
                prepStmt.setString(16, detail.getUpdaterId());
            } else {
                prepStmt.setString(16, detail.getCreatorId());
            }
            PublicationDAO.setDateParameter((PreparedStatement)prepStmt, (int)17, (Date)detail.getValidateDate(), null);
            prepStmt.setString(18, detail.getValidatorId());
            PublicationDAO.setStringParameter((PreparedStatement)prepStmt, (int)19, (String)detail.getBeginHour(), (String)NULL_BEGIN_HOUR);
            PublicationDAO.setStringParameter((PreparedStatement)prepStmt, (int)20, (String)detail.getEndHour(), (String)NULL_END_HOUR);
            PublicationDAO.setStringParameter((PreparedStatement)prepStmt, (int)21, (String)detail.getAuthor(), null);
            prepStmt.setString(22, detail.getTargetValidatorId());
            if (PublicationDAO.isUndefined(detail.getCloneId())) {
                prepStmt.setInt(23, -1);
            } else {
                prepStmt.setInt(23, Integer.parseInt(detail.getCloneId()));
            }
            prepStmt.setString(24, detail.getCloneStatus());
            if (PublicationDAO.isUndefined(detail.getLanguage())) {
                prepStmt.setNull(25, 12);
            } else {
                prepStmt.setString(25, detail.getLanguage());
            }
            if (detail.isRemoved()) {
                prepStmt.setString(26, DateUtil.formatDate((Date)detail.getRemovalDate()));
                prepStmt.setString(27, detail.getRemoverId());
            } else {
                prepStmt.setNull(26, 12);
                prepStmt.setNull(27, 12);
            }
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            SilverLogger.getLogger(PublicationDAO.class).error((Throwable)e);
        }
    }

    private static boolean isUndefined(String object) {
        return !StringUtil.isDefined((String)object);
    }

    public void deleteRow(Connection con, PublicationPK pk) throws SQLException {
        PublicationFatherDAO.removeAllFathers(con, pk);
        StringBuilder deleteStatement = new StringBuilder(128);
        deleteStatement.append("delete from ").append(pk.getTableName()).append(" where pubId = ").append(pk.getId());
        try (Statement stmt = con.createStatement();){
            stmt.executeUpdate(deleteStatement.toString());
        }
    }

    public PublicationDetail selectByPrimaryKey(Connection con, PublicationPK primaryKey) throws SQLException {
        try {
            return this.loadRow(con, primaryKey);
        }
        catch (PublicationRuntimeException e) {
            return null;
        }
    }

    public PublicationDetail selectByPublicationName(Connection con, PublicationPK primaryKey, String name) throws SQLException {
        return this.selectByName(con, primaryKey, name);
    }

    public PublicationDetail selectByPublicationNameAndNodeId(Connection con, PublicationPK primaryKey, String name, int nodeId) throws SQLException {
        return this.selectByNameAndNodeId(con, primaryKey, name, nodeId);
    }

    private static PublicationDetail resultSet2PublicationDetail(ResultSet rs) throws SQLException {
        return PublicationDAO.resultSet2PublicationDetail(rs, false);
    }

    private static PublicationDetail resultSet2PublicationDetail(ResultSet rs, boolean getSort) throws SQLException {
        PublicationDetail pub;
        PublicationPK pk = null;
        try {
            int id = rs.getInt("pubid");
            String componentId = rs.getString("instanceId");
            pk = new PublicationPK(String.valueOf(id), componentId);
            String infoId = rs.getString("infoid");
            String name = rs.getString("pubname");
            String description = StringUtil.defaultStringIfNotDefined((String)rs.getString("pubDescription"));
            Date creationDate = DateUtil.parseDate((String)rs.getString("pubCreationDate"));
            Date beginDate = PublicationDAO.asDate((String)rs.getString("pubBeginDate"), (String)NULL_BEGIN_DATE);
            Date endDate = PublicationDAO.asDate((String)rs.getString("pubEndDate"), (String)NULL_END_DATE);
            String creatorId = rs.getString("pubCreatorId");
            int importance = rs.getInt("pubImportance");
            String version = rs.getString("pubVersion");
            String keywords = rs.getString("pubKeywords");
            String content = rs.getString("pubContent");
            String status = rs.getString("pubStatus");
            String u = rs.getString("pubUpdateDate");
            Date updateDate = u != null ? DateUtil.parseDate((String)u) : creationDate;
            String updaterId = StringUtil.defaultStringIfNotDefined((String)rs.getString("pubUpdaterId"), (String)creatorId);
            String r = rs.getString(PUB_REMOVAL_DATE);
            Date removalDate = r != null ? DateUtil.parseDate((String)r) : null;
            String removerId = StringUtil.defaultStringIfNotDefined((String)rs.getString(PUB_REMOVER_ID), null);
            String strValDate = rs.getString("pubValidateDate");
            Date validateDate = DateUtil.parseDate((String)strValDate);
            String validatorId = rs.getString("pubValidatorId");
            String beginHour = rs.getString("pubBeginHour");
            String endHour = rs.getString("pubEndHour");
            String author = rs.getString("pubAuthor");
            String targetValidatorId = rs.getString("pubTargetValidatorId");
            int tempPubId = rs.getInt("pubCloneId");
            String cloneStatus = rs.getString("pubCloneStatus");
            String lang = rs.getString("lang");
            int order = -1;
            if (getSort) {
                order = rs.getInt("pubOrder");
            }
            pub = PublicationDetail.builder(lang).setPk(pk).setNameAndDescription(name, description).created(creationDate, creatorId).updated(updateDate, updaterId).removed(removalDate, removerId).validated(validateDate, validatorId).setBeginDateTime(beginDate, beginHour).setEndDateTime(endDate, endHour).setImportance(importance).setVersion(version).setKeywords(keywords).setContentPagePath(content).build();
            pub.setStatus(status);
            pub.setAuthor(author);
            pub.setInfoId(infoId);
            pub.setTargetValidatorId(targetValidatorId);
            pub.setCloneId(Integer.toString(tempPubId));
            pub.setCloneStatus(cloneStatus);
            pub.setExplicitRank(order);
        }
        catch (ParseException e) {
            throw new SQLException("PublicationDAO : resultSet2PublicationDetail() : internal error : a date format unknown for publication.pk = " + String.valueOf(pk) + " : " + String.valueOf(e));
        }
        return pub;
    }

    public Collection<PublicationDetail> selectByFatherPK(Connection con, NodePK fatherPK) throws SQLException {
        return this.selectByFatherPK(con, fatherPK, null);
    }

    public Collection<PublicationDetail> selectByFatherPK(Connection con, NodePK fatherPK, String sorting, boolean filterOnVisibilityPeriod) throws SQLException {
        return this.selectByFatherPK(con, fatherPK, sorting, filterOnVisibilityPeriod, null);
    }

    public Collection<PublicationDetail> selectByFatherPK(Connection con, NodePK fatherPK, String sorting, boolean filterOnVisibilityPeriod, String userId) throws SQLException {
        PublicationPK pubPK = new PublicationPK(UNDEFINED_ID, fatherPK);
        StringBuilder selectStatement = new StringBuilder(QueryStringFactory.getSelectByFatherPK(pubPK.getTableName(), filterOnVisibilityPeriod, userId));
        if (sorting != null) {
            selectStatement.append(", ").append(sorting);
        }
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement.toString());){
            prepStmt.setString(1, pubPK.getComponentName());
            prepStmt.setInt(2, Integer.parseInt(fatherPK.getId()));
            int index = 3;
            if (StringUtil.isDefined((String)userId)) {
                prepStmt.setString(3, userId);
                prepStmt.setString(4, userId);
                index = 5;
            }
            if (filterOnVisibilityPeriod) {
                Date now = new Date();
                String dateNow = DateUtil.formatDate((Date)now);
                String hourNow = DateUtil.formatTime((Date)now);
                prepStmt.setString(index, dateNow);
                prepStmt.setString(++index, dateNow);
                prepStmt.setString(++index, dateNow);
                prepStmt.setString(++index, dateNow);
                prepStmt.setString(++index, hourNow);
                prepStmt.setString(++index, dateNow);
                prepStmt.setString(++index, dateNow);
                prepStmt.setString(++index, hourNow);
                prepStmt.setString(++index, dateNow);
                prepStmt.setString(++index, dateNow);
                prepStmt.setString(++index, hourNow);
                prepStmt.setString(++index, hourNow);
            }
            ArrayList<PublicationDetail> list = new ArrayList<PublicationDetail>();
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    PublicationDetail pub = PublicationDAO.resultSet2PublicationDetail(rs, true);
                    list.add(pub);
                }
            }
            ArrayList<PublicationDetail> arrayList = list;
            return arrayList;
        }
    }

    public Collection<PublicationDetail> selectByFatherPK(Connection con, NodePK fatherPK, String sorting) throws SQLException {
        return this.selectByFatherPK(con, fatherPK, sorting, true, null);
    }

    public Collection<PublicationDetail> selectNotInFatherPK(Connection con, NodePK fatherPK, String sorting) throws SQLException {
        PublicationPK pubPK = new PublicationPK(UNDEFINED_ID, fatherPK);
        Object selectStatement = QueryStringFactory.getSelectNotInFatherPK(pubPK.getTableName());
        if (sorting != null) {
            selectStatement = (String)selectStatement + ORDER_BY + sorting;
        }
        try (PreparedStatement prepStmt = con.prepareStatement((String)selectStatement);){
            Date now = new Date();
            String dateNow = DateUtil.formatDate((Date)now);
            String hourNow = DateUtil.formatTime((Date)now);
            prepStmt.setString(1, pubPK.getComponentName());
            prepStmt.setInt(2, Integer.parseInt(fatherPK.getId()));
            PublicationDAO.setDateVisibility(prepStmt, dateNow, hourNow, true);
            ArrayList<PublicationDetail> list = new ArrayList<PublicationDetail>();
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    PublicationDetail pub = PublicationDAO.resultSet2PublicationDetail(rs);
                    list.add(pub);
                }
            }
            ArrayList<PublicationDetail> arrayList = list;
            return arrayList;
        }
    }

    public List<PublicationDetail> selectByFatherIds(Connection con, List<String> fatherIds, String instanceId, String sorting, List<String> status, boolean filterOnVisibilityPeriod) throws SQLException {
        ArrayList<PublicationDetail> list = new ArrayList<PublicationDetail>();
        StringBuilder whereClause = new StringBuilder(128);
        if (fatherIds != null) {
            whereClause.append("(");
            for (String fatherId : fatherIds) {
                whereClause.append(" F.nodeId = ").append(fatherId);
                whereClause.append(" or ");
            }
            whereClause.replace(whereClause.length() - 3, whereClause.length(), " ) ");
        }
        StringBuilder selectStatement = new StringBuilder(128);
        selectStatement.append("select distinct P.pubId, P.infoId, P.pubName, P.pubDescription, P.pubCreationDate, P.pubBeginDate, ");
        selectStatement.append("P.pubEndDate, P.pubCreatorId, P.pubImportance, P.pubVersion, P.pubKeywords, P.pubContent, ");
        selectStatement.append("P.pubStatus, P.pubUpdateDate, P.instanceId, P.pubUpdaterId, P.pubValidateDate, ");
        selectStatement.append("P.pubValidatorId, P.pubBeginHour, P.pubEndHour, P.pubAuthor, P.pubTargetValidatorId, ");
        selectStatement.append("P.pubCloneId, P.pubCloneStatus, P.lang, P.pubRemovalDate, P.pubRemoverId, F.puborder ");
        selectStatement.append("from ").append(PUBLICATION_TABLE_NAME).append(" P, ").append(PUBLICATION_TABLE_NAME).append(FATHER_F);
        selectStatement.append("where ").append((CharSequence)whereClause);
        if (filterOnVisibilityPeriod) {
            selectStatement.append(AND);
            selectStatement.append(P_PUB_BEGIN_DATE_AND_P_PUB_END_DATE_OR);
            selectStatement.append(P_PUB_BEGIN_DATE_AND_P_PUB_END_DATE_AND_P_PUB_BEGIN_HOUR_OR);
            selectStatement.append(P_PUB_BEGIN_DATE_AND_P_PUB_END_DATE_AND_P_PUB_END_HOUR_OR);
            selectStatement.append("( ? = P.pubBeginDate AND ? = P.pubEndDate AND ? > P.pubBeginHour AND ? < P.pubEndHour )");
            selectStatement.append(" ) ");
        }
        selectStatement.append(AND_F_PUB_ID_EQUAL_P_PUB_ID);
        selectStatement.append(" and F.instanceId='").append(instanceId).append("'");
        if (status != null && !status.isEmpty()) {
            StringBuilder statusBuffer = new StringBuilder();
            Iterator<String> it = status.iterator();
            statusBuffer.append("(");
            while (it.hasNext()) {
                String sStatus = it.next();
                statusBuffer.append(" P.pubStatus = '").append(sStatus).append("'");
                if (it.hasNext()) {
                    statusBuffer.append(" or ");
                    continue;
                }
                statusBuffer.append(" ) ");
            }
            selectStatement.append(" and ").append((CharSequence)statusBuffer);
        }
        if (sorting != null) {
            selectStatement.append(ORDER_BY).append(sorting);
        }
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement.toString());){
            Date now = new Date();
            String dateNow = DateUtil.formatDate((Date)now);
            String hourNow = DateUtil.formatTime((Date)now);
            if (filterOnVisibilityPeriod) {
                prepStmt.setString(1, dateNow);
                prepStmt.setString(2, dateNow);
                PublicationDAO.setDateVisibility(prepStmt, dateNow, hourNow, false);
            }
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    PublicationDetail pub = PublicationDAO.resultSet2PublicationDetail(rs);
                    list.add(pub);
                }
            }
        }
        return list;
    }

    public List<PublicationDetail> getByIds(Connection con, Collection<String> publicationIds, Set<PublicationPK> indexedPks) {
        try {
            HashMap result = new HashMap(publicationIds.size());
            JdbcSqlQuery.executeBySplittingOn(publicationIds, (idBatch, ignore) -> JdbcSqlQuery.select((String)QueryStringFactory.getLoadRowFields()).from(new String[]{SB_PUBLICATION_PUBLI_TABLE}).where(PUB_ID, new Object[0]).in((Collection)idBatch.stream().map(Integer::parseInt).collect(Collectors.toList())).executeWith(con, r -> {
                PublicationDetail publicationDetail = PublicationDAO.resultSet2PublicationDetail((ResultSet)r);
                if (indexedPks == null || indexedPks.contains(publicationDetail.getPK())) {
                    result.put(publicationDetail.getId(), publicationDetail);
                }
                return null;
            }));
            return publicationIds.stream().map(result::get).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (SQLException e) {
            SilverLogger.getLogger(PublicationDAO.class).error("failing getting publications from PK list", new Object[0]);
            return new ArrayList<PublicationDetail>();
        }
    }

    public List<PublicationDetail> getMinimalDataByIds(Connection con, Collection<PublicationPK> ids) throws SQLException {
        List pubIds = ids.stream().map(p -> Integer.parseInt(p.getId())).collect(Collectors.toList());
        ArrayList<PublicationDetail> result = new ArrayList<PublicationDetail>(ids.size());
        JdbcSqlQuery.executeBySplittingOn(pubIds, (subListOfPubIds, ignore) -> JdbcSqlQuery.select((String)"pubId, instanceId, pubStatus, pubCloneId, pubCloneStatus,").addSqlPart("pubBeginDate, pubEndDate, pubBeginHour, pubEndHour,", new Object[0]).addSqlPart("pubcreatorid, pubupdaterid", new Object[0]).from(new String[]{SB_PUBLICATION_PUBLI_TABLE}).where(PUB_ID, new Object[0]).in(subListOfPubIds).executeWith(con, r -> {
            int thePubId = r.getInt(1);
            PublicationPK pk = new PublicationPK(Integer.toString(thePubId), r.getString(2));
            if (pubIds.contains(thePubId)) {
                PublicationDetail pubDetail = PublicationDetail.builder().setPk(pk).build();
                pubDetail.setStatus(r.getString(3));
                pubDetail.setCloneId(Integer.toString(r.getInt(4)));
                pubDetail.setCloneStatus(r.getString(5));
                try {
                    pubDetail.setBeginDate(PublicationDAO.asDate((String)r.getString(6), (String)NULL_BEGIN_DATE));
                    pubDetail.setEndDate(PublicationDAO.asDate((String)r.getString(7), (String)NULL_END_DATE));
                }
                catch (ParseException e) {
                    throw new SQLException(e);
                }
                pubDetail.setBeginHour(r.getString(8));
                pubDetail.setEndHour(r.getString(9));
                pubDetail.setCreatorId(r.getString(10));
                pubDetail.setUpdaterId(r.getString(11));
                result.add(pubDetail);
            }
            return null;
        }));
        return result;
    }

    public SilverpeasList<PublicationPK> selectPksByCriteria(Connection con, PublicationCriteria criteria) throws SQLException {
        if (!criteria.emptyResultWhenNoFilteringOnComponentInstances()) {
            JdbcSqlQuery query = this.prepareSelectPksByCriteria(criteria);
            this.configureSelectByCriteria(query, criteria);
            this.configureFromByCriteria(query, criteria);
            this.configureClausesByCriteria(query, criteria);
            this.configureOrderingByCriteria(query, criteria);
            this.configureExecution(query, criteria);
            return query.executeWith(con, r -> new PublicationPK(r.getString(1), r.getString(2)));
        }
        return new SilverpeasArrayList(0);
    }

    public SilverpeasList<PublicationDetail> selectPublicationsByCriteria(Connection con, PublicationCriteria criteria) throws SQLException {
        if (!criteria.emptyResultWhenNoFilteringOnComponentInstances()) {
            JdbcSqlQuery query = this.prepareSelectPublicationsByCriteria(criteria);
            this.configureSelectByCriteria(query, criteria);
            this.configureFromByCriteria(query, criteria);
            this.configureClausesByCriteria(query, criteria);
            this.configureOrderingByCriteria(query, criteria);
            this.configureExecution(query, criteria);
            return query.executeWith(con, PublicationDAO::resultSet2PublicationDetail);
        }
        return new SilverpeasArrayList(0);
    }

    private JdbcSqlQuery prepareSelectPublicationsByCriteria(PublicationCriteria criteria) {
        if (criteria.mustJoinOnNodeFatherTable()) {
            return JdbcSqlQuery.select((String)"DISTINCT P.*");
        }
        return JdbcSqlQuery.select((String)"P.*");
    }

    private JdbcSqlQuery prepareSelectPksByCriteria(PublicationCriteria criteria) {
        JdbcSqlQuery query = criteria.mustJoinOnNodeFatherTable() ? JdbcSqlQuery.select((String)"DISTINCT(P.pubId)") : JdbcSqlQuery.select((String)"P.pubId");
        if (!criteria.getComponentInstanceIds().isEmpty()) {
            query.addSqlPart(", P.instanceId", new Object[0]);
        }
        criteria.getOrderByList().stream().filter(o -> o != PublicationCriteria.QUERY_ORDER_BY.BEGIN_VISIBILITY_DATE_ASC && o != PublicationCriteria.QUERY_ORDER_BY.BEGIN_VISIBILITY_DATE_DESC).filter(o -> o != PublicationCriteria.QUERY_ORDER_BY.CREATION_DATE_ASC && o != PublicationCriteria.QUERY_ORDER_BY.CREATION_DATE_DESC).forEach(o -> query.addSqlPart(", P." + o.getPropertyName(), new Object[0]));
        return query;
    }

    private void configureSelectByCriteria(JdbcSqlQuery query, PublicationCriteria criteria) {
        criteria.getOrderByList().stream().filter(o -> o == PublicationCriteria.QUERY_ORDER_BY.BEGIN_VISIBILITY_DATE_ASC || o == PublicationCriteria.QUERY_ORDER_BY.BEGIN_VISIBILITY_DATE_DESC).findFirst().ifPresent(o -> query.addSqlPart(", CASE WHEN P.pubUpdateDate > P.pubBeginDate THEN P.pubUpdateDate ELSE P.pubBeginDate END AS " + o.getPropertyName(), new Object[0]));
    }

    private void configureFromByCriteria(JdbcSqlQuery query, PublicationCriteria criteria) {
        query.from(new String[]{"SB_Publication_Publi P"});
        if (criteria.mustJoinOnNodeFatherTable()) {
            query.join("SB_Publication_PubliFather F").on("F.pubId = P.pubId", new Object[0]);
        }
        if (!criteria.getComponentInstanceIds().isEmpty()) {
            String instanceSelector = criteria.isAliasesTakenIntoAccount() ? "F" : "P";
            query.join("ST_ComponentInstance I").on(instanceSelector + ".instanceid = CONCAT(I.componentname , CAST(I.id AS VARCHAR(20)))", new Object[0]);
        }
    }

    private void configureClausesByCriteria(JdbcSqlQuery query, PublicationCriteria criteria) {
        List componentIds = criteria.getComponentInstanceIds().stream().map(ComponentInst::getComponentLocalId).collect(Collectors.toList());
        Set<Integer> includedNodeIds = criteria.getIncludedNodeIds();
        Set<Integer> excludedNodeIds = criteria.getExcludedNodeIds();
        OffsetDateTime visibilityDate = criteria.getVisibilityDate();
        OffsetDateTime invisibilityDate = criteria.getInvisibilityDate();
        OffsetDateTime updatedSince = criteria.getLastUpdatedSince();
        String conjunction = WHERE_CONJUNCTION;
        if (!criteria.getStatuses().isEmpty()) {
            query.addSqlPart(conjunction + "P.pubStatus", new Object[0]).in(criteria.getStatuses());
            conjunction = AND_CONJUNCTION;
        }
        if (!includedNodeIds.isEmpty()) {
            query.addSqlPart(conjunction + "F.nodeId", new Object[0]).in(includedNodeIds);
            conjunction = AND_CONJUNCTION;
        }
        if (!excludedNodeIds.isEmpty()) {
            query.addSqlPart(conjunction + "F.nodeId", new Object[0]).notIn(excludedNodeIds);
            conjunction = AND_CONJUNCTION;
        }
        if (updatedSince != null) {
            query.addSqlPart(conjunction + "P.pubupdatedate > ?", new Object[]{DateUtil.formatDate((LocalDate)updatedSince.toLocalDate())});
            conjunction = AND_CONJUNCTION;
        }
        if (!componentIds.isEmpty()) {
            query.addSqlPart(conjunction + "I.id", new Object[0]).in(componentIds);
            conjunction = AND_CONJUNCTION;
        }
        if (visibilityDate != null) {
            this.visibleFilter(query, conjunction, visibilityDate, "P");
        } else if (invisibilityDate != null) {
            this.nonVisibleFilter(query, conjunction, invisibilityDate);
        }
    }

    private void visibleFilter(JdbcSqlQuery sqlQuery, String conjunction, OffsetDateTime visibilityDate, String target) {
        Date asDateType = TemporalConverter.asDate((Temporal)visibilityDate);
        String dateNow = DateUtil.formatDate((Date)asDateType);
        String hourNow = DateUtil.formatTime((Date)asDateType);
        String p = target + ".";
        sqlQuery.addSqlPart(conjunction + PublicationDAO.f("((? > %spubBeginDate", p), new Object[]{dateNow}).and(PublicationDAO.f("? < %spubEndDate)", p), new Object[]{dateNow}).or(PublicationDAO.f("(? = %spubBeginDate", p), new Object[]{dateNow}).and(PublicationDAO.f("? < %spubEndDate", p), new Object[]{dateNow}).and(PublicationDAO.f("? > %spubBeginHour)", p), new Object[]{hourNow}).or(PublicationDAO.f("(? > %spubBeginDate", p), new Object[]{dateNow}).and(PublicationDAO.f("? = %spubEndDate", p), new Object[]{dateNow}).and(PublicationDAO.f("? < %spubEndHour)", p), new Object[]{hourNow}).or(PublicationDAO.f("(? = %spubBeginDate", p), new Object[]{dateNow}).and(PublicationDAO.f("? = %spubEndDate", p), new Object[]{dateNow}).and(PublicationDAO.f("? > %spubBeginHour", p), new Object[]{hourNow}).and(PublicationDAO.f("? < %spubEndHour))", p), new Object[]{hourNow});
    }

    private static String f(String sqlToFormat, String prefix) {
        return String.format(sqlToFormat, prefix);
    }

    private void nonVisibleFilter(JdbcSqlQuery sqlQuery, String conjunction, OffsetDateTime invisibilityDate) {
        Date asDateType = TemporalConverter.asDate((Temporal)invisibilityDate);
        String dateNow = DateUtil.formatDate((Date)asDateType);
        String hourNow = DateUtil.formatTime((Date)asDateType);
        sqlQuery.addSqlPart(conjunction + "((? < P.pubBeginDate", new Object[]{dateNow}).or("? > P.pubEndDate)", new Object[]{dateNow}).or("(? = P.pubBeginDate", new Object[]{dateNow}).and("? < P.pubBeginHour)", new Object[]{hourNow}).or("(? = P.pubEndDate", new Object[]{dateNow}).and("? > P.pubEndHour))", new Object[]{hourNow});
    }

    private void configureOrderingByCriteria(JdbcSqlQuery query, PublicationCriteria criteria) {
        List<PublicationCriteria.QUERY_ORDER_BY> orderBies = criteria.getOrderByList();
        if (!orderBies.isEmpty()) {
            query.orderBy(new String[]{orderBies.stream().map(o -> (o.isComplex() ? "" : "P.") + o.getPropertyName() + " " + (o.isAsc() ? "asc" : "desc")).collect(Collectors.joining(","))});
        }
    }

    private void configureExecution(JdbcSqlQuery query, PublicationCriteria criteria) {
        PaginationPage pagination = criteria.getPagination();
        if (pagination != null) {
            if (criteria.getOrderByList().isEmpty()) {
                throw new IllegalArgumentException("it is not possible to paginate without order by clauses : " + String.valueOf(criteria));
            }
            query.withPagination(pagination.asCriterion());
        }
    }

    public Collection<PublicationDetail> selectAllPublications(Connection con, String instanceId, String sorting) throws SQLException {
        StringBuilder selectStatement = new StringBuilder(128);
        selectStatement.append(SELECT_FROM).append(PUBLICATION_TABLE_NAME).append(" P where P.instanceId='").append(instanceId).append("'");
        if (sorting != null) {
            selectStatement.append(ORDER_BY).append(sorting);
        }
        try (Statement stmt = con.createStatement();){
            ArrayList<PublicationDetail> arrayList;
            block14: {
                ResultSet rs = stmt.executeQuery(selectStatement.toString());
                try {
                    ArrayList<PublicationDetail> list = new ArrayList<PublicationDetail>();
                    while (rs.next()) {
                        PublicationDetail pub = PublicationDAO.resultSet2PublicationDetail(rs);
                        list.add(pub);
                    }
                    arrayList = list;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    public Collection<PublicationDetail> getOrphanPublications(Connection con, String componentId) throws SQLException {
        String query = "select * from SB_Publication_Publi where pubId NOT IN (Select pubId from SB_Publication_PubliFather)  and instanceId=?";
        try (PreparedStatement stmt = con.prepareStatement("select * from SB_Publication_Publi where pubId NOT IN (Select pubId from SB_Publication_PubliFather)  and instanceId=?");){
            stmt.setString(1, componentId);
            ArrayList<PublicationDetail> list = new ArrayList<PublicationDetail>();
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    PublicationDetail pub = PublicationDAO.resultSet2PublicationDetail(rs);
                    list.add(pub);
                }
            }
            ArrayList<PublicationDetail> arrayList = list;
            return arrayList;
        }
    }

    public PublicationDetail loadRow(Connection con, PublicationPK pk) throws SQLException {
        String selectStatement = QueryStringFactory.getLoadRow(pk.getTableName());
        try (PreparedStatement stmt = con.prepareStatement(selectStatement);){
            stmt.setInt(1, Integer.parseInt(pk.getId()));
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    PublicationDetail pub;
                    PublicationDetail publicationDetail = pub = PublicationDAO.resultSet2PublicationDetail(rs);
                    return publicationDetail;
                }
                throw new PublicationRuntimeException("Publication with id = " + pk.getId() + " not found in database!");
            }
        }
    }

    public void changeInstanceId(Connection con, PublicationPK pubPK, String newInstanceId) throws SQLException {
        int rowCount;
        String updateQuery = "update SB_Publication_Publi set instanceId = ?  where pubId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement("update SB_Publication_Publi set instanceId = ?  where pubId = ? ");){
            prepStmt.setString(1, newInstanceId);
            prepStmt.setInt(2, Integer.parseInt(pubPK.getId()));
            rowCount = prepStmt.executeUpdate();
        }
        if (rowCount == 0) {
            throw new PublicationRuntimeException("The update of the publication with id = " + pubPK.getId() + " failed!");
        }
    }

    public void storeRow(Connection con, PublicationDetail detail) throws SQLException {
        int rowCount;
        try (PreparedStatement prepStmt = con.prepareStatement(UPDATE_PUBLICATION);){
            prepStmt.setString(1, detail.getInfoId());
            prepStmt.setString(2, detail.getName());
            prepStmt.setString(3, detail.getDescription());
            prepStmt.setString(4, DateUtil.formatDate((Date)detail.getCreationDate()));
            PublicationDAO.setDateParameter((PreparedStatement)prepStmt, (int)5, (Date)detail.getBeginDate(), (String)NULL_BEGIN_DATE);
            PublicationDAO.setDateParameter((PreparedStatement)prepStmt, (int)6, (Date)detail.getEndDate(), (String)NULL_END_DATE);
            prepStmt.setString(7, detail.getCreatorId());
            prepStmt.setInt(8, detail.getImportance());
            prepStmt.setString(9, detail.getVersion());
            prepStmt.setString(10, detail.getKeywords());
            prepStmt.setString(11, detail.getContentPagePath());
            prepStmt.setString(12, detail.getStatus());
            PublicationDAO.setDateParameter((PreparedStatement)prepStmt, (int)13, (Date)detail.getLastUpdateDate(), (String)DateUtil.formatDate((Date)detail.getCreationDate()));
            if (detail.getUpdaterId() == null) {
                prepStmt.setString(14, detail.getCreatorId());
            } else {
                prepStmt.setString(14, detail.getUpdaterId());
            }
            prepStmt.setString(15, detail.getPK().getComponentName());
            prepStmt.setString(16, detail.getValidatorId());
            if (detail.getValidateDate() != null) {
                prepStmt.setString(17, DateUtil.formatDate((Date)detail.getValidateDate()));
            } else {
                prepStmt.setString(17, null);
            }
            if (PublicationDAO.isUndefined(detail.getBeginHour())) {
                prepStmt.setString(18, NULL_BEGIN_HOUR);
            } else {
                prepStmt.setString(18, detail.getBeginHour());
            }
            if (PublicationDAO.isUndefined(detail.getEndHour())) {
                prepStmt.setString(19, NULL_END_HOUR);
            } else {
                prepStmt.setString(19, detail.getEndHour());
            }
            if (PublicationDAO.isUndefined(detail.getAuthor())) {
                prepStmt.setString(20, null);
            } else {
                prepStmt.setString(20, detail.getAuthor());
            }
            prepStmt.setString(21, detail.getTargetValidatorId());
            if (PublicationDAO.isUndefined(detail.getCloneId())) {
                prepStmt.setInt(22, -1);
            } else {
                prepStmt.setInt(22, Integer.parseInt(detail.getCloneId()));
            }
            prepStmt.setString(23, detail.getCloneStatus());
            prepStmt.setString(24, detail.getLanguage());
            prepStmt.setInt(25, Integer.parseInt(detail.getPK().getId()));
            rowCount = prepStmt.executeUpdate();
        }
        if (rowCount == 0) {
            throw new PublicationRuntimeException("The update of the publication with id = " + detail.getPK().getId() + " failed!");
        }
    }

    public PublicationDetail selectByName(Connection con, PublicationPK pubPK, String name) throws SQLException {
        PublicationDetail pub = null;
        String selectStatement = QueryStringFactory.getSelectByName();
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setString(1, name);
            prepStmt.setString(2, pubPK.getComponentName());
            try (ResultSet rs = prepStmt.executeQuery();){
                if (rs.next()) {
                    pub = PublicationDAO.resultSet2PublicationDetail(rs);
                }
            }
        }
        return pub;
    }

    public PublicationDetail selectByNameAndNodeId(Connection con, PublicationPK pubPK, String name, int nodeId) throws SQLException {
        PublicationDetail pub = null;
        String selectStatement = QueryStringFactory.getSelectByNameAndNodeId();
        try (PreparedStatement prepStmt = con.prepareStatement(selectStatement);){
            prepStmt.setString(1, name);
            prepStmt.setString(2, pubPK.getComponentName());
            prepStmt.setInt(3, nodeId);
            try (ResultSet rs = prepStmt.executeQuery();){
                if (rs.next()) {
                    pub = PublicationDAO.resultSet2PublicationDetail(rs);
                }
            }
        }
        return pub;
    }

    public Collection<PublicationDetail> selectBetweenDate(Connection con, String beginDate, String endDate, String instanceId) throws SQLException {
        String selectStatement = "select * from SB_Publication_Publi where instanceId = ?  and (( ? <= pubCreationDate AND ? >= pubCreationDate )  )  order by pubCreationDate DESC, pubId DESC";
        try (PreparedStatement prepStmt = con.prepareStatement("select * from SB_Publication_Publi where instanceId = ?  and (( ? <= pubCreationDate AND ? >= pubCreationDate )  )  order by pubCreationDate DESC, pubId DESC");){
            prepStmt.setString(1, instanceId);
            prepStmt.setString(2, beginDate);
            prepStmt.setString(3, endDate);
            ArrayList<PublicationDetail> list = new ArrayList<PublicationDetail>();
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    PublicationDetail pub = PublicationDAO.resultSet2PublicationDetail(rs);
                    list.add(pub);
                }
            }
            ArrayList<PublicationDetail> arrayList = list;
            return arrayList;
        }
    }

    public SilverpeasList<SocialInformationPublication> getAllPublicationsIDbyUserid(Connection con, String userId, Date begin, Date end) throws SQLException {
        PaginationCriterion pagination = new PaginationCriterion(1, 500).setOriginalSizeRequired(false);
        HashMap<String, List<Boolean>> statusMapping = new HashMap<String, List<Boolean>>(pagination.getItemCount());
        ListSlice pubIds = JdbcSqlQuery.create((String)"(SELECT pubcreationdate AS dateinformation, pubid, 'false' as type", (Object[])new Object[0]).from(new String[]{SB_PUBLICATION_PUBLI_TABLE}).where("pubcreatorid = ?", new Object[]{userId}).and(PUBSTATUS_VALID_CRITERION, new Object[0]).and("pubCreationDate >= ?", new Object[]{DateUtil.date2SQLDate((Date)begin)}).and("pubCreationDate <= ?)", new Object[]{DateUtil.date2SQLDate((Date)end)}).union().addSqlPart("(SELECT pubupdatedate AS dateinformation, pubid, 'true' as type", new Object[0]).from(new String[]{SB_PUBLICATION_PUBLI_TABLE}).where("pubupdaterid = ?", new Object[]{userId}).and(PUBSTATUS_VALID_CRITERION, new Object[0]).and("pubupdatedate >= ?", new Object[]{DateUtil.date2SQLDate((Date)begin)}).and("pubupdatedate <= ?)", new Object[]{DateUtil.date2SQLDate((Date)end)}).orderBy(new String[]{"dateinformation DESC, pubid DESC, type"}).withPagination(pagination).executeWith(con, r -> {
            String pubId = Integer.toString(r.getInt(2));
            MapUtil.putAddList(statusMapping, pubId, r.getBoolean(3));
            return pubId;
        });
        return this.buildSocialInformationResult(con, (List<String>)pubIds, statusMapping);
    }

    private SilverpeasList<SocialInformationPublication> buildSocialInformationResult(Connection con, List<String> pubIds, Map<String, List<Boolean>> statusMapping) {
        HashMap publications = new HashMap(pubIds.size());
        this.getByIds(con, pubIds, null).forEach(p -> publications.put(p.getId(), p));
        return (SilverpeasList)pubIds.stream().map(i -> {
            PublicationDetail p = (PublicationDetail)publications.get(i);
            Boolean s = (Boolean)((List)statusMapping.get(i)).remove(0);
            PublicationWithStatus withStatus = new PublicationWithStatus(p, s);
            return new SocialInformationPublication(withStatus);
        }).collect(SilverpeasList.collector(pubIds));
    }

    public List<SocialInformationPublication> getSocialInformationsListOfMyContacts(Connection con, List<String> myContactsIds, List<String> options, Date begin, Date end) throws SQLException {
        if (options.isEmpty()) {
            return Collections.emptyList();
        }
        PaginationCriterion pagination = new PaginationCriterion(1, 500).setOriginalSizeRequired(false);
        HashMap<String, List<Boolean>> statusMapping = new HashMap<String, List<Boolean>>(pagination.getItemCount());
        ListSlice pubIds = JdbcSqlQuery.create((String)"(SELECT pubcreationdate AS dateinformation, pubid, 'false' as type", (Object[])new Object[0]).from(new String[]{SB_PUBLICATION_PUBLI_TABLE}).where("pubcreatorid", new Object[0]).in(myContactsIds).and("instanceid", new Object[0]).in(options).and(PUBSTATUS_VALID_CRITERION, new Object[0]).and("pubCreationDate >= ?", new Object[]{DateUtil.date2SQLDate((Date)begin)}).and("pubCreationDate <= ?)", new Object[]{DateUtil.date2SQLDate((Date)end)}).union().addSqlPart("(SELECT pubupdatedate AS dateinformation, pubid, 'true' as type", new Object[0]).from(new String[]{SB_PUBLICATION_PUBLI_TABLE}).where("pubupdaterid", new Object[0]).in(myContactsIds).and("instanceid", new Object[0]).in(options).and(PUBSTATUS_VALID_CRITERION, new Object[0]).and("pubupdatedate >= ?", new Object[]{DateUtil.date2SQLDate((Date)begin)}).and("pubupdatedate <= ?)", new Object[]{DateUtil.date2SQLDate((Date)end)}).orderBy(new String[]{"dateinformation DESC, pubid DESC, type"}).withPagination(pagination).executeWith(con, r -> {
            String pubId = Integer.toString(r.getInt(2));
            MapUtil.putAddList(statusMapping, pubId, r.getBoolean(3));
            return pubId;
        });
        return this.buildSocialInformationResult(con, (List<String>)pubIds, statusMapping);
    }

    public Collection<PublicationDetail> getDraftsByUser(Connection con, String userId) throws SQLException {
        String sb = "select * from sb_publication_publi where pubUpdaterId = ? and ((pubStatus = ? and pubcloneid = -1 and pubclonestatus is null) or (pubcloneid <> -1 and pubclonestatus = ? )) order by pubUpdateDate desc";
        ArrayList<PublicationDetail> publications = new ArrayList<PublicationDetail>();
        try (PreparedStatement prepStmt = con.prepareStatement("select * from sb_publication_publi where pubUpdaterId = ? and ((pubStatus = ? and pubcloneid = -1 and pubclonestatus is null) or (pubcloneid <> -1 and pubclonestatus = ? )) order by pubUpdateDate desc");){
            prepStmt.setString(1, userId);
            prepStmt.setString(2, "Draft");
            prepStmt.setString(3, "Draft");
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    publications.add(PublicationDAO.resultSet2PublicationDetail(rs));
                }
            }
        }
        return publications;
    }

    public List<PublicationDetail> getByTargetValidatorId(Connection con, String userId) throws SQLException {
        String sb = "select * from sb_publication_publi where pubTargetValidatorId like ?";
        ArrayList<PublicationDetail> publications = new ArrayList<PublicationDetail>();
        try (PreparedStatement prepStmt = con.prepareStatement("select * from sb_publication_publi where pubTargetValidatorId like ?");){
            prepStmt.setString(1, "%" + userId + "%");
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    String targetValidatorIds = rs.getString("pubTargetValidatorId");
                    Object[] userIds = StringUtil.split((String)targetValidatorIds, (char)',');
                    if (!ArrayUtil.contains(userIds, userId)) continue;
                    publications.add(PublicationDAO.resultSet2PublicationDetail(rs));
                }
            }
        }
        return publications;
    }

    public void updateTargetValidatorIds(Connection con, PublicationDetail detail) throws SQLException {
        try (PreparedStatement prepStmt = con.prepareStatement("update SB_Publication_Publi set pubtargetvalidatorid = ? where pubid = ? and instanceid = ? ");){
            prepStmt.setString(1, detail.getTargetValidatorId());
            prepStmt.setInt(2, Integer.parseInt(detail.getPK().getId()));
            prepStmt.setString(3, detail.getPK().getInstanceId());
            prepStmt.executeUpdate();
        }
    }
}

