/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.content.form.field;

import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.contribution.content.form.AbstractField;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.kernel.util.StringUtil;

public class UserField
extends AbstractField {
    private static final long serialVersionUID = -861888647155176647L;
    public static final String TYPE = "user";
    private String userId;

    @Override
    public String getTypeName() {
        return TYPE;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getValue() {
        String theUserId = this.getUserId();
        if (!StringUtil.isDefined((String)theUserId)) {
            return theUserId;
        }
        User user = User.getById((String)this.getUserId());
        if (user == null) {
            return "user(" + this.getUserId() + ")";
        }
        return user.getDisplayedName();
    }

    @Override
    public String getValue(String language) {
        return this.getValue();
    }

    @Override
    public void setValue(String value) throws FormException {
    }

    @Override
    public void setValue(String value, String language) throws FormException {
    }

    @Override
    public boolean acceptValue(String value) {
        return false;
    }

    @Override
    public boolean acceptValue(String value, String language) {
        return false;
    }

    @Override
    public Object getObjectValue() {
        if (this.getUserId() == null) {
            return null;
        }
        return User.getById((String)this.getUserId());
    }

    @Override
    public void setObjectValue(Object value) throws FormException {
        if (value instanceof UserDetail) {
            this.setUserId(((UserDetail)value).getId());
        } else if (value == null) {
            this.setUserId("");
        } else {
            throw new FormException("Incorrect field value type. Expected a user", new String[0]);
        }
    }

    @Override
    public boolean acceptObjectValue(Object value) {
        return value instanceof UserDetail && !this.isReadOnly();
    }

    @Override
    public String getStringValue() {
        return this.getUserId();
    }

    @Override
    public void setStringValue(String value) {
        this.setUserId(value);
    }

    @Override
    public boolean acceptStringValue(String value) {
        return !this.isReadOnly();
    }

    @Override
    public boolean isNull() {
        return this.getUserId() == null;
    }

    @Override
    public void setNull() throws FormException {
        this.setUserId(null);
    }

    public boolean equals(Object o) {
        String s = this.getUserId();
        if (s == null) {
            s = "";
        }
        if (o instanceof UserField) {
            String t = ((UserField)o).getUserId();
            if (t == null) {
                t = "";
            }
            return s.equals(t);
        }
        return false;
    }

    @Override
    public int compareTo(Field o) {
        String s = this.getValue();
        if (s == null) {
            s = "";
        }
        if (o instanceof UserField) {
            String t = o.getValue();
            if (t == null) {
                t = "";
            }
            if (s.equals(t)) {
                s = this.getUserId();
                if (s == null) {
                    s = "";
                }
                if ((t = ((UserField)o).getUserId()) == null) {
                    t = "";
                }
            }
            return s.compareTo(t);
        }
        return -1;
    }

    public int hashCode() {
        String s = this.getUserId();
        return s.hashCode();
    }
}

