/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.contribution.attachment.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.comparator.AbstractComplexComparator;
import org.silverpeas.kernel.util.StringUtil;

public class SimpleDocumentList<T extends SimpleDocument>
extends ArrayList<T> {
    private static final long serialVersionUID = 4986827710138035170L;
    private static final String[] ALL_LANGUAGES_BY_PRIORITY = I18NHelper.getAllSupportedLanguages().toArray(new String[I18NHelper.getNumberOfLanguages()]);
    private String queryLanguage = null;
    private boolean youngestToOldestAddSorted = false;

    public SimpleDocumentList(int initialCapacity) {
        super(initialCapacity);
    }

    public SimpleDocumentList() {
    }

    public SimpleDocumentList(Collection<? extends T> c) {
        super(c);
    }

    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    public SimpleDocumentList<T> setQueryLanguage(String queryLanguage) {
        this.queryLanguage = StringUtil.isDefined((String)queryLanguage) ? queryLanguage : null;
        return this;
    }

    public SimpleDocumentList<T> removeLanguageFallbacks() {
        String language;
        if (!this.isEmpty() && (language = I18NHelper.checkLanguage(this.getQueryLanguage())).equals(this.getQueryLanguage())) {
            this.removeIf(document -> !language.equals(document.getLanguage()));
        }
        return this;
    }

    public SimpleDocumentList<T> orderByLanguageAndLastUpdate(String ... languageOrderedByPriority) {
        if (this.size() > 1) {
            this.sort(new LanguageAndLastUpdateComparator(languageOrderedByPriority, ORDER_BY.LANGUAGE_PRIORITY_DESC, ORDER_BY.LAST_UPDATE_DATE_DESC));
        }
        return this;
    }

    protected boolean isManuallySorted() {
        boolean manuallySorted = false;
        if (this.size() > 1) {
            String foreignId = ((SimpleDocument)this.get(0)).getForeignId();
            if (this.stream().anyMatch(d -> !d.getForeignId().equals(foreignId))) {
                throw new IllegalStateException("the given list must only contain documents linked to foreignId " + foreignId);
            }
            for (int i = 1; !manuallySorted && i < this.size(); ++i) {
                SimpleDocument previous = (SimpleDocument)this.get(i - 1);
                SimpleDocument current = (SimpleDocument)this.get(i);
                if (previous.getOrder() >= current.getOrder()) break;
                manuallySorted = previous.getOrder() >= 100000 || previous.getOldSilverpeasId() > current.getOldSilverpeasId();
            }
        }
        return manuallySorted;
    }

    public void sortYoungestToOldestAddIfEnabled() {
        if (this.size() > 1 && !this.youngestToOldestAddSorted && AttachmentSettings.listFromYoungestToOldestAdd() && !this.isManuallySorted()) {
            this.sort(Comparator.comparing(SimpleDocument::getOldSilverpeasId).reversed());
            this.youngestToOldestAddSorted = true;
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private class LanguageAndLastUpdateComparator
    extends AbstractComplexComparator<T> {
        private static final long serialVersionUID = 4826457857348422450L;
        private Map<String, Integer> languagePriorityCache = new HashMap<String, Integer>(I18NHelper.getNumberOfLanguages());
        private final ORDER_BY[] orderBies;

        private LanguageAndLastUpdateComparator(String[] languageOrderedByPriority, ORDER_BY ... orderBies) {
            this.orderBies = orderBies;
            if (ArrayUtil.contains((Object[])orderBies, (Object)ORDER_BY.LANGUAGE_PRIORITY_DESC)) {
                for (String language : ALL_LANGUAGES_BY_PRIORITY) {
                    this.languagePriorityCache.put(language, this.languagePriorityCache.size() + ALL_LANGUAGES_BY_PRIORITY.length + 1);
                }
                int i = 0;
                for (String language : languageOrderedByPriority) {
                    this.languagePriorityCache.put(language, i++);
                }
                this.languagePriorityCache.put(null, this.languagePriorityCache.size() + ALL_LANGUAGES_BY_PRIORITY.length + 1);
            }
        }

        @Override
        protected AbstractComplexComparator.ValueBuffer getValuesToCompare(T simpleDocument) {
            AbstractComplexComparator.ValueBuffer valueBuffer = new AbstractComplexComparator.ValueBuffer();
            block4: for (ORDER_BY orderBy : this.orderBies) {
                switch (orderBy) {
                    case LANGUAGE_PRIORITY_DESC: {
                        valueBuffer.append(this.getLanguagePriorityIndex(simpleDocument), orderBy.isAscending());
                        continue block4;
                    }
                    case LAST_UPDATE_DATE_DESC: {
                        valueBuffer.append(((SimpleDocument)simpleDocument).getLastUpdateDate() != null ? ((SimpleDocument)simpleDocument).getLastUpdateDate() : ((SimpleDocument)simpleDocument).getCreationDate(), orderBy.isAscending());
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            return valueBuffer;
        }

        private int getLanguagePriorityIndex(T simpleDocument) {
            return this.languagePriorityCache.get(((SimpleDocument)simpleDocument).getLanguage()) * -1;
        }
    }

    private static enum ORDER_BY {
        LANGUAGE_PRIORITY_DESC(false),
        LAST_UPDATE_DATE_DESC(false);

        private final boolean ascending;

        private ORDER_BY(boolean ascending) {
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }
    }
}

