/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.cmis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.silverpeas.core.BasicIdentifier;
import org.silverpeas.core.ResourceIdentifier;
import org.silverpeas.core.cmis.model.CmisFilePath;
import org.silverpeas.core.cmis.model.CmisFilePathProvider;
import org.silverpeas.core.cmis.model.CmisFolder;
import org.silverpeas.core.cmis.model.TypeId;

public class Space
extends CmisFolder {
    public static final BasicIdentifier ROOT_ID = new BasicIdentifier(0, "WA0");
    public static final TypeId CMIS_TYPE = TypeId.SILVERPEAS_SPACE;
    public static final String SYMBOL = "\u2617";

    public static List<TypeId> getAllAllowedChildrenTypes() {
        return Arrays.asList(TypeId.SILVERPEAS_SPACE, TypeId.SILVERPEAS_APPLICATION);
    }

    public static boolean isSpace(String folderId) {
        return folderId.startsWith("WA");
    }

    Space(ResourceIdentifier id, String name, String language) {
        super(id, name, language);
    }

    @Override
    public String getSymbol() {
        return SYMBOL;
    }

    @Override
    public String getPath() {
        String path;
        if (ROOT_ID.asString().equals(this.getId())) {
            path = "/";
        } else {
            CmisFilePath myPath = CmisFilePathProvider.get().getPath(this);
            path = myPath.toString();
        }
        return path;
    }

    @Override
    public BaseTypeId getBaseTypeId() {
        return CMIS_TYPE.getBaseTypeId();
    }

    @Override
    public TypeId getTypeId() {
        return CMIS_TYPE;
    }

    @Override
    public boolean isRoot() {
        return ROOT_ID.asString().equals(this.getId());
    }

    @Override
    public List<TypeId> getAllowedChildrenTypes() {
        return this.isRoot() ? Collections.singletonList(TypeId.SILVERPEAS_SPACE) : Space.getAllAllowedChildrenTypes();
    }
}

