/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.admin.user.notification.role;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.notification.ProfileInstEvent;
import org.silverpeas.core.admin.user.notification.role.UserRoleChangeNotifier;
import org.silverpeas.core.admin.user.notification.role.UserRoleEvent;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.notification.system.CDIAfterSuccessfulTransactionResourceEventListener;
import org.silverpeas.core.notification.system.ResourceEvent;

@Service
class ProfileInstUpdateEventListener
extends CDIAfterSuccessfulTransactionResourceEventListener<ProfileInstEvent> {
    @Inject
    private OrganizationController organization;
    @Inject
    private UserRoleChangeNotifier notifier;

    ProfileInstUpdateEventListener() {
    }

    public void onUpdate(ProfileInstEvent event) {
        ComponentInst componentInst;
        Set<String> removedUsers;
        ProfileInst before = (ProfileInst)event.getTransition().getBefore();
        ProfileInst after = (ProfileInst)event.getTransition().getAfter();
        if (before.getObjectId().isNotDefined() && !(removedUsers = this.findRemovedUsersId(componentInst = this.getComponentInstanceId(before.getComponentFatherId()), before, after)).isEmpty()) {
            UserRoleEvent userRoleEvent = UserRoleEvent.builderFor(ResourceEvent.Type.DELETION).role(before.getName()).instanceId(componentInst.getId()).userIds(removedUsers).build();
            this.notifier.notify(userRoleEvent);
        }
    }

    private Set<String> findRemovedUsersId(ComponentInst componentInst, ProfileInst before, ProfileInst after) {
        List<String> usersAfter = after.getAllUsers();
        List<String> groupsAfter = after.getAllGroups();
        String roleName = before.getName();
        NoAnymorePlayedRole roleNotAnymorePlayedByUser = new NoAnymorePlayedRole(roleName, componentInst.getId());
        Stream<String> removedUsers = before.getAllUsers().stream().filter(user -> !usersAfter.contains(user)).filter(roleNotAnymorePlayedByUser);
        Stream<String> removedUsersInGroups = before.getAllGroups().stream().filter(group -> !groupsAfter.contains(group)).map(g -> this.organization.getGroup((String)g)).flatMap(g -> Stream.of(((Group)g).getUserIds())).distinct().filter(roleNotAnymorePlayedByUser);
        return Stream.concat(removedUsers, removedUsersInGroups).collect(Collectors.toSet());
    }

    private ComponentInst getComponentInstanceId(int localComponentId) {
        return this.organization.getComponentInst(String.valueOf(localComponentId));
    }

    private class NoAnymorePlayedRole
    implements Predicate<String> {
        private final Map<String, String[]> cache = new HashMap<String, String[]>();
        private final String instanceId;
        private final String roleName;

        public NoAnymorePlayedRole(String roleName, String componentInstanceId) {
            this.instanceId = componentInstanceId;
            this.roleName = roleName;
        }

        @Override
        public boolean test(String userId) {
            String[] roles = this.cache.computeIfAbsent(userId, u -> ProfileInstUpdateEventListener.this.organization.getUserProfiles((String)u, this.instanceId));
            return roles.length == 0 || Stream.of(roles).noneMatch(p -> p.equalsIgnoreCase(this.roleName));
        }
    }
}

