/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.documenttemplate;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.documenttemplate.DocumentTemplateRuntimeException;
import org.silverpeas.core.ui.UserI18NTranslationMap;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
class JsonDocumentTemplate
implements Serializable {
    private static final long serialVersionUID = 725822202636699367L;
    @XmlElement
    private String id;
    @XmlElement
    private UserI18NTranslationMap nameTranslations = new UserI18NTranslationMap();
    @XmlElement
    private UserI18NTranslationMap descriptionTranslations = new UserI18NTranslationMap();
    @XmlElement
    private int position = -1;
    @XmlElement
    private JsonDocumentTemplateRestrictions restrictions = new JsonDocumentTemplateRestrictions();
    @XmlElement
    private String creatorId;
    @XmlElement
    private String creationInstant;
    @XmlElement
    private String lastUpdaterId;
    @XmlElement
    private String lastUpdateInstant;

    JsonDocumentTemplate() {
    }

    JsonDocumentTemplate(JsonDocumentTemplate other) {
        this.id = other.id;
        this.nameTranslations = new UserI18NTranslationMap((Map)other.nameTranslations);
        this.descriptionTranslations = new UserI18NTranslationMap((Map)other.descriptionTranslations);
        this.position = other.position;
        this.restrictions = new JsonDocumentTemplateRestrictions(other.restrictions);
        this.creatorId = other.creatorId;
        this.creationInstant = other.creationInstant;
        this.lastUpdaterId = other.lastUpdaterId;
        this.lastUpdateInstant = other.lastUpdateInstant;
    }

    String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    UserI18NTranslationMap getNameTranslations() {
        return this.nameTranslations;
    }

    UserI18NTranslationMap getDescriptionTranslations() {
        return this.descriptionTranslations;
    }

    int getPosition() {
        return this.position;
    }

    void setPosition(int position) {
        this.position = position;
    }

    public JsonDocumentTemplateRestrictions getRestrictions() {
        return this.restrictions;
    }

    String getCreatorId() {
        return this.creatorId;
    }

    void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
        this.setLastUpdaterId(creatorId);
    }

    Instant getCreationInstant() {
        return this.creationInstant != null ? OffsetDateTime.parse(this.creationInstant).toInstant() : null;
    }

    void setCreationInstant(Instant creationInstant) {
        this.creationInstant = OffsetDateTime.ofInstant(creationInstant, ZoneId.systemDefault()).toString();
        this.setLastUpdateInstant(creationInstant);
    }

    String getLastUpdaterId() {
        return this.lastUpdaterId;
    }

    void setLastUpdaterId(String lastUpdaterId) {
        this.lastUpdaterId = lastUpdaterId;
    }

    Instant getLastUpdateInstant() {
        return this.lastUpdateInstant != null ? OffsetDateTime.parse(this.lastUpdateInstant).toInstant() : null;
    }

    void setLastUpdateInstant(Instant lastUpdateInstant) {
        this.lastUpdateInstant = OffsetDateTime.ofInstant(lastUpdateInstant, ZoneId.systemDefault()).toString();
    }

    public String toString() {
        JsonDocumentTemplateRestrictions savedRestrictions = this.restrictions;
        if (savedRestrictions.isEmpty()) {
            this.restrictions = null;
        }
        try {
            String string = JSONCodec.encode((Object)this);
            return string;
        }
        finally {
            if (savedRestrictions.isEmpty()) {
                this.restrictions = savedRestrictions;
            }
        }
    }

    static JsonDocumentTemplate decode(Path jsonPath) {
        try {
            return JsonDocumentTemplate.decode(Files.readString(jsonPath, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new DocumentTemplateRuntimeException(e);
        }
    }

    static JsonDocumentTemplate decode(String jsonContent) {
        String safeJson = StringUtil.defaultStringIfNotDefined((String)jsonContent, (String)"");
        return Optional.of(safeJson).filter(StringUtil::isDefined).stream().map(j -> (JsonDocumentTemplate)JSONCodec.decode((String)j, JsonDocumentTemplate.class)).findFirst().orElseGet(JsonDocumentTemplate::new);
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class JsonDocumentTemplateRestrictions
    implements Serializable {
        private static final long serialVersionUID = 136978536660882286L;
        @XmlElement
        private List<String> spaceIds;

        JsonDocumentTemplateRestrictions() {
        }

        JsonDocumentTemplateRestrictions(JsonDocumentTemplateRestrictions other) {
            this.spaceIds = other.spaceIds != null ? new ArrayList<String>(other.spaceIds) : null;
        }

        boolean isEmpty() {
            return this.spaceIds == null || this.spaceIds.isEmpty();
        }

        public List<String> getSpaceIds() {
            return this.spaceIds != null ? this.spaceIds : new ArrayList(0);
        }

        public void setSpaceIds(List<String> spaceIds) {
            this.spaceIds = CollectionUtil.isNotEmpty(spaceIds) ? spaceIds.stream().map(String::toUpperCase).collect(Collectors.toList()) : null;
        }
    }
}

