/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.model.States;
import org.silverpeas.core.workflow.engine.model.StateImpl;

@XmlRootElement(name="states")
@XmlAccessorType(value=XmlAccessType.NONE)
public class StatesImpl
implements States {
    private static final long serialVersionUID = -2580715672830095678L;
    @XmlElement(name="state", type=StateImpl.class)
    private List<State> stateList = new ArrayList<State>();

    @Override
    public void addState(State state) {
        this.stateList.add(state);
    }

    @Override
    public State createState() {
        return new StateImpl();
    }

    @Override
    public State getState(String name) {
        for (State state : this.stateList) {
            if (state == null || !state.getName().equals(name)) continue;
            return state;
        }
        return null;
    }

    @Override
    public State[] getStates() {
        if (this.stateList == null) {
            return new State[0];
        }
        return this.stateList.toArray(new State[0]);
    }

    @Override
    public Iterator<State> iterateState() {
        return this.stateList.iterator();
    }

    @Override
    public void removeState(String strStateName) throws WorkflowException {
        if (this.stateList == null) {
            return;
        }
        State state = this.createState();
        state.setName(strStateName);
        if (!this.stateList.remove(state)) {
            throw new WorkflowException("StatesImpl.removeState()", "workflowEngine.EX_STATE_NOT_FOUND", strStateName == null ? "<null>" : strStateName);
        }
    }
}

