/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.calendar.outlook;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.Dispatch;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class SilverOutlookItemsList {
    private ActiveXComponent activexOutlook;
    private Dispatch oOutlook;
    private Dispatch namespace;
    private Dispatch folder;
    private Dispatch itemsList;

    protected abstract int getOlFolder();

    protected abstract String getOlItem();

    public Dispatch getFolder() {
        return this.folder;
    }

    public void setFolder(Dispatch folder) {
        this.folder = folder;
    }

    public Dispatch getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Dispatch namespace) {
        this.namespace = namespace;
    }

    public ActiveXComponent getActivexOutlook() {
        return this.activexOutlook;
    }

    public void setActivexOutlook(ActiveXComponent ax) {
        this.activexOutlook = ax;
    }

    public Dispatch getOOutlook() {
        return this.oOutlook;
    }

    public void setOOutlook(Dispatch olo) {
        this.oOutlook = olo;
    }

    public void initWithCurrentOutlook() {
        this.setActivexOutlook(new ActiveXComponent("Outlook.Application"));
        this.setOOutlook(this.getActivexOutlook().getObject());
        this.setNamespace(Dispatch.call((Dispatch)this.getOOutlook(), (String)"GetNamespace", (Object[])new Object[]{"MAPI"}).toDispatch());
        this.setFolder(Dispatch.call((Dispatch)this.getNamespace(), (String)"GetDefaultFolder", (Object[])new Object[]{new Integer(this.getOlFolder())}).toDispatch());
    }

    public void loadItemsList(int nbDaysBefore) {
        Dispatch allItems = Dispatch.get((Dispatch)this.getFolder(), (String)"Items").toDispatch();
        String filter = this.createFilter(nbDaysBefore);
        this.setItemsList(Dispatch.call((Dispatch)allItems, (String)"Restrict", (Object[])new Object[]{filter}).toDispatch());
    }

    private String createFilter(int nbDays) {
        Date today = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(today);
        cal.add(6, -nbDays);
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy 00:00 a");
        return "[Start] >= '" + format.format(cal.getTime()) + "'";
    }

    protected Dispatch createNewItem() {
        return Dispatch.invoke((Dispatch)this.getOOutlook(), (String)"CreateItem", (int)2, (Object[])new Object[]{this.getOlItem()}, (int[])new int[1]).toDispatch();
    }

    public Dispatch getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(Dispatch list) {
        this.itemsList = list;
    }

    public int getItemsListCount() {
        return Dispatch.call((Dispatch)this.getItemsList(), (String)"Count").getInt();
    }
}

