/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.rssaggregator.service;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.silverpeas.components.rssaggregator.model.SPChannel;
import org.silverpeas.components.rssaggregator.model.SPChannelPK;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Service
@Singleton
public class RssAggregatorCache {
    private final Map<SPChannelPK, SPChannel> cache = new ConcurrentHashMap<SPChannelPK, SPChannel>();
    private final Map<SPChannelPK, Long> cacheNextRefresh = new ConcurrentHashMap<SPChannelPK, Long>();

    private RssAggregatorCache() {
    }

    public static RssAggregatorCache getInstance() {
        return (RssAggregatorCache)ServiceProvider.getService(RssAggregatorCache.class, (Annotation[])new Annotation[0]);
    }

    public SPChannel getChannelFromCache(SPChannelPK key) {
        return this.cache.get((Object)key);
    }

    public void addChannelToCache(SPChannel spChannel) {
        SPChannelPK key = new SPChannelPK(spChannel.getPK().getId(), spChannel.getPK());
        this.cache.put(key, spChannel);
        long currentTime = System.currentTimeMillis();
        int secondsInMinute = 60;
        int milliInSecond = 1000;
        int channelRefreshRate = spChannel.getRefreshRate() * 1000 * 60;
        this.cacheNextRefresh.put(key, currentTime + (long)channelRefreshRate);
    }

    public void removeChannelFromCache(SPChannelPK key) {
        this.cache.remove((Object)key);
        this.cacheNextRefresh.remove((Object)key);
    }

    public boolean isContentNeedToRefresh(SPChannelPK key) {
        if (this.cache.get((Object)key) == null) {
            return true;
        }
        long timeOfNextRefresh = this.cacheNextRefresh.get((Object)key);
        long currentTime = System.currentTimeMillis();
        return currentTime > timeOfNextRefresh;
    }
}

