/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.logging.sys;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.LoggerConfigurationManager;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.logging.SilverLoggerFactory;
import org.silverpeas.kernel.logging.sys.SysLogger;

@Technical
public class SysLoggerFactory
implements SilverLoggerFactory {
    private final Map<SilverLoggerKey, SilverLogger> loggers = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public SilverLogger getLogger(String namespace, LoggerConfigurationManager.LoggerConfiguration configuration) {
        return this.loggers.computeIfAbsent(new SilverLoggerKey(namespace), n -> {
            SysLogger logger = new SysLogger(namespace);
            if (!configuration.getNamespace().equals("silverpeas") || configuration.getLevel() != null) {
                logger.setLevel(configuration.getLevel());
            }
            return logger;
        });
    }

    private static class SilverLoggerKey {
        private final String namespace;

        private SilverLoggerKey(String namespace) {
            Objects.requireNonNull(namespace);
            this.namespace = namespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SilverLoggerKey)) {
                return false;
            }
            SilverLoggerKey loggerKey = (SilverLoggerKey)o;
            return Objects.equals(this.namespace, loggerKey.namespace);
        }

        public int hashCode() {
            return Objects.hash(this.namespace);
        }
    }
}

