/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel.logging.sys;

import java.text.MessageFormat;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.Level;
import org.silverpeas.kernel.logging.SilverLogger;

@Technical
public class SysLogger
implements SilverLogger {
    private static final Logger ROOT_LOGGER = Logger.getLogger("silverpeas");
    private final Logger logger;
    private SilverLogger parent;

    private static SilverLogger getLoggerByNamespace(String namespace) {
        return SilverLogger.getLogger(namespace);
    }

    protected SysLogger(String namespace) {
        this.logger = Logger.getLogger(namespace);
        if (this.logger.getParent() != null && !namespace.equals("silverpeas")) {
            this.parent = SysLogger.getLoggerByNamespace(this.logger.getParent().getName());
        }
    }

    @Override
    public String getNamespace() {
        return this.logger.getName();
    }

    @Override
    public Level getLevel() {
        java.util.logging.Level level = this.logger.getLevel();
        if (level == null && this.parent != null) {
            return this.parent.getLevel();
        }
        if (level == java.util.logging.Level.FINE || level == java.util.logging.Level.FINEST || level == java.util.logging.Level.FINER) {
            return Level.DEBUG;
        }
        if (level == java.util.logging.Level.WARNING) {
            return Level.WARNING;
        }
        if (level == java.util.logging.Level.SEVERE) {
            return Level.ERROR;
        }
        return Level.INFO;
    }

    @Override
    public void setLevel(Level level) {
        block2: {
            Handler[] silverpeasRootHandlers;
            block3: {
                Handler[] silverpeasRootHandlers2;
                this.logger.setLevel(this.fromLoggingLevel(level));
                if (this.getNamespace().equals("silverpeas")) break block2;
                if (level != null || this.logger.getHandlers().length <= 0) break block3;
                this.logger.setUseParentHandlers(true);
                for (Handler handler : silverpeasRootHandlers2 = ROOT_LOGGER.getHandlers()) {
                    this.logger.removeHandler(handler);
                }
                break block2;
            }
            if (level == null || this.logger.getHandlers().length != 0) break block2;
            this.logger.setUseParentHandlers(false);
            for (Handler handler : silverpeasRootHandlers = ROOT_LOGGER.getHandlers()) {
                this.logger.addHandler(handler);
            }
        }
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(this.fromLoggingLevel(level));
    }

    @Override
    public void log(Level level, String message, Object[] parameters, Throwable error) {
        String text = parameters != null && parameters.length > 0 ? MessageFormat.format(message, parameters) : message;
        this.logger.log(this.fromLoggingLevel(level), text, error);
    }

    @Override
    public void log(Level level, String message, Object ... parameters) {
        this.logger.log(this.fromLoggingLevel(level), message, parameters);
    }

    @Override
    public void debug(Supplier<String> messageSupplier) {
        this.logger.log(this.fromLoggingLevel(Level.DEBUG), messageSupplier);
    }

    private java.util.logging.Level fromLoggingLevel(Level level) {
        java.util.logging.Level sysLevel = null;
        if (level != null) {
            switch (level) {
                case INFO: {
                    sysLevel = java.util.logging.Level.INFO;
                    break;
                }
                case DEBUG: {
                    sysLevel = java.util.logging.Level.FINE;
                    break;
                }
                case WARNING: {
                    sysLevel = java.util.logging.Level.WARNING;
                    break;
                }
                case ERROR: {
                    sysLevel = java.util.logging.Level.SEVERE;
                }
            }
        }
        return sysLevel;
    }
}

