/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.kernel;

import java.lang.annotation.Annotation;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.silverpeas.kernel.BeanContainer;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.cache.service.ThreadCacheAccessor;
import org.silverpeas.kernel.exception.NotFoundException;
import org.silverpeas.kernel.util.Mutable;

public class ManagedBeanProvider {
    private static final ManagedBeanProvider instance = new ManagedBeanProvider();
    static final String CACHE_KEY_PREFIX = "ManagedBeanProvider:CacheKey:";
    private final ThreadCacheAccessor cacheAccessor = ThreadCacheAccessor.getInstance();
    private final BeanContainer currentContainer;
    private final SingletonDetector detector = new SingletonDetector();

    public static synchronized ManagedBeanProvider getInstance() {
        return instance;
    }

    private ManagedBeanProvider() {
        this.currentContainer = ServiceLoader.load(BeanContainer.class).findFirst().orElseThrow(() -> new SilverpeasRuntimeException("No IoC container detected! At least one bean container should be available!"));
    }

    @NonNull
    public <T> T getManagedBean(Class<T> type, Annotation ... qualifiers) {
        Mutable bean = Mutable.empty();
        Object cachedBean = this.cacheAccessor.getCache().computeIfAbsent(ManagedBeanProvider.cacheKey(type, qualifiers), type, () -> {
            Object foundBean = this.beanContainer().getBeanByType(type, qualifiers).orElseThrow(() -> {
                String q = qualifiers.length > 0 ? " and qualifiers " + Stream.of(qualifiers).map(a -> a.getClass().getName()).collect(Collectors.joining(", ")) : "";
                return new NotFoundException("No such bean satisfying type " + type.getName() + q);
            });
            bean.set(foundBean);
            return this.isSingleton(foundBean) ? foundBean : null;
        });
        return (T)(cachedBean == null ? bean.get() : cachedBean);
    }

    @NonNull
    public <T> T getManagedBean(String name) {
        Mutable bean = Mutable.empty();
        Object cachedBean = this.cacheAccessor.getCache().computeIfAbsent(CACHE_KEY_PREFIX + name, Object.class, () -> {
            Object foundBean = this.beanContainer().getBeanByName(name).map(b -> b).orElseThrow(() -> new NotFoundException("No such bean named " + name));
            bean.set(foundBean);
            return this.isSingleton(foundBean) ? foundBean : null;
        });
        return (T)(cachedBean == null ? bean.get() : cachedBean);
    }

    public <T> Set<T> getAllManagedBeans(Class<T> type, Annotation ... qualifiers) {
        return this.beanContainer().getAllBeansByType(type, qualifiers);
    }

    protected BeanContainer beanContainer() {
        return this.currentContainer;
    }

    private static <T> String cacheKey(Class<T> type, Annotation[] qualifiers) {
        StringBuilder cacheKey = new StringBuilder(CACHE_KEY_PREFIX + type.getName());
        for (Annotation qualifier : qualifiers) {
            cacheKey.append(":").append(qualifier.annotationType().getName());
        }
        return cacheKey.toString();
    }

    private boolean isSingleton(Object bean) {
        return this.detector.test(bean.getClass());
    }

    private static class SingletonDetector
    implements Predicate<Class<?>> {
        private SingletonDetector() {
        }

        @Override
        public boolean test(Class<?> aClass) {
            if (aClass.isAnnotationPresent(Singleton.class)) {
                return true;
            }
            return this.isOneAnnotatedSingleton(aClass.getAnnotations());
        }

        private boolean isSingletonAnnotated(Class<? extends Annotation> annotationType) {
            if (annotationType.isAnnotationPresent(Singleton.class)) {
                return true;
            }
            if (!annotationType.getName().startsWith("org.silverpeas")) {
                return false;
            }
            return this.isOneAnnotatedSingleton(annotationType.getAnnotations());
        }

        private boolean isOneAnnotatedSingleton(Annotation[] annotations) {
            for (Annotation annotation : annotations) {
                if (!this.isSingletonAnnotated(annotation.annotationType())) continue;
                return true;
            }
            return false;
        }
    }
}

