/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNotPrimaryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcernException;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoStatus;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MongoUtils {
    MongoUtils() {
    }

    static void createIndex(MongoCollection<?> collection, String field, boolean ascending, boolean unique, boolean sparse) throws MongoException {
        MongoUtils.createIndex(collection, new String[]{field}, new boolean[]{ascending}, unique, sparse);
    }

    static void createIndex(MongoCollection<?> collection, String[] fields, boolean[] ascending, boolean unique, boolean sparse) throws MongoException {
        Validate.checkArgument((fields.length == ascending.length ? 1 : 0) != 0);
        BasicDBObject index = new BasicDBObject();
        for (int i = 0; i < fields.length; ++i) {
            index.put((Object)fields[i], (Object)(ascending[i] ? 1 : -1));
        }
        IndexOptions options = new IndexOptions().unique(unique).sparse(sparse);
        collection.createIndex((Bson)index, options);
    }

    static void createPartialIndex(MongoCollection<?> collection, String[] fields, boolean[] ascending, String filter) throws MongoException {
        Validate.checkArgument((fields.length == ascending.length ? 1 : 0) != 0);
        BasicDBObject index = new BasicDBObject();
        for (int i = 0; i < fields.length; ++i) {
            index.put((Object)fields[i], (Object)(ascending[i] ? 1 : -1));
        }
        IndexOptions options = new IndexOptions().partialFilterExpression((Bson)BasicDBObject.parse((String)filter));
        collection.createIndex((Bson)index, options);
    }

    static boolean hasIndex(MongoCollection<?> collection, String ... fields) throws MongoException {
        Set uniqueFields = SetUtils.toSet((Object[])fields);
        for (Document info : collection.listIndexes()) {
            Document key = (Document)info.get((Object)"key");
            HashSet indexFields = new HashSet(key.keySet());
            if (!uniqueFields.equals(indexFields)) continue;
            return true;
        }
        return false;
    }

    static boolean isCollectionEmpty(@NotNull MongoCollection<?> collection, @Nullable ClientSession session) {
        MongoCollection c = collection.withReadPreference(ReadPreference.primary());
        FindIterable result = session != null ? c.find(session, BasicDBObject.class) : c.find(BasicDBObject.class);
        return result.limit(1).first() == null;
    }

    static DocumentStoreException.Type getDocumentStoreExceptionTypeFor(Throwable t) {
        int code;
        DocumentStoreException.Type type = DocumentStoreException.Type.GENERIC;
        if (t instanceof MongoSocketException || t instanceof MongoWriteConcernException || t instanceof MongoNotPrimaryException) {
            type = DocumentStoreException.Type.TRANSIENT;
        } else if ((t instanceof MongoCommandException || t instanceof WriteConcernException || t instanceof MongoWriteConcernWithResponseException) && ((code = ((MongoException)t).getCode()) == 11600 || code == 11601 || code == 11602)) {
            type = DocumentStoreException.Type.TRANSIENT;
        }
        return type;
    }

    static int getNodeNameLimit(@NotNull MongoStatus status) {
        return status.isVersion(4, 2) ? Integer.MAX_VALUE : Utils.NODE_NAME_LIMIT;
    }

    static BasicDBObject explain(@NotNull MongoDatabase mongoDb, @NotNull MongoCollection<BasicDBObject> collection, @NotNull Bson query, @Nullable Bson hint) {
        BasicDBObject explainCommand = new BasicDBObject("explain", (Object)new BasicDBObject("find", (Object)collection.getNamespace().getCollectionName()).append("filter", (Object)query).append("hint", hint == null ? new BasicDBObject() : hint));
        return new BasicDBObject((Map)mongoDb.runCommand((Bson)explainCommand, BasicDBObject.class));
    }

    static BasicDBObject getWinningPlan(BasicDBObject explainResult) {
        try {
            BasicDBObject queryPlanner = (BasicDBObject)explainResult.get("queryPlanner");
            return (BasicDBObject)queryPlanner.get("winningPlan");
        }
        catch (Exception e) {
            return null;
        }
    }
}

