/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.ArrayList;
import java.util.Collections;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.LongUtils;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.json.TypeCodes;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.StringCache;
import org.apache.jackrabbit.oak.plugins.memory.AbstractPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.jetbrains.annotations.NotNull;

final class DocumentPropertyState
implements PropertyState {
    private final DocumentNodeStore store;
    private final String name;
    private final String value;
    private PropertyState parsed;

    DocumentPropertyState(DocumentNodeStore store, String name, String value) {
        this.store = store;
        this.name = name;
        this.value = value;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isArray() {
        return this.parsed().isArray();
    }

    public Type<?> getType() {
        return this.parsed().getType();
    }

    @NotNull
    public <T> T getValue(Type<T> type) {
        return (T)this.parsed().getValue(type);
    }

    @NotNull
    public <T> T getValue(Type<T> type, int index) {
        return (T)this.parsed().getValue(type, index);
    }

    public long size() {
        return this.parsed().size();
    }

    public long size(int index) {
        PropertyState parsed = this.parsed();
        long size = parsed.getType() == Type.BINARIES ? ((Blob)parsed.getValue(Type.BINARY, index)).length() : parsed.size(index);
        return size;
    }

    public int count() {
        return this.parsed().count();
    }

    @NotNull
    String getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DocumentPropertyState) {
            DocumentPropertyState other = (DocumentPropertyState)object;
            return this.name.equals(other.name) && this.value.equals(other.value);
        }
        return object instanceof PropertyState && AbstractPropertyState.equal((PropertyState)this.parsed(), (PropertyState)((PropertyState)object));
    }

    public int hashCode() {
        return AbstractPropertyState.hashCode((PropertyState)this);
    }

    public String toString() {
        return AbstractPropertyState.toString((PropertyState)this);
    }

    private PropertyState parsed() {
        if (this.parsed == null) {
            JsopTokenizer reader = new JsopTokenizer(this.value);
            this.parsed = reader.matches(91) ? this.readArrayProperty(this.name, (JsopReader)reader) : this.readProperty(this.name, (JsopReader)reader);
        }
        return this.parsed;
    }

    PropertyState readProperty(String name, JsopReader reader) {
        return DocumentPropertyState.readProperty(name, this.store, reader);
    }

    static PropertyState readProperty(String name, DocumentNodeStore store, JsopReader reader) {
        if (reader.matches(2)) {
            String number = reader.getToken();
            Long maybeLong = LongUtils.tryParse((String)number);
            if (maybeLong == null) {
                return new DoublePropertyState(name, Double.parseDouble(number));
            }
            return new LongPropertyState(name, maybeLong.longValue());
        }
        if (reader.matches(3)) {
            return BooleanPropertyState.booleanProperty((String)name, (boolean)true);
        }
        if (reader.matches(4)) {
            return BooleanPropertyState.booleanProperty((String)name, (boolean)false);
        }
        if (reader.matches(1)) {
            String jsonString = reader.getToken();
            if (jsonString.startsWith("[0]:")) {
                int type = PropertyType.valueFromName((String)jsonString.substring("[0]:".length()));
                return PropertyStates.createProperty((String)name, Collections.emptyList(), (Type)Type.fromTag((int)type, (boolean)true));
            }
            int split = TypeCodes.split((String)jsonString);
            if (split != -1) {
                int type = TypeCodes.decodeType((int)split, (String)jsonString);
                String value = TypeCodes.decodeName((int)split, (String)jsonString);
                if (type == 2) {
                    return BinaryPropertyState.binaryProperty((String)name, (Blob)store.getBlobFromBlobId(value));
                }
                return PropertyStates.createProperty((String)name, (String)StringCache.get(value), (int)type);
            }
            return StringPropertyState.stringProperty((String)name, (String)StringCache.get(jsonString));
        }
        throw new IllegalArgumentException("Unexpected token: " + reader.getToken());
    }

    PropertyState readArrayProperty(String name, JsopReader reader) {
        return DocumentPropertyState.readArrayProperty(name, this.store, reader);
    }

    static PropertyState readArrayProperty(String name, DocumentNodeStore store, JsopReader reader) {
        int type = 1;
        ArrayList<Object> values = new ArrayList<Object>();
        while (!reader.matches(93)) {
            if (reader.matches(2)) {
                String number = reader.getToken();
                Long maybeLong = LongUtils.tryParse((String)number);
                if (maybeLong == null) {
                    type = 4;
                    values.add(Double.parseDouble(number));
                } else {
                    type = 3;
                    values.add(maybeLong);
                }
            } else if (reader.matches(3)) {
                type = 6;
                values.add(true);
            } else if (reader.matches(4)) {
                type = 6;
                values.add(false);
            } else if (reader.matches(1)) {
                String jsonString = reader.getToken();
                int split = TypeCodes.split((String)jsonString);
                if (split != -1) {
                    type = TypeCodes.decodeType((int)split, (String)jsonString);
                    String value = TypeCodes.decodeName((int)split, (String)jsonString);
                    if (type == 2) {
                        values.add(store.getBlobFromBlobId(value));
                    } else if (type == 4) {
                        values.add(Conversions.convert((String)value).toDouble());
                    } else if (type == 12) {
                        values.add(Conversions.convert((String)value).toDecimal());
                    } else {
                        values.add(StringCache.get(value));
                    }
                } else {
                    type = 1;
                    values.add(StringCache.get(jsonString));
                }
            } else {
                throw new IllegalArgumentException("Unexpected token: " + reader.getToken());
            }
            reader.matches(44);
        }
        return PropertyStates.createProperty((String)name, values, (Type)Type.fromTag((int)type, (boolean)true));
    }
}

