/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.server.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import edu.psu.swe.scim.server.exception.AttributeDoesNotExistException;
import edu.psu.swe.scim.server.exception.ScimServerException;
import edu.psu.swe.scim.server.exception.UnableToCreateResourceException;
import edu.psu.swe.scim.server.exception.UnableToDeleteResourceException;
import edu.psu.swe.scim.server.exception.UnableToRetrieveResourceException;
import edu.psu.swe.scim.server.exception.UnableToUpdateResourceException;
import edu.psu.swe.scim.server.provider.Provider;
import edu.psu.swe.scim.server.provider.UpdateRequest;
import edu.psu.swe.scim.server.provider.annotations.ScimProcessingExtension;
import edu.psu.swe.scim.server.provider.extensions.AttributeFilterExtension;
import edu.psu.swe.scim.server.provider.extensions.ProcessingExtension;
import edu.psu.swe.scim.server.provider.extensions.ScimRequestContext;
import edu.psu.swe.scim.server.provider.extensions.exceptions.ClientFilterException;
import edu.psu.swe.scim.server.utility.AttributeUtil;
import edu.psu.swe.scim.server.utility.EndpointUtil;
import edu.psu.swe.scim.server.utility.EtagGenerator;
import edu.psu.swe.scim.spec.adapter.FilterWrapper;
import edu.psu.swe.scim.spec.protocol.BaseResourceTypeResource;
import edu.psu.swe.scim.spec.protocol.ErrorMessageType;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReferenceListWrapper;
import edu.psu.swe.scim.spec.protocol.data.ErrorResponse;
import edu.psu.swe.scim.spec.protocol.data.ListResponse;
import edu.psu.swe.scim.spec.protocol.data.PatchRequest;
import edu.psu.swe.scim.spec.protocol.data.SearchRequest;
import edu.psu.swe.scim.spec.protocol.filter.FilterResponse;
import edu.psu.swe.scim.spec.protocol.search.Filter;
import edu.psu.swe.scim.spec.protocol.search.PageRequest;
import edu.psu.swe.scim.spec.protocol.search.SortOrder;
import edu.psu.swe.scim.spec.protocol.search.SortRequest;
import edu.psu.swe.scim.spec.resources.ScimResource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceTypeResourceImpl<T extends ScimResource>
implements BaseResourceTypeResource<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseResourceTypeResourceImpl.class);
    private static final Logger LOG = LoggerFactory.getLogger(BaseResourceTypeResourceImpl.class);
    @Context
    UriInfo uriInfo;
    @Context
    Request request;
    @Context
    HttpServletRequest servletRequest;
    @Inject
    private AttributeUtil attributeUtil;
    @Inject
    private EndpointUtil endpointUtil;
    @Inject
    private EtagGenerator etagGenerator;
    @Inject
    private Instance<UpdateRequest<T>> updateRequestInstance;

    public abstract Provider<T> getProvider();

    Provider<T> getProviderInternal() throws ScimServerException {
        Provider<T> provider = this.getProvider();
        if (provider == null) {
            throw new ScimServerException(Response.Status.INTERNAL_SERVER_ERROR, "Provider not defined");
        }
        return provider;
    }

    public Response getById(String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) {
        if (this.servletRequest.getParameter("filter") != null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            Provider<T> provider = this.getProviderInternal();
            this.endpointUtil.process(this.uriInfo);
            Object resource = null;
            try {
                resource = provider.get(id);
            }
            catch (UnableToRetrieveResourceException e2) {
                if (e2.getStatus().getFamily().equals((Object)Response.Status.Family.SERVER_ERROR)) {
                    return BaseResourceTypeResourceImpl.createGenericExceptionResponse(e2, e2.getStatus());
                }
            }
            catch (Exception e) {
                log.error("Uncaught provider exception", (Throwable)e);
                return provider.handleException(e);
            }
            if (resource != null) {
                EntityTag backingETag = null;
                try {
                    backingETag = this.etagGenerator.generateEtag((ScimResource)resource);
                }
                catch (JsonProcessingException | UnsupportedEncodingException | NoSuchAlgorithmException e1) {
                    return this.createETagErrorResponse();
                }
                Response.ResponseBuilder evaluatePreconditionsResponse = this.request.evaluatePreconditions(backingETag);
                if (evaluatePreconditionsResponse != null) {
                    return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
                }
            }
            Set<AttributeReference> attributeReferences = Optional.ofNullable(attributes).map(wrapper -> wrapper.getAttributeReferences()).orElse(Collections.emptySet());
            Set<AttributeReference> excludedAttributeReferences = Optional.ofNullable(excludedAttributes).map(wrapper -> wrapper.getAttributeReferences()).orElse(Collections.emptySet());
            if (!attributeReferences.isEmpty() && !excludedAttributeReferences.isEmpty()) {
                return this.createAmbiguousAttributeParametersResponse();
            }
            if (resource == null) {
                return this.createNotFoundResponse(id);
            }
            EntityTag etag = null;
            try {
                etag = this.etagGenerator.generateEtag((ScimResource)resource);
            }
            catch (JsonProcessingException | UnsupportedEncodingException | NoSuchAlgorithmException e) {
                return this.createETagErrorResponse();
            }
            try {
                resource = this.processFilterAttributeExtensions(provider, resource, attributeReferences, excludedAttributeReferences);
            }
            catch (ClientFilterException e1) {
                ErrorResponse er = new ErrorResponse(e1.getStatus(), e1.getMessage());
                return er.toResponse();
            }
            try {
                resource = !excludedAttributeReferences.isEmpty() ? this.attributeUtil.setExcludedAttributesForDisplay(resource, excludedAttributeReferences) : this.attributeUtil.setAttributesForDisplay(resource, attributeReferences);
                return Response.ok().entity(resource).location(this.buildLocationTag(resource)).tag(etag).build();
            }
            catch (AttributeDoesNotExistException | IOException | IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return this.createAttriubteProcessingErrorResponse(e);
            }
        }
        catch (ScimServerException sse) {
            LOG.error("Error Processing SCIM Request", (Throwable)sse);
            return sse.getErrorResponse().toResponse();
        }
    }

    public Response query(AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes, FilterWrapper filter, AttributeReference sortBy, SortOrder sortOrder, Integer startIndex, Integer count) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setAttributes(Optional.ofNullable(attributes).map(wrapper -> wrapper.getAttributeReferences()).orElse(Collections.emptySet()));
        searchRequest.setExcludedAttributes(Optional.ofNullable(excludedAttributes).map(wrapper -> wrapper.getAttributeReferences()).orElse(Collections.emptySet()));
        if (filter != null) {
            searchRequest.setFilter(filter.getFilter());
        } else {
            searchRequest.setFilter(null);
        }
        searchRequest.setSortBy(sortBy);
        searchRequest.setSortOrder(sortOrder);
        searchRequest.setStartIndex(startIndex);
        searchRequest.setCount(count);
        return this.find(searchRequest);
    }

    public Response create(T resource, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) {
        try {
            T created;
            Provider<T> provider = this.getProviderInternal();
            Set<AttributeReference> attributeReferences = Optional.ofNullable(attributes).map(wrapper -> wrapper.getAttributeReferences()).orElse(Collections.emptySet());
            Set<AttributeReference> excludedAttributeReferences = Optional.ofNullable(excludedAttributes).map(wrapper -> wrapper.getAttributeReferences()).orElse(Collections.emptySet());
            if (!attributeReferences.isEmpty() && !excludedAttributeReferences.isEmpty()) {
                return this.createAmbiguousAttributeParametersResponse();
            }
            this.endpointUtil.process(this.uriInfo);
            try {
                created = provider.create(resource);
            }
            catch (UnableToCreateResourceException e1) {
                Response.Status status = e1.getStatus();
                ErrorResponse er = new ErrorResponse(status, "Error");
                if (status == Response.Status.CONFLICT) {
                    er.setScimType(ErrorMessageType.UNIQUENESS);
                    if (e1.getMessage() == null) {
                        er.setDetail(ErrorMessageType.UNIQUENESS.getDetail());
                    } else {
                        er.setDetail(e1.getMessage());
                    }
                } else {
                    er.setDetail(e1.getMessage());
                }
                return er.toResponse();
            }
            catch (Exception e) {
                log.error("Uncaught provider exception", (Throwable)e);
                return provider.handleException(e);
            }
            EntityTag etag = null;
            try {
                etag = this.etagGenerator.generateEtag((ScimResource)created);
            }
            catch (JsonProcessingException | UnsupportedEncodingException | NoSuchAlgorithmException e) {
                log.error("Failed to generate etag for newly created entity " + e.getMessage());
            }
            try {
                created = this.processFilterAttributeExtensions(provider, created, attributeReferences, excludedAttributeReferences);
            }
            catch (ClientFilterException e1) {
                ErrorResponse er = new ErrorResponse(e1.getStatus(), e1.getMessage());
                return er.toResponse();
            }
            try {
                created = !excludedAttributeReferences.isEmpty() ? this.attributeUtil.setExcludedAttributesForDisplay(created, excludedAttributeReferences) : this.attributeUtil.setAttributesForDisplay(created, attributeReferences);
            }
            catch (AttributeDoesNotExistException | IOException | IllegalAccessException | IllegalArgumentException e) {
                if (etag == null) {
                    return Response.status((Response.Status)Response.Status.CREATED).location(this.buildLocationTag(created)).build();
                }
                Response.status((Response.Status)Response.Status.CREATED).location(this.buildLocationTag(created)).tag(etag).build();
            }
            if (etag == null) {
                return Response.status((Response.Status)Response.Status.CREATED).location(this.buildLocationTag(created)).entity(created).build();
            }
            return Response.status((Response.Status)Response.Status.CREATED).location(this.buildLocationTag(created)).tag(etag).entity(created).build();
        }
        catch (ScimServerException sse) {
            LOG.error("Error Processing SCIM Request", (Throwable)sse);
            return sse.getErrorResponse().toResponse();
        }
    }

    public Response find(SearchRequest request) {
        try {
            Provider<T> provider = this.getProviderInternal();
            Set<AttributeReference> attributeReferences = Optional.ofNullable(request.getAttributes()).orElse(Collections.emptySet());
            Set<AttributeReference> excludedAttributeReferences = Optional.ofNullable(request.getExcludedAttributes()).orElse(Collections.emptySet());
            if (!attributeReferences.isEmpty() && !excludedAttributeReferences.isEmpty()) {
                return this.createAmbiguousAttributeParametersResponse();
            }
            Filter filter = request.getFilter();
            PageRequest pageRequest = request.getPageRequest();
            SortRequest sortRequest = request.getSortRequest();
            ListResponse listResponse = new ListResponse();
            this.endpointUtil.process(this.uriInfo);
            FilterResponse<T> filterResp = null;
            try {
                filterResp = provider.find(filter, pageRequest, sortRequest);
            }
            catch (UnableToRetrieveResourceException e1) {
                log.info("Caught an UnableToRetrieveResourceException " + e1.getMessage() + " : " + e1.getStatus().toString());
                return BaseResourceTypeResourceImpl.createGenericExceptionResponse(e1, e1.getStatus());
            }
            catch (Exception e) {
                log.error("Uncaught provider exception", (Throwable)e);
                return provider.handleException(e);
            }
            if (filterResp == null || filterResp.getResources() == null || filterResp.getResources().isEmpty()) {
                listResponse.setTotalResults(0);
            } else {
                log.info("Find returned " + filterResp.getResources().size());
                listResponse.setItemsPerPage(Integer.valueOf(filterResp.getResources().size()));
                listResponse.setStartIndex(Integer.valueOf(1));
                listResponse.setTotalResults(filterResp.getResources().size());
                ArrayList<ScimResource> results = new ArrayList<ScimResource>();
                for (ScimResource resource : filterResp.getResources()) {
                    EntityTag etag = null;
                    try {
                        etag = this.etagGenerator.generateEtag(resource);
                    }
                    catch (JsonProcessingException | UnsupportedEncodingException | NoSuchAlgorithmException e) {
                        return this.createETagErrorResponse();
                    }
                    try {
                        log.info("=== Calling processFilterAttributeExtensions");
                        resource = this.processFilterAttributeExtensions(provider, resource, attributeReferences, excludedAttributeReferences);
                    }
                    catch (ClientFilterException e1) {
                        ErrorResponse er = new ErrorResponse(e1.getStatus(), e1.getMessage());
                        return er.toResponse();
                    }
                    try {
                        resource = !excludedAttributeReferences.isEmpty() ? this.attributeUtil.setExcludedAttributesForDisplay(resource, excludedAttributeReferences) : this.attributeUtil.setAttributesForDisplay(resource, attributeReferences);
                        results.add(resource);
                    }
                    catch (AttributeDoesNotExistException | IOException | IllegalAccessException | IllegalArgumentException e) {
                        return this.createAttriubteProcessingErrorResponse(e);
                    }
                }
                listResponse.setResources(results);
            }
            return Response.ok().entity((Object)listResponse).build();
        }
        catch (ScimServerException sse) {
            LOG.error("Error Processing SCIM Request", (Throwable)sse);
            return sse.getErrorResponse().toResponse();
        }
    }

    public Response update(T resource, String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) {
        try {
            T updated;
            T stored;
            Provider<T> provider = this.getProviderInternal();
            Set<AttributeReference> attributeReferences = Optional.ofNullable(attributes).map(wrapper -> wrapper.getAttributeReferences()).orElse(Collections.emptySet());
            Set<AttributeReference> excludedAttributeReferences = Optional.ofNullable(excludedAttributes).map(wrapper -> wrapper.getAttributeReferences()).orElse(Collections.emptySet());
            if (!attributeReferences.isEmpty() && !excludedAttributeReferences.isEmpty()) {
                return this.createAmbiguousAttributeParametersResponse();
            }
            this.endpointUtil.process(this.uriInfo);
            try {
                stored = provider.get(id);
            }
            catch (UnableToRetrieveResourceException e2) {
                log.error("Unable to retrieve resource with id: {}", (Object)id, (Object)e2);
                return BaseResourceTypeResourceImpl.createGenericExceptionResponse(e2, e2.getStatus());
            }
            catch (Exception e) {
                log.error("Uncaught provider exception", (Throwable)e);
                return provider.handleException(e);
            }
            if (stored == null) {
                return this.createNotFoundResponse(id);
            }
            EntityTag backingETag = null;
            try {
                backingETag = this.etagGenerator.generateEtag((ScimResource)stored);
            }
            catch (JsonProcessingException | UnsupportedEncodingException | NoSuchAlgorithmException e1) {
                return this.createETagErrorResponse();
            }
            Response.ResponseBuilder evaluatePreconditionsResponse = this.request.evaluatePreconditions(backingETag);
            if (evaluatePreconditionsResponse != null) {
                return this.createPreconditionFailedResponse(id, evaluatePreconditionsResponse);
            }
            try {
                UpdateRequest updateRequest = (UpdateRequest)this.updateRequestInstance.get();
                updateRequest.initWithResource(id, stored, resource);
                updated = provider.update(updateRequest);
            }
            catch (UnableToUpdateResourceException e1) {
                return BaseResourceTypeResourceImpl.createGenericExceptionResponse(e1, e1.getStatus());
            }
            catch (Exception e1) {
                log.error("Uncaught provider exception", (Throwable)e1);
                return provider.handleException(e1);
            }
            try {
                updated = this.processFilterAttributeExtensions(provider, updated, attributeReferences, excludedAttributeReferences);
            }
            catch (ClientFilterException e1) {
                ErrorResponse er = new ErrorResponse(e1.getStatus(), e1.getMessage());
                return er.toResponse();
            }
            try {
                updated = !excludedAttributeReferences.isEmpty() ? this.attributeUtil.setExcludedAttributesForDisplay(updated, excludedAttributeReferences) : this.attributeUtil.setAttributesForDisplay(updated, attributeReferences);
            }
            catch (AttributeDoesNotExistException | IOException | IllegalAccessException | IllegalArgumentException e) {
                log.error("Failed to handle attribute processing in update " + e.getMessage());
            }
            EntityTag etag = null;
            try {
                etag = this.etagGenerator.generateEtag((ScimResource)updated);
            }
            catch (JsonProcessingException | UnsupportedEncodingException | NoSuchAlgorithmException e) {
                log.error("Failed to generate etag for newly created entity " + e.getMessage());
            }
            if (etag == null) {
                return Response.ok(updated).location(this.buildLocationTag(updated)).build();
            }
            return Response.ok(updated).location(this.buildLocationTag(updated)).tag(etag).build();
        }
        catch (ScimServerException sse) {
            LOG.error("Error Processing SCIM Request", (Throwable)sse);
            return sse.getErrorResponse().toResponse();
        }
    }

    public Response patch(PatchRequest patchRequest, String id, AttributeReferenceListWrapper attributes, AttributeReferenceListWrapper excludedAttributes) {
        try {
            T updated;
            T stored;
            Provider<T> provider = this.getProviderInternal();
            Set<AttributeReference> attributeReferences = Optional.ofNullable(attributes).map(wrapper -> wrapper.getAttributeReferences()).orElse(Collections.emptySet());
            Set<AttributeReference> excludedAttributeReferences = Optional.ofNullable(excludedAttributes).map(wrapper -> wrapper.getAttributeReferences()).orElse(Collections.emptySet());
            if (!attributeReferences.isEmpty() && !excludedAttributeReferences.isEmpty()) {
                return this.createAmbiguousAttributeParametersResponse();
            }
            this.endpointUtil.process(this.uriInfo);
            try {
                stored = provider.get(id);
            }
            catch (UnableToRetrieveResourceException e2) {
                log.error("Unable to retrieve resource with id: {}", (Object)id, (Object)e2);
                return BaseResourceTypeResourceImpl.createGenericExceptionResponse(e2, e2.getStatus());
            }
            catch (Exception e) {
                log.error("Uncaught provider exception", (Throwable)e);
                return provider.handleException(e);
            }
            if (stored == null) {
                return this.createNotFoundResponse(id);
            }
            EntityTag backingETag = null;
            try {
                backingETag = this.etagGenerator.generateEtag((ScimResource)stored);
            }
            catch (JsonProcessingException | UnsupportedEncodingException | NoSuchAlgorithmException e1) {
                return this.createETagErrorResponse();
            }
            Response.ResponseBuilder evaluatePreconditionsResponse = this.request.evaluatePreconditions(backingETag);
            if (evaluatePreconditionsResponse != null) {
                return this.createPreconditionFailedResponse(id, evaluatePreconditionsResponse);
            }
            try {
                UpdateRequest updateRequest = (UpdateRequest)this.updateRequestInstance.get();
                updateRequest.initWithPatch(id, stored, patchRequest.getPatchOperationList());
                updated = provider.update(updateRequest);
            }
            catch (UnableToUpdateResourceException e1) {
                return BaseResourceTypeResourceImpl.createGenericExceptionResponse(e1, e1.getStatus());
            }
            catch (UnsupportedOperationException e2) {
                return BaseResourceTypeResourceImpl.createGenericExceptionResponse(e2, Response.Status.NOT_IMPLEMENTED);
            }
            catch (Exception e1) {
                log.error("Uncaught provider exception", (Throwable)e1);
                return provider.handleException(e1);
            }
            try {
                updated = this.processFilterAttributeExtensions(provider, updated, attributeReferences, excludedAttributeReferences);
            }
            catch (ClientFilterException e1) {
                ErrorResponse er = new ErrorResponse(e1.getStatus(), e1.getMessage());
                return er.toResponse();
            }
            try {
                updated = !excludedAttributeReferences.isEmpty() ? this.attributeUtil.setExcludedAttributesForDisplay(updated, excludedAttributeReferences) : this.attributeUtil.setAttributesForDisplay(updated, attributeReferences);
            }
            catch (AttributeDoesNotExistException | IOException | IllegalAccessException | IllegalArgumentException e) {
                log.error("Failed to handle attribute processing in update " + e.getMessage());
            }
            EntityTag etag = null;
            try {
                etag = this.etagGenerator.generateEtag((ScimResource)updated);
            }
            catch (JsonProcessingException | UnsupportedEncodingException | NoSuchAlgorithmException e) {
                log.error("Failed to generate etag for newly created entity " + e.getMessage());
            }
            if (etag == null) {
                return Response.ok(updated).location(this.buildLocationTag(updated)).build();
            }
            return Response.ok(updated).location(this.buildLocationTag(updated)).tag(etag).build();
        }
        catch (ScimServerException sse) {
            LOG.error("Error Processing SCIM Request", (Throwable)sse);
            return sse.getErrorResponse().toResponse();
        }
    }

    public Response delete(String id) {
        try {
            Provider<T> provider = this.getProviderInternal();
            try {
                this.endpointUtil.process(this.uriInfo);
                Response response = Response.noContent().build();
                provider.delete(id);
                return response;
            }
            catch (UnableToDeleteResourceException e) {
                Response.Status status = e.getStatus();
                Response response = Response.status((Response.Status)status).build();
                log.error("Unable to delete resource", (Throwable)e);
                return response;
            }
            catch (Exception e) {
                log.error("Uncaught provider exception", (Throwable)e);
                return provider.handleException(e);
            }
        }
        catch (ScimServerException sse) {
            LOG.error("Error Processing SCIM Request", (Throwable)sse);
            return sse.getErrorResponse().toResponse();
        }
    }

    private T processFilterAttributeExtensions(Provider<T> provider, T resource, Set<AttributeReference> attributeReferences, Set<AttributeReference> excludedAttributeReferences) throws ClientFilterException {
        ScimProcessingExtension annotation = provider.getClass().getAnnotation(ScimProcessingExtension.class);
        if (annotation != null) {
            Class<? extends ProcessingExtension>[] value;
            for (Class<? extends ProcessingExtension> class1 : value = annotation.value()) {
                ProcessingExtension processingExtension = (ProcessingExtension)CDI.current().select(class1, new Annotation[0]).get();
                if (!(processingExtension instanceof AttributeFilterExtension)) continue;
                AttributeFilterExtension attributeFilterExtension = (AttributeFilterExtension)processingExtension;
                ScimRequestContext scimRequestContext = new ScimRequestContext(attributeReferences, excludedAttributeReferences);
                resource = attributeFilterExtension.filterAttributes((ScimResource)resource, scimRequestContext);
                log.info("Resource now - " + resource.toString());
            }
        }
        return resource;
    }

    private URI buildLocationTag(T resource) {
        String id = resource.getId();
        if (id == null) {
            LOG.warn("Provider must supply an id for a resource");
            id = "unknown";
        }
        return this.uriInfo.getAbsolutePathBuilder().path(id).build(new Object[0]);
    }

    public static Response createGenericExceptionResponse(Throwable e1, Response.Status status) {
        Response.Status myStatus = status;
        if (myStatus == null) {
            myStatus = Response.Status.INTERNAL_SERVER_ERROR;
        }
        ErrorResponse er = new ErrorResponse(myStatus, e1.getMessage());
        return er.toResponse();
    }

    private Response createAmbiguousAttributeParametersResponse() {
        ErrorResponse er = new ErrorResponse(Response.Status.BAD_REQUEST, "Cannot include both attributes and excluded attributes in a single request");
        return er.toResponse();
    }

    private Response createNotFoundResponse(String id) {
        ErrorResponse er = new ErrorResponse(Response.Status.NOT_FOUND, "Resource " + id + " not found");
        return er.toResponse();
    }

    private Response createETagErrorResponse() {
        ErrorResponse er = new ErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed to generate the etag");
        return er.toResponse();
    }

    private Response createAttriubteProcessingErrorResponse(Exception e) {
        ErrorResponse er = new ErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed to parse the attribute query value " + e.getMessage());
        return er.toResponse();
    }

    private Response createNoProviderException() {
        ErrorResponse er = new ErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Provider not defined");
        return er.toResponse();
    }

    private Response createPreconditionFailedResponse(String id, Response.ResponseBuilder evaluatePreconditionsResponse) {
        ErrorResponse er = new ErrorResponse(Response.Status.PRECONDITION_FAILED, "Failed to update record, backing record has changed - " + id);
        log.warn("Failed to update record, backing record has changed - " + id);
        return evaluatePreconditionsResponse.entity((Object)er).build();
    }
}

