/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.model;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.silverpeas.core.pdc.pdc.model.ValuePK;
import org.silverpeas.core.pdc.tree.model.TreeNode;

public class Value
extends TreeNode
implements Serializable {
    private static final long serialVersionUID = 2248040737072584720L;
    ValuePK pk = null;
    private int nbObjects = 0;
    private List<Value> pathValues = null;
    private String axisId = "unknown";
    private String fullPath = null;

    public Value() {
    }

    public Value(String id, String treeId) {
        super(id, treeId);
        this.setValuePK(new ValuePK(id));
    }

    public Value(TreeNode treeNode) {
        super(treeNode.getPK().getId(), treeNode.getTreeId());
        this.setName(treeNode.getName());
        this.setDescription(treeNode.getDescription());
        this.setCreationDate(treeNode.getCreationDate());
        this.setCreatorId(treeNode.getCreatorId());
        this.setPath(treeNode.getPath());
        this.setLevelNumber(treeNode.getLevelNumber());
        this.setOrderNumber(treeNode.getOrderNumber());
        this.setFatherId(treeNode.getFatherId());
        this.setValuePK(new ValuePK(treeNode.getPK().getId()));
    }

    public final void setValuePK(ValuePK pk) {
        this.pk = pk;
    }

    public ValuePK getValuePK() {
        return this.pk;
    }

    public String getMotherId() {
        return this.getFatherId();
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.getPath() + this.getValuePK().getId() + "/";
        }
        return this.fullPath;
    }

    public int getNbObjects() {
        return this.nbObjects;
    }

    public void setNbObjects(int nbObjects) {
        this.nbObjects = nbObjects;
    }

    public void setPathValues(List<Value> pathValues) {
        this.pathValues = pathValues;
    }

    public List<Value> getPathValues() {
        return this.pathValues;
    }

    public void setAxisId(int axisId) {
        this.axisId = Integer.toString(axisId);
    }

    public String getAxisId() {
        return this.axisId;
    }

    public String toString() {
        return "(pk = " + this.getValuePK().toString() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value other = (Value)obj;
        if (!Objects.equals(this.axisId, other.axisId)) {
            return false;
        }
        return this.getFullPath() == null ? other.getFullPath() == null : this.getFullPath().equals(other.getFullPath());
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.axisId != null ? this.axisId.hashCode() : 0);
        hash = 97 * hash + (this.fullPath != null ? this.fullPath.hashCode() : 0);
        return hash;
    }
}

