/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.pdc.pdc.model;

import java.io.Serializable;
import java.util.Objects;
import org.silverpeas.core.i18n.AbstractI18NBean;
import org.silverpeas.core.pdc.pdc.model.AxisHeaderI18N;
import org.silverpeas.core.pdc.pdc.model.AxisHeaderPersistence;
import org.silverpeas.core.pdc.pdc.model.AxisPK;

public class AxisHeader
extends AbstractI18NBean<AxisHeaderI18N>
implements Serializable {
    private static final long serialVersionUID = 5523411511012194843L;
    private AxisPK pk;
    private String type = null;
    private String creationDate = null;
    private String creatorId = null;
    private int order = -1;
    private int rootId = -1;

    protected Class<AxisHeaderI18N> getTranslationType() {
        return AxisHeaderI18N.class;
    }

    public AxisHeader() {
    }

    public AxisHeader(AxisPK pk, String name, String type, int order, String creationDate, String creatorId, int rootId) {
        this.pk = pk;
        this.setName(name);
        this.type = type;
        this.order = order;
        this.creationDate = creationDate;
        this.creatorId = creatorId;
        this.rootId = rootId;
    }

    public AxisHeader(String id, String name, String type, int order, int rootId, String description) {
        this.pk = new AxisPK(id);
        this.setName(name);
        this.setDescription(description);
        this.type = type;
        this.order = order;
        this.rootId = rootId;
    }

    public AxisHeader(String id, String name, String type, int order, int rootId) {
        this.pk = new AxisPK(id);
        this.setName(name);
        this.type = type;
        this.order = order;
        this.rootId = rootId;
    }

    public AxisHeader(AxisHeaderPersistence persistence) {
        this.pk = new AxisPK(persistence.getPK().getId(), persistence.getPK());
        this.setName(persistence.getName());
        this.setDescription(persistence.getDescription());
        this.creationDate = persistence.getCreationDate();
        this.creatorId = persistence.getCreatorId();
        this.order = persistence.getAxisOrder();
        this.rootId = persistence.getRootId();
        this.type = persistence.getAxisType();
        this.setLanguage(persistence.getLang());
    }

    public String getAxisType() {
        return this.type;
    }

    public void setAxisType(String type) {
        this.type = type;
    }

    public int getAxisOrder() {
        return this.order;
    }

    public void setAxisOrder(int order) {
        this.order = order;
    }

    public int getRootId() {
        return this.rootId;
    }

    public void setRootId(int rootId) {
        this.rootId = rootId;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public AxisPK getPK() {
        return this.pk;
    }

    public String toString() {
        return "(pk = " + String.valueOf(this.getPK()) + ", language = " + this.getLanguage() + ", name = " + this.getName() + ", type = " + this.getAxisType() + ", order = " + this.getAxisOrder() + ", creationDate = " + this.getCreationDate() + ", creatorId = " + this.getCreatorId() + ", rootId = " + this.getRootId() + ", description = " + this.getDescription() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AxisHeader other = (AxisHeader)obj;
        return Objects.equals(this.pk, other.pk);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (this.pk != null ? this.pk.hashCode() : 0);
        return hash;
    }
}

