/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.reminder;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class ReminderSettings {
    public static final String SETTINGS_PATH = "org.silverpeas.reminder.settings.reminder";
    public static final String MESSAGES_PATH = "org.silverpeas.reminder.multilang.reminder";

    private ReminderSettings() {
    }

    public static LocalizationBundle getMessagesIn(String language) {
        return ResourceLocator.getLocalizationBundle((String)MESSAGES_PATH, (String)language);
    }

    public static SettingBundle getSettings() {
        return ResourceLocator.getSettingBundle((String)SETTINGS_PATH);
    }

    public static Stream<Pair<Integer, TimeUnit>> getPossibleReminders() {
        return Arrays.stream(ReminderSettings.getSettings().getString("reminder.possible").split(" ")).map(r -> {
            String[] split = r.split("[|]");
            return Pair.of((Object)Integer.parseInt(split[0]), (Object)TimeUnit.valueOf(split[1]));
        });
    }

    public static Pair<Integer, TimeUnit> getDefaultReminder() {
        String[] split = ReminderSettings.getSettings().getString("reminder.default").split("[|]");
        return Pair.of((Object)Integer.parseInt(split[0]), (Object)TimeUnit.valueOf(split[1]));
    }
}

