/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc.sql.setters;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.persistence.jdbc.sql.setters.SqlTemporalParamSetter;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
public class SqlDateParamSetter
extends SqlTemporalParamSetter {
    @Override
    public List<Class<?>> getSupportedTypes() {
        return Arrays.asList(java.sql.Date.class, Date.class, LocalDate.class);
    }

    @Override
    public void setParameter(PreparedStatement statement, int idx, Object value) throws SQLException {
        if (value instanceof java.sql.Date) {
            statement.setDate(idx, (java.sql.Date)value);
        } else if (this.isADate(value)) {
            statement.setDate(idx, new java.sql.Date(this.toInstant(value).toEpochMilli()));
        } else {
            this.throwTypeNotSupported(value.getClass());
        }
    }

    private boolean isADate(Object parameter) {
        return parameter instanceof Date || parameter instanceof LocalDate;
    }
}

