/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractDAO {
    protected AbstractDAO() {
    }

    protected static void setDateParameter(PreparedStatement statement, int idx, Date date, String defaultDate) throws SQLException {
        if (date == null) {
            statement.setString(idx, defaultDate);
        } else {
            statement.setString(idx, DateUtil.formatDate(date));
        }
    }

    protected static void setStringParameter(PreparedStatement statement, int idx, String value, String defaultValue) throws SQLException {
        if (StringUtil.isDefined((String)value)) {
            statement.setString(idx, value);
        } else {
            statement.setString(idx, defaultValue);
        }
    }

    protected static Date asDate(String dateAsSqlString, String nullValue) throws ParseException {
        Date date = nullValue.equals(dateAsSqlString) ? null : DateUtil.parseDate(dateAsSqlString);
        return date;
    }
}

