/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.List;
import java.util.function.Consumer;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventFilter;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.calendar.repository.CalendarEventRepository;
import org.silverpeas.core.date.Period;

public class CalendarTimeWindow {
    private CalendarEventFilter filter = new CalendarEventFilter();
    private final LocalDate startDate;
    private final LocalDate endDate;
    private List<CalendarEvent> events;

    CalendarTimeWindow(LocalDate startDate, LocalDate endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public CalendarTimeWindow filter(Consumer<CalendarEventFilter> filterConsumer) {
        filterConsumer.accept(this.filter);
        return this;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public Period getPeriod() {
        return Period.between(this.getStartDate(), this.getEndDate());
    }

    public List<CalendarEventOccurrence> getEventOccurrences() {
        return CalendarEventOccurrence.getOccurrencesIn(this);
    }

    public List<CalendarEvent> getEvents() {
        if (this.events == null) {
            this.events = CalendarEventRepository.get().getAllBetween(this.filter, this.startDate.atStartOfDay(ZoneOffset.UTC).toInstant(), this.endDate.atStartOfDay(ZoneOffset.UTC).toInstant());
        }
        return this.events;
    }
}

