/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.commit.DefaultThreeWayConflictHandler;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheConflictHandler
extends DefaultThreeWayConflictHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CacheConflictHandler.class);

    protected CacheConflictHandler() {
        super(ThreeWayConflictHandler.Resolution.IGNORED);
    }

    private ThreeWayConflictHandler.Resolution resolveRepExpirationConflict(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, PropertyState base) {
        if (ours.getName() != null && ours.getName().equals(theirs.getName()) && ours.getName().startsWith("rep:expiration")) {
            PropertyBuilder merged = PropertyBuilder.scalar((Type)Type.LONG);
            merged.setName(ours.getName());
            if ((Long)base.getValue(Type.LONG) > (Long)ours.getValue(Type.LONG) && (Long)base.getValue(Type.LONG) > (Long)theirs.getValue(Type.LONG)) {
                merged.setValue((Object)((Long)base.getValue(Type.LONG)));
                LOG.warn("base is bigger than ours and theirs. This was supposed to never happens");
                return ThreeWayConflictHandler.Resolution.MERGED;
            }
            if ((Long)ours.getValue(Type.LONG) > (Long)theirs.getValue(Type.LONG)) {
                merged.setValue((Object)((Long)ours.getValue(Type.LONG)));
            } else {
                merged.setValue((Object)((Long)theirs.getValue(Type.LONG)));
            }
            parent.setProperty(merged.getPropertyState());
            LOG.debug("Resolved conflict for property {} our value: {}, their value {}, merged value: {}", new Object[]{ours.getName(), ours.getValue(Type.LONG), theirs.getValue(Type.LONG), merged.getValue(0)});
            return ThreeWayConflictHandler.Resolution.MERGED;
        }
        return ThreeWayConflictHandler.Resolution.IGNORED;
    }

    @Override
    @NotNull
    public ThreeWayConflictHandler.Resolution changeChangedProperty(@NotNull NodeBuilder parent, @NotNull PropertyState ours, @NotNull PropertyState theirs, @NotNull PropertyState base) {
        return this.resolveRepExpirationConflict(parent, ours, theirs, base);
    }
}

