/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.version.OrphanedVersionCleaner;
import org.apache.jackrabbit.oak.plugins.version.VersionEditorProvider;
import org.apache.jackrabbit.oak.plugins.version.VersionableCollector;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={CommitHook.class})
public class VersionHook
implements CommitHook {
    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
        HashSet<String> existingVersionables = new HashSet<String>();
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new VersionEditorProvider());
        providers.add(new VersionableCollector.Provider(existingVersionables));
        providers.add(new OrphanedVersionCleaner.Provider(existingVersionables));
        return CompositeHook.compose((Collection)providers.stream().map(input -> new EditorHook(input)).collect(Collectors.toList())).processCommit(before, after, info);
    }
}

