/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.commit;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.StreamUtils;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.ConflictType;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MergingNodeStateDiff
extends DefaultNodeStateDiff {
    private static final Logger LOG = LoggerFactory.getLogger(MergingNodeStateDiff.class);
    private final NodeState parent;
    private final NodeBuilder target;
    private final ThreeWayConflictHandler conflictHandler;
    private final Map<ConflictType, PropertyConflictHandler> propertyConflictHandlers = Map.of(ConflictType.ADD_EXISTING_PROPERTY, new PropertyConflictHandler(){

        @Override
        public ThreeWayConflictHandler.Resolution resolve(PropertyState ours, PropertyState theirs, PropertyState base) {
            return MergingNodeStateDiff.this.conflictHandler.addExistingProperty(MergingNodeStateDiff.this.target, ours, theirs);
        }

        public String toString() {
            return "PropertyConflictHandler<ADD_EXISTING_PROPERTY>";
        }
    }, ConflictType.CHANGE_DELETED_PROPERTY, new PropertyConflictHandler(){

        @Override
        public ThreeWayConflictHandler.Resolution resolve(PropertyState ours, PropertyState theirs, PropertyState base) {
            return MergingNodeStateDiff.this.conflictHandler.changeDeletedProperty(MergingNodeStateDiff.this.target, ours, base);
        }

        public String toString() {
            return "PropertyConflictHandler<CHANGE_DELETED_PROPERTY>";
        }
    }, ConflictType.CHANGE_CHANGED_PROPERTY, new PropertyConflictHandler(){

        @Override
        public ThreeWayConflictHandler.Resolution resolve(PropertyState ours, PropertyState theirs, PropertyState base) {
            return MergingNodeStateDiff.this.conflictHandler.changeChangedProperty(MergingNodeStateDiff.this.target, ours, theirs, base);
        }

        public String toString() {
            return "PropertyConflictHandler<CHANGE_CHANGED_PROPERTY>";
        }
    }, ConflictType.DELETE_DELETED_PROPERTY, new PropertyConflictHandler(){

        @Override
        public ThreeWayConflictHandler.Resolution resolve(PropertyState ours, PropertyState theirs, PropertyState base) {
            return MergingNodeStateDiff.this.conflictHandler.deleteDeletedProperty(MergingNodeStateDiff.this.target, base);
        }

        public String toString() {
            return "PropertyConflictHandler<DELETE_DELETED_PROPERTY>";
        }
    }, ConflictType.DELETE_CHANGED_PROPERTY, new PropertyConflictHandler(){

        @Override
        public ThreeWayConflictHandler.Resolution resolve(PropertyState ours, PropertyState theirs, PropertyState base) {
            return MergingNodeStateDiff.this.conflictHandler.deleteChangedProperty(MergingNodeStateDiff.this.target, theirs, base);
        }

        public String toString() {
            return "PropertyConflictHandler<DELETE_CHANGED_PROPERTY>";
        }
    });
    private final Map<ConflictType, NodeConflictHandler> nodeConflictHandlers = Map.of(ConflictType.ADD_EXISTING_NODE, new NodeConflictHandler(){

        @Override
        public ThreeWayConflictHandler.Resolution resolve(String name, NodeState ours, NodeState theirs, NodeState base) {
            return MergingNodeStateDiff.this.conflictHandler.addExistingNode(MergingNodeStateDiff.this.target, name, ours, theirs);
        }

        public String toString() {
            return "NodeConflictHandler<ADD_EXISTING_NODE>";
        }
    }, ConflictType.CHANGE_DELETED_NODE, new NodeConflictHandler(){

        @Override
        public ThreeWayConflictHandler.Resolution resolve(String name, NodeState ours, NodeState theirs, NodeState base) {
            return MergingNodeStateDiff.this.conflictHandler.changeDeletedNode(MergingNodeStateDiff.this.target, name, ours, base);
        }

        public String toString() {
            return "NodeConflictHandler<CHANGE_DELETED_NODE>";
        }
    }, ConflictType.DELETE_CHANGED_NODE, new NodeConflictHandler(){

        @Override
        public ThreeWayConflictHandler.Resolution resolve(String name, NodeState ours, NodeState theirs, NodeState base) {
            return MergingNodeStateDiff.this.conflictHandler.deleteChangedNode(MergingNodeStateDiff.this.target, name, theirs, base);
        }

        public String toString() {
            return "NodeConflictHandler<DELETE_CHANGED_NODE>";
        }
    }, ConflictType.DELETE_DELETED_NODE, new NodeConflictHandler(){

        @Override
        public ThreeWayConflictHandler.Resolution resolve(String name, NodeState ours, NodeState theirs, NodeState base) {
            return MergingNodeStateDiff.this.conflictHandler.deleteDeletedNode(MergingNodeStateDiff.this.target, name, base);
        }

        public String toString() {
            return "NodeConflictHandler<DELETE_DELETED_NODE>";
        }
    });

    private MergingNodeStateDiff(NodeState parent, NodeBuilder target, ThreeWayConflictHandler conflictHandler) {
        this.parent = parent;
        this.target = target;
        this.conflictHandler = conflictHandler;
    }

    static NodeState merge(NodeState fromState, NodeState toState, ThreeWayConflictHandler conflictHandler) {
        return MergingNodeStateDiff.merge(fromState, toState, toState.builder(), conflictHandler).getNodeState();
    }

    private static NodeBuilder merge(NodeState fromState, NodeState toState, NodeBuilder target, ThreeWayConflictHandler conflictHandler) {
        toState.compareAgainstBaseState(fromState, (NodeStateDiff)new MergingNodeStateDiff(toState, target, conflictHandler));
        return target;
    }

    public boolean childNodeAdded(String name, NodeState after) {
        if (":conflict".equals(name)) {
            for (ChildNodeEntry conflict : after.getChildNodeEntries()) {
                this.resolveConflict(ConflictType.fromName((String)conflict.getName()), conflict.getNodeState());
            }
            this.target.getChildNode(":conflict").remove();
        }
        return true;
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        if (this.target.hasChildNode(name)) {
            MergingNodeStateDiff.merge(before, after, this.target.getChildNode(name), this.conflictHandler);
        }
        return true;
    }

    private void resolveConflict(ConflictType conflictType, NodeState conflictInfo) {
        PropertyConflictHandler propertyConflictHandler = this.propertyConflictHandlers.get(conflictType);
        if (propertyConflictHandler != null) {
            String name;
            NodeState oursNS = conflictInfo.getChildNode(":ours");
            NodeState baseNS = conflictInfo.getChildNode(":base");
            HashSet<String> processed = new HashSet<String>();
            for (PropertyState ours : oursNS.getProperties()) {
                name = ours.getName();
                processed.add(name);
                PropertyState base = baseNS.getProperty(name);
                PropertyState theirs = this.parent.getProperty(name);
                ThreeWayConflictHandler.Resolution resolution = propertyConflictHandler.resolve(ours, theirs, base);
                this.applyPropertyResolution(resolution, conflictType, name, ours);
            }
            for (PropertyState base : baseNS.getProperties()) {
                name = base.getName();
                if (processed.contains(name)) continue;
                PropertyState theirs = this.parent.getProperty(name);
                ThreeWayConflictHandler.Resolution resolution = propertyConflictHandler.resolve(null, theirs, base);
                this.applyPropertyResolution(resolution, conflictType, name, null);
            }
        } else {
            NodeConflictHandler nodeConflictHandler = this.nodeConflictHandlers.get(conflictType);
            if (nodeConflictHandler != null) {
                NodeState oursNS = conflictInfo.getChildNode(":ours");
                NodeState baseNS = conflictInfo.getChildNode(":base");
                Set candidates = Stream.concat(StreamUtils.toStream((Iterable)oursNS.getChildNodeNames()), StreamUtils.toStream((Iterable)baseNS.getChildNodeNames())).collect(Collectors.toSet());
                for (String name : candidates) {
                    NodeState ours = oursNS.getChildNode(name);
                    NodeState base = baseNS.getChildNode(name);
                    NodeState theirs = this.parent.getChildNode(name);
                    ThreeWayConflictHandler.Resolution resolution = nodeConflictHandler.resolve(name, ours, theirs, base);
                    this.applyResolution(resolution, conflictType, name, ours);
                    if (!LOG.isDebugEnabled()) continue;
                    String diff = JsopDiff.diffToJsop((NodeState)base, (NodeState)theirs);
                    LOG.debug("{} resolved conflict of type {} with resolution {} on node {}, conflict trace {}", new Object[]{nodeConflictHandler, conflictType, resolution, name, diff});
                }
            } else {
                LOG.warn("Ignoring unknown conflict '" + conflictType + "'");
            }
        }
        NodeBuilder conflictMarker = this.getConflictMarker(conflictType);
        if (conflictMarker != null) {
            assert (conflictMarker.getChildNode(":base").getChildNodeCount(1L) == 0L);
            assert (conflictMarker.getChildNode(":ours").getChildNodeCount(1L) == 0L);
        }
    }

    private void applyPropertyResolution(ThreeWayConflictHandler.Resolution resolution, ConflictType conflictType, String name, PropertyState ours) {
        NodeBuilder oursClean;
        NodeBuilder baseClean;
        NodeBuilder conflictMarker = this.getConflictMarker(conflictType);
        if (resolution == ThreeWayConflictHandler.Resolution.OURS) {
            if (ConflictType.DELETE_CHANGED_PROPERTY == conflictType || ConflictType.DELETE_DELETED_PROPERTY == conflictType) {
                this.target.removeProperty(name);
            } else {
                this.target.setProperty(ours);
            }
        }
        if ((baseClean = conflictMarker.getChildNode(":base")).exists()) {
            baseClean.removeProperty(name);
        }
        if ((oursClean = conflictMarker.getChildNode(":ours")).exists()) {
            oursClean.removeProperty(name);
        }
    }

    private void applyResolution(ThreeWayConflictHandler.Resolution resolution, ConflictType conflictType, String name, NodeState ours) {
        NodeBuilder oursClean;
        NodeBuilder baseClean;
        NodeBuilder conflictMarker = this.getConflictMarker(conflictType);
        if (resolution == ThreeWayConflictHandler.Resolution.OURS) {
            if (ConflictType.DELETE_CHANGED_NODE == conflictType || ConflictType.DELETE_DELETED_NODE == conflictType) {
                MergingNodeStateDiff.removeChild(this.target, name);
            } else {
                MergingNodeStateDiff.addChild(this.target, name, ours);
            }
        }
        if ((baseClean = conflictMarker.getChildNode(":base")).exists()) {
            baseClean.getChildNode(name).remove();
        }
        if ((oursClean = conflictMarker.getChildNode(":ours")).exists()) {
            oursClean.getChildNode(name).remove();
        }
    }

    private NodeBuilder getConflictMarker(ConflictType conflictType) {
        NodeBuilder conflict;
        String conflictName = conflictType.getName();
        if (this.target.hasChildNode(":conflict") && (conflict = this.target.child(":conflict")).hasChildNode(conflictName)) {
            return conflict.child(conflictName);
        }
        return null;
    }

    private static void addChild(NodeBuilder target, String name, NodeState state) {
        target.setChildNode(name, state);
        PropertyState childOrder = target.getProperty(":childOrder");
        if (childOrder != null) {
            PropertyBuilder builder = PropertyBuilder.copy((Type)Type.NAME, (PropertyState)childOrder);
            builder.addValue((Object)name);
            target.setProperty(builder.getPropertyState());
        }
    }

    private static void removeChild(NodeBuilder target, String name) {
        target.getChildNode(name).remove();
        PropertyState childOrder = target.getProperty(":childOrder");
        if (childOrder != null) {
            PropertyBuilder builder = PropertyBuilder.copy((Type)Type.NAME, (PropertyState)childOrder);
            builder.removeValue((Object)name);
            target.setProperty(builder.getPropertyState());
        }
    }

    private static interface NodeConflictHandler {
        public ThreeWayConflictHandler.Resolution resolve(String var1, NodeState var2, NodeState var3, NodeState var4);
    }

    private static interface PropertyConflictHandler {
        public ThreeWayConflictHandler.Resolution resolve(PropertyState var1, PropertyState var2, PropertyState var3);
    }
}

