/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.Subject;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.LazyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.properties.SystemPropertySupplier;
import org.apache.jackrabbit.oak.core.ContentSessionImpl;
import org.apache.jackrabbit.oak.core.MutableTree;
import org.apache.jackrabbit.oak.core.SecureNodeBuilder;
import org.apache.jackrabbit.oak.plugins.index.diffindex.UUIDDiffIndexProviderWrapper;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.QueryEngineImpl;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditorProvider;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.PostValidationHook;
import org.apache.jackrabbit.oak.spi.commit.ResetCommitAttributeHook;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionAware;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.PrefetchNodeStore;
import org.apache.jackrabbit.oak.spi.toggle.Feature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MutableRoot
implements Root,
PermissionAware {
    private final NodeStore store;
    private final CommitHook hook;
    private final String workspaceName;
    private final Subject subject;
    private final SecurityProvider securityProvider;
    private final QueryEngineSettings queryEngineSettings;
    private final QueryIndexProvider indexProvider;
    private final ContentSessionImpl session;
    private final MutableTree rootTree;
    private final NodeBuilder builder;
    private final SecureNodeBuilder secureBuilder;
    private Move lastMove;
    private final MoveTracker moveTracker = new MoveTracker();
    private long modCount;
    private final LazyValue<PermissionProvider> permissionProvider = new LazyValue<PermissionProvider>(){

        protected PermissionProvider createValue() {
            return MutableRoot.this.getAcConfig().getPermissionProvider((Root)MutableRoot.this, MutableRoot.this.getContentSession().getWorkspaceName(), MutableRoot.this.subject.getPrincipals());
        }
    };
    private static final boolean CLASSIC_MOVE = (Boolean)SystemPropertySupplier.create((String)"oak.classicMove", (Object)false).get();

    MutableRoot(NodeStore store, CommitHook hook, String workspaceName, Subject subject, SecurityProvider securityProvider, QueryEngineSettings queryEngineSettings, QueryIndexProvider indexProvider, Feature classicMove, ContentSessionImpl session) {
        this.store = Objects.requireNonNull(store);
        this.hook = Objects.requireNonNull(hook);
        this.workspaceName = Objects.requireNonNull(workspaceName);
        this.subject = Objects.requireNonNull(subject);
        this.securityProvider = Objects.requireNonNull(securityProvider);
        this.queryEngineSettings = queryEngineSettings;
        this.indexProvider = indexProvider;
        this.session = Objects.requireNonNull(session);
        this.lastMove = this.createMove(classicMove);
        this.builder = store.getRoot().builder();
        this.secureBuilder = new SecureNodeBuilder(this.builder, this.permissionProvider);
        this.rootTree = new MutableTree(this, this.secureBuilder, this.lastMove);
    }

    void checkLive() {
        this.session.checkLive();
    }

    @NotNull
    public ContentSession getContentSession() {
        return this.session;
    }

    public boolean move(String sourcePath, String destPath) {
        if (PathUtils.isAncestor((String)Objects.requireNonNull(sourcePath), (String)Objects.requireNonNull(destPath))) {
            return false;
        }
        if (sourcePath.equals(destPath)) {
            return true;
        }
        this.checkLive();
        MutableTree source = this.rootTree.getTree(sourcePath);
        if (!source.exists()) {
            return false;
        }
        String newName = PathUtils.getName((String)destPath);
        MutableTree newParent = this.rootTree.getTree(PathUtils.getParentPath((String)destPath));
        if (!newParent.exists() || newParent.hasChild(newName)) {
            return false;
        }
        boolean success = source.moveTo(newParent, newName);
        if (success) {
            this.lastMove = this.lastMove.setMove(sourcePath, newParent, newName);
            this.updated();
            this.moveTracker.addMove(sourcePath, destPath);
        }
        return success;
    }

    @NotNull
    public MutableTree getTree(@NotNull String path) {
        this.checkLive();
        return this.rootTree.getTree(path);
    }

    public void rebase() {
        this.checkLive();
        this.store.rebase(this.builder);
        this.secureBuilder.baseChanged();
        if (this.permissionProvider.hasValue()) {
            ((PermissionProvider)this.permissionProvider.get()).refresh();
        }
    }

    public final void refresh() {
        this.checkLive();
        this.store.reset(this.builder);
        this.secureBuilder.baseChanged();
        this.modCount = 0L;
        if (this.permissionProvider.hasValue()) {
            ((PermissionProvider)this.permissionProvider.get()).refresh();
        }
    }

    public void commit(@NotNull Map<String, Object> info) throws CommitFailedException {
        this.checkLive();
        ContentSession session = this.getContentSession();
        CommitInfo commitInfo = new CommitInfo(session.toString(), session.getAuthInfo().getUserID(), MutableRoot.newInfoWithCommitContext(info));
        this.store.merge(this.builder, this.getCommitHook(), commitInfo);
        this.secureBuilder.baseChanged();
        this.modCount = 0L;
        if (this.permissionProvider.hasValue()) {
            ((PermissionProvider)this.permissionProvider.get()).refresh();
        }
        this.moveTracker.clear();
    }

    public void commit() throws CommitFailedException {
        this.commit(Collections.emptyMap());
    }

    private CommitHook getCommitHook() {
        ArrayList<Object> hooks = new ArrayList<Object>();
        hooks.add(ResetCommitAttributeHook.INSTANCE);
        hooks.add(this.hook);
        ArrayList<CommitHook> postValidationHooks = new ArrayList<CommitHook>();
        ArrayList validators = new ArrayList();
        for (SecurityConfiguration sc : this.securityProvider.getConfigurations()) {
            for (CommitHook ch : sc.getCommitHooks(this.workspaceName)) {
                if (ch instanceof PostValidationHook) {
                    postValidationHooks.add(ch);
                    continue;
                }
                if (ch == EmptyHook.INSTANCE) continue;
                hooks.add(ch);
            }
            validators.addAll(sc.getValidators(this.workspaceName, this.subject.getPrincipals(), this.moveTracker));
        }
        if (!validators.isEmpty()) {
            hooks.add(new EditorHook(CompositeEditorProvider.compose(validators)));
        }
        hooks.addAll(postValidationHooks);
        return CompositeHook.compose(hooks);
    }

    public boolean hasPendingChanges() {
        this.checkLive();
        return this.modCount > 0L;
    }

    @NotNull
    public QueryEngine getQueryEngine() {
        this.checkLive();
        return new QueryEngineImpl(){

            @Override
            protected ExecutionContext getExecutionContext() {
                QueryIndexProvider provider = MutableRoot.this.indexProvider;
                if (MutableRoot.this.hasPendingChanges()) {
                    provider = new UUIDDiffIndexProviderWrapper(provider, MutableRoot.this.getBaseState(), MutableRoot.this.getRootState());
                }
                return new ExecutionContext(MutableRoot.this.getBaseState(), MutableRoot.this, MutableRoot.this.queryEngineSettings, provider, (PermissionProvider)MutableRoot.this.permissionProvider.get(), MutableRoot.this.store instanceof PrefetchNodeStore ? (PrefetchNodeStore)MutableRoot.this.store : PrefetchNodeStore.NOOP);
            }
        };
    }

    @NotNull
    public Blob createBlob(@NotNull InputStream inputStream) throws IOException {
        this.checkLive();
        return this.store.createBlob(Objects.requireNonNull(inputStream));
    }

    public Blob getBlob(@NotNull String reference) {
        return this.store.getBlob(reference);
    }

    @NotNull
    NodeState getBaseState() {
        return this.builder.getBaseState();
    }

    void updated() {
        ++this.modCount;
    }

    @NotNull
    private NodeState getRootState() {
        return this.builder.getNodeState();
    }

    @NotNull
    private AuthorizationConfiguration getAcConfig() {
        return (AuthorizationConfiguration)this.securityProvider.getConfiguration(AuthorizationConfiguration.class);
    }

    private static Map<String, Object> newInfoWithCommitContext(Map<String, Object> info) {
        HashMap<String, Object> builder = new HashMap<String, Object>();
        builder.putAll(info);
        builder.put("oak.commitAttributes", new SimpleCommitContext());
        return Collections.unmodifiableMap(builder);
    }

    @NotNull
    public PermissionProvider getPermissionProvider() {
        return (PermissionProvider)this.permissionProvider.get();
    }

    Move createMove(@Nullable Feature classicMove) {
        if (CLASSIC_MOVE || classicMove != null && classicMove.isEnabled()) {
            return new ClassicMove();
        }
        return new NeoMove();
    }

    class NeoMove
    implements Move {
        private String source;
        private String destination;
        private NeoMove next;

        NeoMove() {
        }

        @Override
        public Move setMove(String source, MutableTree destParent, String destName) {
            this.destination = PathUtils.concat((String)destParent.getPathInternal(), (String)destName);
            this.source = source;
            this.next = new NeoMove();
            return this.next;
        }

        @Override
        public Move apply(MutableTree tree) {
            NeoMove move = this;
            String path = null;
            while (move.next != null) {
                if (path == null) {
                    path = tree.getPathInternal();
                }
                path = move.rewrite(path);
                move = move.next;
            }
            if (path != null && !path.equals(tree.getPathInternal())) {
                tree.setParentAndName(MutableRoot.this.getTree(PathUtils.getParentPath((String)path)), PathUtils.getName((String)path));
            }
            return move;
        }

        private String rewrite(String path) {
            if (path.equals(this.source)) {
                return this.destination;
            }
            if (PathUtils.isAncestor((String)this.source, (String)path)) {
                return this.destination + path.substring(this.source.length());
            }
            return path;
        }

        public String toString() {
            return this.source == null ? "NIL" : ">" + this.source + ":" + this.destination;
        }
    }

    static class ClassicMove
    implements Move {
        private String source;
        private MutableTree destParent;
        private String destName;
        private ClassicMove next;

        ClassicMove() {
        }

        @Override
        public Move setMove(String source, MutableTree destParent, String destName) {
            this.source = source;
            this.destParent = destParent;
            this.destName = destName;
            this.next = new ClassicMove();
            return this.next;
        }

        @Override
        public Move apply(MutableTree tree) {
            ClassicMove move = this;
            while (move.next != null) {
                if (move.source.equals(tree.getPathInternal())) {
                    tree.setParentAndName(move.destParent, move.destName);
                }
                move = move.next;
            }
            return move;
        }

        public String toString() {
            return this.source == null ? "NIL" : ">" + this.source + ":" + PathUtils.concat((String)this.destParent.getPathInternal(), (String)this.destName);
        }
    }

    static interface Move {
        public Move setMove(String var1, MutableTree var2, String var3);

        public Move apply(MutableTree var1);
    }
}

