/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.score.service;

import java.sql.Connection;
import java.util.Collection;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.questioncontainer.score.dao.ScoreDAO;
import org.silverpeas.core.questioncontainer.score.model.ScoreDetail;
import org.silverpeas.core.questioncontainer.score.model.ScorePK;
import org.silverpeas.core.questioncontainer.score.model.ScoreRuntimeException;
import org.silverpeas.core.questioncontainer.score.service.ScoreService;

@Service
@Singleton
@Transactional(value=Transactional.TxType.SUPPORTS)
public class DefaultScoreService
implements ScoreService {
    private Connection getConnection() {
        try {
            return DBUtil.openConnection();
        }
        catch (Exception re) {
            throw new ScoreRuntimeException(re);
        }
    }

    @Override
    public int getUserNbParticipationsByFatherId(ScorePK scorePK, String fatherId, String userId) {
        Connection con = this.getConnection();
        try {
            int n = ScoreDAO.getUserNbParticipationsByFatherId(con, scorePK, fatherId, userId);
            return n;
        }
        catch (Exception re) {
            throw new ScoreRuntimeException(re);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private int getUserPositionByFatherIdAndParticipationId(ScorePK scorePK, String fatherId, String userId, int participationId) {
        Connection con = this.getConnection();
        try {
            int n = ScoreDAO.getUserPositionByFatherIdAndParticipationId(con, scorePK, fatherId, userId, participationId);
            return n;
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    private void setPositions(Collection<ScoreDetail> scoreDetails) {
        for (ScoreDetail scoreDetail : scoreDetails) {
            scoreDetail.setPosition(this.getUserPositionByFatherIdAndParticipationId(scoreDetail.getScorePK(), scoreDetail.getFatherId(), scoreDetail.getUserId(), scoreDetail.getParticipationId()));
        }
    }

    private void setParticipations(Collection<ScoreDetail> scoreDetails) {
        for (ScoreDetail scoreDetail : scoreDetails) {
            scoreDetail.setNbParticipations(this.getUserNbParticipationsByFatherId(scoreDetail.getScorePK(), scoreDetail.getFatherId(), scoreDetail.getUserId()));
        }
    }

    private void setPosition(ScoreDetail scoreDetail) {
        scoreDetail.setPosition(this.getUserPositionByFatherIdAndParticipationId(scoreDetail.getScorePK(), scoreDetail.getFatherId(), scoreDetail.getUserId(), scoreDetail.getParticipationId()));
    }

    private void setNbParticipation(ScoreDetail scoreDetail) {
        scoreDetail.setNbParticipations(this.getUserNbParticipationsByFatherId(scoreDetail.getScorePK(), scoreDetail.getFatherId(), scoreDetail.getUserId()));
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void addScore(ScoreDetail scoreDetail) {
        Connection con = this.getConnection();
        try {
            ScoreDAO.addScore(con, scoreDetail);
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void updateScore(ScoreDetail scoreDetail) {
        Connection con = this.getConnection();
        try {
            ScoreDAO.updateScore(con, scoreDetail);
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void deleteScore(ScorePK scorePK) {
        Connection con = this.getConnection();
        try {
            ScoreDAO.deleteScore(con, scorePK);
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public void deleteScoreByFatherPK(ScorePK scorePK, String fatherId) {
        Connection con = this.getConnection();
        try {
            ScoreDAO.deleteScoreByFatherPK(con, fatherId);
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ScoreDetail> getAllScores(ScorePK scorePK) {
        Connection con = this.getConnection();
        try {
            Collection<ScoreDetail> allScores = ScoreDAO.getAllScores(con, scorePK);
            this.setParticipations(allScores);
            this.setPositions(allScores);
            Collection<ScoreDetail> collection = allScores;
            return collection;
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ScoreDetail> getUserScores(ScorePK scorePK, String userId) {
        Connection con = this.getConnection();
        try {
            Collection<ScoreDetail> userScores = ScoreDAO.getUserScores(con, scorePK, userId);
            this.setParticipations(userScores);
            this.setPositions(userScores);
            Collection<ScoreDetail> collection = userScores;
            return collection;
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ScoreDetail> getUserScoresByFatherId(ScorePK scorePK, String fatherId, String userId) {
        Connection con = this.getConnection();
        try {
            Collection<ScoreDetail> userScores = ScoreDAO.getUserScoresByFatherId(con, scorePK, fatherId, userId);
            this.setParticipations(userScores);
            this.setPositions(userScores);
            Collection<ScoreDetail> collection = userScores;
            return collection;
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ScoreDetail> getBestScoresByFatherId(ScorePK scorePK, int nbBestScores, String fatherId) {
        Connection con = this.getConnection();
        try {
            Collection<ScoreDetail> bestScores = ScoreDAO.getBestScoresByFatherId(con, scorePK, nbBestScores, fatherId);
            this.setParticipations(bestScores);
            this.setPositions(bestScores);
            Collection<ScoreDetail> collection = bestScores;
            return collection;
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ScoreDetail> getWorstScoresByFatherId(ScorePK scorePK, int nbWorstScores, String fatherId) {
        Connection con = this.getConnection();
        try {
            Collection<ScoreDetail> worstScores = ScoreDAO.getWorstScoresByFatherId(con, scorePK, nbWorstScores, fatherId);
            this.setParticipations(worstScores);
            this.setPositions(worstScores);
            Collection<ScoreDetail> collection = worstScores;
            return collection;
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public int getNbVotersByFatherId(ScorePK scorePK, String fatherId) {
        Connection con = this.getConnection();
        try {
            int n = ScoreDAO.getNbVotersByFatherId(con, scorePK, fatherId);
            return n;
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public float getAverageScoreByFatherId(ScorePK scorePK, String fatherId) {
        Connection con = this.getConnection();
        try {
            float f = ScoreDAO.getAverageScoreByFatherId(con, scorePK, fatherId);
            return f;
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public ScoreDetail getUserScoreByFatherIdAndParticipationId(ScorePK scorePK, String fatherId, String userId, int participationId) {
        Connection con = this.getConnection();
        try {
            ScoreDetail scoreDetail = ScoreDAO.getUserScoreByFatherIdAndParticipationId(con, scorePK, fatherId, userId, participationId);
            this.setNbParticipation(scoreDetail);
            this.setPosition(scoreDetail);
            ScoreDetail scoreDetail2 = scoreDetail;
            return scoreDetail2;
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }

    @Override
    public Collection<ScoreDetail> getScoresByFatherId(ScorePK scorePK, String fatherId) {
        Connection con = this.getConnection();
        try {
            Collection<ScoreDetail> scores = ScoreDAO.getScoresByFatherId(con, scorePK, fatherId);
            this.setParticipations(scores);
            this.setPositions(scores);
            Collection<ScoreDetail> collection = scores;
            return collection;
        }
        catch (Exception e) {
            throw new ScoreRuntimeException(e);
        }
        finally {
            DBUtil.close((Connection)con);
        }
    }
}

