/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.container.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.questioncontainer.container.model.Comment;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader;
import org.silverpeas.core.questioncontainer.container.service.QuestionContainerContentManager;
import org.silverpeas.core.questioncontainer.question.model.Question;
import org.silverpeas.core.questioncontainer.result.model.QuestionResult;

public class QuestionContainerDetail
implements Serializable,
SilverpeasContent {
    private static final long serialVersionUID = -2502073007907742590L;
    private QuestionContainerHeader header = null;
    private Collection<Question> questions = null;
    private Collection<Comment> comments = null;
    private Collection<QuestionResult> votes = null;
    private String jsonPosition = null;
    private String silverObjectId = null;

    public QuestionContainerDetail() {
    }

    public QuestionContainerDetail(QuestionContainerHeader header, Collection<Question> questions, Collection<Comment> comments, Collection<QuestionResult> votes) {
        this.header = header;
        this.questions = questions;
        this.comments = comments;
        this.votes = votes;
    }

    public void setHeader(QuestionContainerHeader header) {
        this.header = header;
    }

    public void setQuestions(Collection<Question> questions) {
        this.questions = questions;
    }

    public void setComments(Collection<Comment> comments) {
        this.comments = comments;
    }

    public void setCurrentUserVotes(Collection<QuestionResult> votes) {
        this.votes = votes;
    }

    public QuestionContainerHeader getHeader() {
        return this.header;
    }

    public Collection<Question> getQuestions() {
        return this.questions;
    }

    public Question getFirstQuestion() {
        Question question = null;
        Collection<Question> questions = this.getQuestions();
        Iterator<Question> it = questions.iterator();
        if (it.hasNext()) {
            question = it.next();
        }
        return question;
    }

    public Collection<Comment> getComments() {
        return this.comments;
    }

    public Collection<QuestionResult> getCurrentUserVotes() {
        return this.votes;
    }

    public String getJsonPosition() {
        return this.jsonPosition;
    }

    public void setJsonPosition(String jsonPosition) {
        this.jsonPosition = jsonPosition;
    }

    public String getComponentInstanceId() {
        return this.getHeader().getInstanceId();
    }

    public String getContributionType() {
        return null;
    }

    public Date getCreationDate() {
        return this.getHeader().getCreationDate();
    }

    public Date getLastUpdateDate() {
        return this.getHeader().getLastUpdateDate();
    }

    public User getCreator() {
        return this.getHeader().getCreator();
    }

    public User getLastUpdater() {
        return this.getHeader().getLastUpdater();
    }

    public String getId() {
        return this.getHeader().getId();
    }

    public String getSilverpeasContentId() {
        if (this.silverObjectId == null) {
            try {
                int objectId = QuestionContainerContentManager.getSilverObjectId(this.getId(), this.getComponentInstanceId());
                if (objectId >= 0) {
                    this.silverObjectId = String.valueOf(objectId);
                }
            }
            catch (ContentManagerException ex) {
                this.silverObjectId = null;
            }
        }
        return this.silverObjectId;
    }

    protected void setSilverpeasContentId(String contentId) {
        this.silverObjectId = contentId;
    }

    public String getTitle() {
        return this.getHeader().getTitle();
    }

    public String getDescription() {
        return this.getHeader().getDescription();
    }
}

