/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.WriteReadyHandler;

public final class StreamSinkChannelWrappingConduit
implements StreamSinkConduit {
    private final StreamSinkChannel channel;

    public StreamSinkChannelWrappingConduit(StreamSinkChannel channel) {
        this.channel = channel;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return this.channel.transferFrom(src, position, count);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return this.channel.transferFrom(source, count, throughBuffer);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.channel.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        return this.channel.write(srcs, offs, len);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return this.channel.writeFinal(src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.channel.writeFinal(srcs, offset, length);
    }

    @Override
    public void terminateWrites() throws IOException {
        this.channel.shutdownWrites();
    }

    @Override
    public boolean isWriteShutdown() {
        return !this.channel.isOpen();
    }

    @Override
    public void resumeWrites() {
        this.channel.resumeWrites();
    }

    @Override
    public void suspendWrites() {
        this.channel.suspendWrites();
    }

    @Override
    public void wakeupWrites() {
        this.channel.wakeupWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.channel.isWriteResumed();
    }

    @Override
    public void awaitWritable() throws IOException {
        this.channel.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.channel.awaitWritable(time, timeUnit);
    }

    @Override
    public XnioIoThread getWriteThread() {
        return this.channel.getIoThread();
    }

    @Override
    public void setWriteReadyHandler(final WriteReadyHandler handler) {
        this.channel.getWriteSetter().set((ChannelListener<? extends StreamSinkChannel>)new ChannelListener<StreamSinkChannel>(){

            @Override
            public void handleEvent(StreamSinkChannel channel) {
                handler.writeReady();
            }
        });
    }

    @Override
    public void truncateWrites() throws IOException {
        this.channel.close();
    }

    @Override
    public boolean flush() throws IOException {
        return this.channel.flush();
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }
}

