/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;
import org.jboss.security.authorization.util.JBossXACMLUtil;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.xacml.core.model.context.ActionType;
import org.jboss.security.xacml.core.model.context.AttributeType;
import org.jboss.security.xacml.core.model.context.EnvironmentType;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResourceType;
import org.jboss.security.xacml.core.model.context.SubjectType;
import org.jboss.security.xacml.factories.RequestAttributeFactory;
import org.jboss.security.xacml.factories.RequestResponseContextFactory;
import org.jboss.security.xacml.interfaces.RequestContext;

public class WebXACMLUtil
extends JBossXACMLUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestContext createXACMLRequest(HttpServletRequest request, RoleGroup callerRoles) throws Exception {
        if (request == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("request");
        }
        if (callerRoles == null) {
            throw PicketBoxMessages.MESSAGES.invalidNullArgument("callerRoles");
        }
        String httpMethod = request.getMethod();
        String action = "GET".equals(httpMethod) ? "read" : "write";
        String actionURIBase = "urn:oasis:names:tc:xacml:2.0:request-param:attribute:";
        Principal principal = request.getUserPrincipal();
        RequestContext requestCtx = RequestResponseContextFactory.createRequestCtx();
        SubjectType subject = new SubjectType();
        subject.getAttribute().add(RequestAttributeFactory.createStringAttributeType((String)"urn:oasis:names:tc:xacml:1.0:subject:subject-id", (String)"jboss.org", (String)principal.getName()));
        Collection<Role> rolesList = callerRoles.getRoles();
        if (rolesList != null) {
            for (Role role : rolesList) {
                String roleName = role.getRoleName();
                AttributeType attSubjectID = RequestAttributeFactory.createStringAttributeType((String)"urn:oasis:names:tc:xacml:2.0:subject:role", (String)"jboss.org", (String)roleName);
                subject.getAttribute().add(attSubjectID);
            }
        }
        ResourceType resourceType = new ResourceType();
        resourceType.getAttribute().add(RequestAttributeFactory.createAnyURIAttributeType((String)"urn:oasis:names:tc:xacml:1.0:resource:resource-id", null, (URI)new URI(request.getRequestURI())));
        ActionType actionType = new ActionType();
        actionType.getAttribute().add(RequestAttributeFactory.createStringAttributeType((String)"urn:oasis:names:tc:xacml:1.0:action:action-id", (String)"jboss.org", (String)action));
        Enumeration enumer = request.getParameterNames();
        while (enumer.hasMoreElements()) {
            String paramName = (String)enumer.nextElement();
            String paramValue = request.getParameter(paramName);
            URI actionUri = new URI(actionURIBase + paramName);
            actionType.getAttribute().add(RequestAttributeFactory.createStringAttributeType((String)actionUri.toASCIIString(), (String)"jboss.org", (String)paramValue));
        }
        EnvironmentType environmentType = new EnvironmentType();
        environmentType.getAttribute().add(RequestAttributeFactory.createDateTimeAttributeType((String)"urn:oasis:names:tc:xacml:1.0:environment:current-time", null));
        RequestType requestType = new RequestType();
        requestType.getSubject().add(subject);
        requestType.getResource().add(resourceType);
        requestType.setAction(actionType);
        requestType.setEnvironment(environmentType);
        requestCtx.setRequest(requestType);
        if (PicketBoxLogger.LOGGER.isDebugEnabled()) {
            ByteArrayOutputStream baos = null;
            try {
                baos = new ByteArrayOutputStream();
                requestCtx.marshall((OutputStream)baos);
                PicketBoxLogger.LOGGER.debug(new String(baos.toByteArray()));
            }
            catch (IOException iOException) {
            }
            finally {
                this.safeClose(baos);
            }
        }
        return requestCtx;
    }

    private void safeClose(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

